// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.serde

import aws.sdk.kotlin.services.redshift.model.Event
import aws.sdk.kotlin.services.redshift.model.SourceType
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeEventDocument(reader: XmlTagReader): Event {
    val builder = Event.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // SourceIdentifier com.amazonaws.redshift#Event$SourceIdentifier
            "SourceIdentifier" -> builder.sourceIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // SourceType com.amazonaws.redshift#Event$SourceType
            "SourceType" -> builder.sourceType = curr.tryData()
                .parse { SourceType.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.redshift#SourceType`)" }
            // Message com.amazonaws.redshift#Event$Message
            "Message" -> builder.message = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // EventCategories com.amazonaws.redshift#Event$EventCategories
            "EventCategories" -> builder.eventCategories = deserializeEventCategoriesListShape(curr)
            // Severity com.amazonaws.redshift#Event$Severity
            "Severity" -> builder.severity = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // Date com.amazonaws.redshift#Event$Date
            "Date" -> builder.date = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.redshift#TStamp`)" }
            // EventId com.amazonaws.redshift#Event$EventId
            "EventId" -> builder.eventId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
