// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.serde

import aws.sdk.kotlin.services.redshift.model.DisableLoggingResponse
import aws.sdk.kotlin.services.redshift.model.LogDestinationType
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DisableLoggingOperationDeserializer: HttpDeserializer.NonStreaming<DisableLoggingResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DisableLoggingResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDisableLoggingError(context, call, payload)
        }
        val builder = DisableLoggingResponse.Builder()

        if (payload != null) {
            deserializeDisableLoggingOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDisableLoggingError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "UnsupportedOperation" -> UnsupportedOperationFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidClusterState" -> InvalidClusterStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ClusterNotFound" -> ClusterNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDisableLoggingOperationBody(builder: DisableLoggingResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "DisableLogging")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // BucketName com.amazonaws.redshift#LoggingStatus$BucketName
            "BucketName" -> builder.bucketName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // LastFailureMessage com.amazonaws.redshift#LoggingStatus$LastFailureMessage
            "LastFailureMessage" -> builder.lastFailureMessage = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // LastFailureTime com.amazonaws.redshift#LoggingStatus$LastFailureTime
            "LastFailureTime" -> builder.lastFailureTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.redshift#TStamp`)" }
            // LastSuccessfulDeliveryTime com.amazonaws.redshift#LoggingStatus$LastSuccessfulDeliveryTime
            "LastSuccessfulDeliveryTime" -> builder.lastSuccessfulDeliveryTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.redshift#TStamp`)" }
            // LogDestinationType com.amazonaws.redshift#LoggingStatus$LogDestinationType
            "LogDestinationType" -> builder.logDestinationType = curr.tryData()
                .parse { LogDestinationType.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.redshift#LogDestinationType`)" }
            // LogExports com.amazonaws.redshift#LoggingStatus$LogExports
            "LogExports" -> builder.logExports = deserializeLogTypeListShape(curr)
            // LoggingEnabled com.amazonaws.redshift#LoggingStatus$LoggingEnabled
            "LoggingEnabled" -> builder.loggingEnabled = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.redshift#Boolean`)" }
            // S3KeyPrefix com.amazonaws.redshift#LoggingStatus$S3KeyPrefix
            "S3KeyPrefix" -> builder.s3KeyPrefix = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            else -> {}
        }
        curr.drop()
    }
}
