// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.serde

import aws.sdk.kotlin.services.redshift.model.DescribeResizeResponse
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseDouble
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.parseLong
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class DescribeResizeOperationDeserializer: HttpDeserializer.NonStreaming<DescribeResizeResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeResizeResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeResizeError(context, call, payload)
        }
        val builder = DescribeResizeResponse.Builder()

        if (payload != null) {
            deserializeDescribeResizeOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeResizeError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResizeNotFound" -> ResizeNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedOperation" -> UnsupportedOperationFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ClusterNotFound" -> ClusterNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeResizeOperationBody(builder: DescribeResizeResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "DescribeResize")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // AvgResizeRateInMegaBytesPerSecond com.amazonaws.redshift#ResizeProgressMessage$AvgResizeRateInMegaBytesPerSecond
            "AvgResizeRateInMegaBytesPerSecond" -> builder.avgResizeRateInMegaBytesPerSecond = curr.tryData()
                .parseDouble()
                .getOrDeserializeErr { "expected (double: `com.amazonaws.redshift#DoubleOptional`)" }
            // DataTransferProgressPercent com.amazonaws.redshift#ResizeProgressMessage$DataTransferProgressPercent
            "DataTransferProgressPercent" -> builder.dataTransferProgressPercent = curr.tryData()
                .parseDouble()
                .getOrDeserializeErr { "expected (double: `com.amazonaws.redshift#DoubleOptional`)" }
            // ElapsedTimeInSeconds com.amazonaws.redshift#ResizeProgressMessage$ElapsedTimeInSeconds
            "ElapsedTimeInSeconds" -> builder.elapsedTimeInSeconds = curr.tryData()
                .parseLong()
                .getOrDeserializeErr { "expected (long: `com.amazonaws.redshift#LongOptional`)" }
            // EstimatedTimeToCompletionInSeconds com.amazonaws.redshift#ResizeProgressMessage$EstimatedTimeToCompletionInSeconds
            "EstimatedTimeToCompletionInSeconds" -> builder.estimatedTimeToCompletionInSeconds = curr.tryData()
                .parseLong()
                .getOrDeserializeErr { "expected (long: `com.amazonaws.redshift#LongOptional`)" }
            // ImportTablesCompleted com.amazonaws.redshift#ResizeProgressMessage$ImportTablesCompleted
            "ImportTablesCompleted" -> builder.importTablesCompleted = deserializeImportTablesCompletedShape(curr)
            // ImportTablesInProgress com.amazonaws.redshift#ResizeProgressMessage$ImportTablesInProgress
            "ImportTablesInProgress" -> builder.importTablesInProgress = deserializeImportTablesInProgressShape(curr)
            // ImportTablesNotStarted com.amazonaws.redshift#ResizeProgressMessage$ImportTablesNotStarted
            "ImportTablesNotStarted" -> builder.importTablesNotStarted = deserializeImportTablesNotStartedShape(curr)
            // Message com.amazonaws.redshift#ResizeProgressMessage$Message
            "Message" -> builder.message = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // ProgressInMegaBytes com.amazonaws.redshift#ResizeProgressMessage$ProgressInMegaBytes
            "ProgressInMegaBytes" -> builder.progressInMegaBytes = curr.tryData()
                .parseLong()
                .getOrDeserializeErr { "expected (long: `com.amazonaws.redshift#LongOptional`)" }
            // ResizeType com.amazonaws.redshift#ResizeProgressMessage$ResizeType
            "ResizeType" -> builder.resizeType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // Status com.amazonaws.redshift#ResizeProgressMessage$Status
            "Status" -> builder.status = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // TargetClusterType com.amazonaws.redshift#ResizeProgressMessage$TargetClusterType
            "TargetClusterType" -> builder.targetClusterType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // TargetEncryptionType com.amazonaws.redshift#ResizeProgressMessage$TargetEncryptionType
            "TargetEncryptionType" -> builder.targetEncryptionType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // TargetNodeType com.amazonaws.redshift#ResizeProgressMessage$TargetNodeType
            "TargetNodeType" -> builder.targetNodeType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // TargetNumberOfNodes com.amazonaws.redshift#ResizeProgressMessage$TargetNumberOfNodes
            "TargetNumberOfNodes" -> builder.targetNumberOfNodes = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.redshift#IntegerOptional`)" }
            // TotalResizeDataInMegaBytes com.amazonaws.redshift#ResizeProgressMessage$TotalResizeDataInMegaBytes
            "TotalResizeDataInMegaBytes" -> builder.totalResizeDataInMegaBytes = curr.tryData()
                .parseLong()
                .getOrDeserializeErr { "expected (long: `com.amazonaws.redshift#LongOptional`)" }
            else -> {}
        }
        curr.drop()
    }
}
