// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.serde

import aws.sdk.kotlin.services.redshift.model.CreateScheduledActionResponse
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.sdk.kotlin.services.redshift.model.ScheduledActionState
import aws.sdk.kotlin.services.redshift.model.ScheduledActionType
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class CreateScheduledActionOperationDeserializer: HttpDeserializer.NonStreaming<CreateScheduledActionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateScheduledActionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateScheduledActionError(context, call, payload)
        }
        val builder = CreateScheduledActionResponse.Builder()

        if (payload != null) {
            deserializeCreateScheduledActionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateScheduledActionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ScheduledActionTypeUnsupported" -> ScheduledActionTypeUnsupportedFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ScheduledActionAlreadyExists" -> ScheduledActionAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedOperation" -> UnsupportedOperationFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidScheduledAction" -> InvalidScheduledActionFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ScheduledActionQuotaExceeded" -> ScheduledActionQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "UnauthorizedOperation" -> UnauthorizedOperationDeserializer().deserialize(context, wrappedCall, payload)
        "ClusterNotFound" -> ClusterNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidSchedule" -> InvalidScheduleFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateScheduledActionOperationBody(builder: CreateScheduledActionResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "CreateScheduledAction")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // EndTime com.amazonaws.redshift#ScheduledAction$EndTime
            "EndTime" -> builder.endTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.redshift#TStamp`)" }
            // IamRole com.amazonaws.redshift#ScheduledAction$IamRole
            "IamRole" -> builder.iamRole = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // NextInvocations com.amazonaws.redshift#ScheduledAction$NextInvocations
            "NextInvocations" -> builder.nextInvocations = deserializeScheduledActionTimeListShape(curr)
            // Schedule com.amazonaws.redshift#ScheduledAction$Schedule
            "Schedule" -> builder.schedule = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // ScheduledActionDescription com.amazonaws.redshift#ScheduledAction$ScheduledActionDescription
            "ScheduledActionDescription" -> builder.scheduledActionDescription = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // ScheduledActionName com.amazonaws.redshift#ScheduledAction$ScheduledActionName
            "ScheduledActionName" -> builder.scheduledActionName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // StartTime com.amazonaws.redshift#ScheduledAction$StartTime
            "StartTime" -> builder.startTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.redshift#TStamp`)" }
            // State com.amazonaws.redshift#ScheduledAction$State
            "State" -> builder.state = curr.tryData()
                .parse { ScheduledActionState.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.redshift#ScheduledActionState`)" }
            // TargetAction com.amazonaws.redshift#ScheduledAction$TargetAction
            "TargetAction" -> builder.targetAction = deserializeScheduledActionTypeDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
