// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.serde

import aws.sdk.kotlin.services.redshift.model.CreateEndpointAccessResponse
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.sdk.kotlin.services.redshift.model.VpcEndpoint
import aws.sdk.kotlin.services.redshift.model.VpcSecurityGroupMembership
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class CreateEndpointAccessOperationDeserializer: HttpDeserializer.NonStreaming<CreateEndpointAccessResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateEndpointAccessResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateEndpointAccessError(context, call, payload)
        }
        val builder = CreateEndpointAccessResponse.Builder()

        if (payload != null) {
            deserializeCreateEndpointAccessOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateEndpointAccessError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "EndpointsPerAuthorizationLimitExceeded" -> EndpointsPerAuthorizationLimitExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ClusterSubnetGroupNotFoundFault" -> ClusterSubnetGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedOperation" -> UnsupportedOperationFaultDeserializer().deserialize(context, wrappedCall, payload)
        "EndpointAlreadyExists" -> EndpointAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidClusterState" -> InvalidClusterStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "AccessToClusterDenied" -> AccessToClusterDeniedFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidClusterSecurityGroupState" -> InvalidClusterSecurityGroupStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "EndpointsPerClusterLimitExceeded" -> EndpointsPerClusterLimitExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "UnauthorizedOperation" -> UnauthorizedOperationDeserializer().deserialize(context, wrappedCall, payload)
        "ClusterNotFound" -> ClusterNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateEndpointAccessOperationBody(builder: CreateEndpointAccessResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "CreateEndpointAccess")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // Address com.amazonaws.redshift#EndpointAccess$Address
            "Address" -> builder.address = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // ClusterIdentifier com.amazonaws.redshift#EndpointAccess$ClusterIdentifier
            "ClusterIdentifier" -> builder.clusterIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // EndpointCreateTime com.amazonaws.redshift#EndpointAccess$EndpointCreateTime
            "EndpointCreateTime" -> builder.endpointCreateTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.redshift#TStamp`)" }
            // EndpointName com.amazonaws.redshift#EndpointAccess$EndpointName
            "EndpointName" -> builder.endpointName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // EndpointStatus com.amazonaws.redshift#EndpointAccess$EndpointStatus
            "EndpointStatus" -> builder.endpointStatus = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // Port com.amazonaws.redshift#EndpointAccess$Port
            "Port" -> builder.port = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.redshift#Integer`)" }
            // ResourceOwner com.amazonaws.redshift#EndpointAccess$ResourceOwner
            "ResourceOwner" -> builder.resourceOwner = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // SubnetGroupName com.amazonaws.redshift#EndpointAccess$SubnetGroupName
            "SubnetGroupName" -> builder.subnetGroupName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // VpcEndpoint com.amazonaws.redshift#EndpointAccess$VpcEndpoint
            "VpcEndpoint" -> builder.vpcEndpoint = deserializeVpcEndpointDocument(curr)
            // VpcSecurityGroups com.amazonaws.redshift#EndpointAccess$VpcSecurityGroups
            "VpcSecurityGroups" -> builder.vpcSecurityGroups = deserializeVpcSecurityGroupMembershipListShape(curr)
            else -> {}
        }
        curr.drop()
    }
}
