// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.serde

import aws.sdk.kotlin.services.redshift.model.CreateClusterSnapshotResponse
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.sdk.kotlin.services.redshift.model.Snapshot
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class CreateClusterSnapshotOperationDeserializer: HttpDeserializer.NonStreaming<CreateClusterSnapshotResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateClusterSnapshotResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateClusterSnapshotError(context, call, payload)
        }
        val builder = CreateClusterSnapshotResponse.Builder()

        if (payload != null) {
            deserializeCreateClusterSnapshotOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateClusterSnapshotError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ClusterSnapshotAlreadyExists" -> ClusterSnapshotAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidClusterState" -> InvalidClusterStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "TagLimitExceededFault" -> TagLimitExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ClusterSnapshotQuotaExceeded" -> ClusterSnapshotQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRetentionPeriodFault" -> InvalidRetentionPeriodFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ClusterNotFound" -> ClusterNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidTagFault" -> InvalidTagFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateClusterSnapshotOperationBody(builder: CreateClusterSnapshotResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "CreateClusterSnapshot")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // Snapshot com.amazonaws.redshift#CreateClusterSnapshotResult$Snapshot
            "Snapshot" -> builder.snapshot = deserializeSnapshotDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
