// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.serde

import aws.sdk.kotlin.services.redshift.model.ClusterSecurityGroup
import aws.sdk.kotlin.services.redshift.model.CreateClusterSecurityGroupResponse
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class CreateClusterSecurityGroupOperationDeserializer: HttpDeserializer.NonStreaming<CreateClusterSecurityGroupResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateClusterSecurityGroupResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateClusterSecurityGroupError(context, call, payload)
        }
        val builder = CreateClusterSecurityGroupResponse.Builder()

        if (payload != null) {
            deserializeCreateClusterSecurityGroupOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateClusterSecurityGroupError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "QuotaExceeded.ClusterSecurityGroup" -> ClusterSecurityGroupQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ClusterSecurityGroupAlreadyExists" -> ClusterSecurityGroupAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload)
        "TagLimitExceededFault" -> TagLimitExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidTagFault" -> InvalidTagFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateClusterSecurityGroupOperationBody(builder: CreateClusterSecurityGroupResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "CreateClusterSecurityGroup")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // ClusterSecurityGroup com.amazonaws.redshift#CreateClusterSecurityGroupResult$ClusterSecurityGroup
            "ClusterSecurityGroup" -> builder.clusterSecurityGroup = deserializeClusterSecurityGroupDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
