// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.serde

import aws.sdk.kotlin.services.redshift.model.ClusterParameterGroup
import aws.sdk.kotlin.services.redshift.model.CreateClusterParameterGroupResponse
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class CreateClusterParameterGroupOperationDeserializer: HttpDeserializer.NonStreaming<CreateClusterParameterGroupResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateClusterParameterGroupResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateClusterParameterGroupError(context, call, payload)
        }
        val builder = CreateClusterParameterGroupResponse.Builder()

        if (payload != null) {
            deserializeCreateClusterParameterGroupOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateClusterParameterGroupError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ClusterParameterGroupAlreadyExists" -> ClusterParameterGroupAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ClusterParameterGroupQuotaExceeded" -> ClusterParameterGroupQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "TagLimitExceededFault" -> TagLimitExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidTagFault" -> InvalidTagFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateClusterParameterGroupOperationBody(builder: CreateClusterParameterGroupResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "CreateClusterParameterGroup")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // ClusterParameterGroup com.amazonaws.redshift#CreateClusterParameterGroupResult$ClusterParameterGroup
            "ClusterParameterGroup" -> builder.clusterParameterGroup = deserializeClusterParameterGroupDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
