// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.serde

import aws.sdk.kotlin.services.redshift.model.BatchDeleteClusterSnapshotsResponse
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.sdk.kotlin.services.redshift.model.SnapshotErrorMessage
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class BatchDeleteClusterSnapshotsOperationDeserializer: HttpDeserializer.NonStreaming<BatchDeleteClusterSnapshotsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): BatchDeleteClusterSnapshotsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwBatchDeleteClusterSnapshotsError(context, call, payload)
        }
        val builder = BatchDeleteClusterSnapshotsResponse.Builder()

        if (payload != null) {
            deserializeBatchDeleteClusterSnapshotsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwBatchDeleteClusterSnapshotsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BatchDeleteRequestSizeExceeded" -> BatchDeleteRequestSizeExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchDeleteClusterSnapshotsOperationBody(builder: BatchDeleteClusterSnapshotsResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "BatchDeleteClusterSnapshots")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // Errors com.amazonaws.redshift#BatchDeleteClusterSnapshotsResult$Errors
            "Errors" -> builder.errors = deserializeBatchSnapshotOperationErrorListShape(curr)
            // Resources com.amazonaws.redshift#BatchDeleteClusterSnapshotsResult$Resources
            "Resources" -> builder.resources = deserializeSnapshotIdentifierListShape(curr)
            else -> {}
        }
        curr.drop()
    }
}
