// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.serde

import aws.sdk.kotlin.services.redshift.model.AuthorizeSnapshotAccessResponse
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.sdk.kotlin.services.redshift.model.Snapshot
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class AuthorizeSnapshotAccessOperationDeserializer: HttpDeserializer.NonStreaming<AuthorizeSnapshotAccessResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): AuthorizeSnapshotAccessResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwAuthorizeSnapshotAccessError(context, call, payload)
        }
        val builder = AuthorizeSnapshotAccessResponse.Builder()

        if (payload != null) {
            deserializeAuthorizeSnapshotAccessOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwAuthorizeSnapshotAccessError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AuthorizationQuotaExceeded" -> AuthorizationQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedOperation" -> UnsupportedOperationFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ClusterSnapshotNotFound" -> ClusterSnapshotNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DependentServiceRequestThrottlingFault" -> DependentServiceRequestThrottlingFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidClusterSnapshotState" -> InvalidClusterSnapshotStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "LimitExceededFault" -> LimitExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "AuthorizationAlreadyExists" -> AuthorizationAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeAuthorizeSnapshotAccessOperationBody(builder: AuthorizeSnapshotAccessResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "AuthorizeSnapshotAccess")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // Snapshot com.amazonaws.redshift#AuthorizeSnapshotAccessResult$Snapshot
            "Snapshot" -> builder.snapshot = deserializeSnapshotDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
