// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.serde

import aws.sdk.kotlin.services.redshift.model.AuthorizationStatus
import aws.sdk.kotlin.services.redshift.model.AuthorizeEndpointAccessResponse
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class AuthorizeEndpointAccessOperationDeserializer: HttpDeserializer.NonStreaming<AuthorizeEndpointAccessResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): AuthorizeEndpointAccessResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwAuthorizeEndpointAccessError(context, call, payload)
        }
        val builder = AuthorizeEndpointAccessResponse.Builder()

        if (payload != null) {
            deserializeAuthorizeEndpointAccessOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwAuthorizeEndpointAccessError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "UnsupportedOperation" -> UnsupportedOperationFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidClusterState" -> InvalidClusterStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidAuthorizationState" -> InvalidAuthorizationStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "EndpointAuthorizationsPerClusterLimitExceeded" -> EndpointAuthorizationsPerClusterLimitExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ClusterNotFound" -> ClusterNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "EndpointAuthorizationAlreadyExists" -> EndpointAuthorizationAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeAuthorizeEndpointAccessOperationBody(builder: AuthorizeEndpointAccessResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "AuthorizeEndpointAccess")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // AllowedAllVPCs com.amazonaws.redshift#EndpointAuthorization$AllowedAllVPCs
            "AllowedAllVPCs" -> builder.allowedAllVpcs = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.redshift#Boolean`)" }
            // AllowedVPCs com.amazonaws.redshift#EndpointAuthorization$AllowedVPCs
            "AllowedVPCs" -> builder.allowedVpcs = deserializeVpcIdentifierListShape(curr)
            // AuthorizeTime com.amazonaws.redshift#EndpointAuthorization$AuthorizeTime
            "AuthorizeTime" -> builder.authorizeTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.redshift#TStamp`)" }
            // ClusterIdentifier com.amazonaws.redshift#EndpointAuthorization$ClusterIdentifier
            "ClusterIdentifier" -> builder.clusterIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // ClusterStatus com.amazonaws.redshift#EndpointAuthorization$ClusterStatus
            "ClusterStatus" -> builder.clusterStatus = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // EndpointCount com.amazonaws.redshift#EndpointAuthorization$EndpointCount
            "EndpointCount" -> builder.endpointCount = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.redshift#Integer`)" }
            // Grantee com.amazonaws.redshift#EndpointAuthorization$Grantee
            "Grantee" -> builder.grantee = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // Grantor com.amazonaws.redshift#EndpointAuthorization$Grantor
            "Grantor" -> builder.grantor = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // Status com.amazonaws.redshift#EndpointAuthorization$Status
            "Status" -> builder.status = curr.tryData()
                .parse { AuthorizationStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.redshift#AuthorizationStatus`)" }
            else -> {}
        }
        curr.drop()
    }
}
