// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 *
 */
public class RestoreFromClusterSnapshotRequest private constructor(builder: Builder) {
    /**
     * Reserved.
     */
    public val additionalInfo: kotlin.String? = builder.additionalInfo
    /**
     * If `true`, major version upgrades can be applied during the maintenance window to the Amazon Redshift engine that is running on the cluster.
     *
     * Default: `true`
     */
    public val allowVersionUpgrade: kotlin.Boolean? = builder.allowVersionUpgrade
    /**
     * This parameter is retired. It does not set the AQUA configuration status. Amazon Redshift automatically determines whether to use AQUA (Advanced Query Accelerator).
     */
    public val aquaConfigurationStatus: aws.sdk.kotlin.services.redshift.model.AquaConfigurationStatus? = builder.aquaConfigurationStatus
    /**
     * The number of days that automated snapshots are retained. If the value is 0, automated snapshots are disabled. Even if automated snapshots are disabled, you can still create manual snapshots when you want with CreateClusterSnapshot.
     *
     * You can't disable automated snapshots for RA3 node types. Set the automated retention period from 1-35 days.
     *
     * Default: The value selected for the cluster from which the snapshot was taken.
     *
     * Constraints: Must be a value from 0 to 35.
     */
    public val automatedSnapshotRetentionPeriod: kotlin.Int? = builder.automatedSnapshotRetentionPeriod
    /**
     * The Amazon EC2 Availability Zone in which to restore the cluster.
     *
     * Default: A random, system-chosen Availability Zone.
     *
     * Example: `us-east-2a`
     */
    public val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster is restored.
     */
    public val availabilityZoneRelocation: kotlin.Boolean? = builder.availabilityZoneRelocation
    /**
     * The identifier of the cluster that will be created from restoring the snapshot.
     *
     * Constraints:
     * + Must contain from 1 to 63 alphanumeric characters or hyphens.
     * + Alphabetic characters must be lowercase.
     * + First character must be a letter.
     * + Cannot end with a hyphen or contain two consecutive hyphens.
     * + Must be unique for all clusters within an Amazon Web Services account.
     */
    public val clusterIdentifier: kotlin.String? = builder.clusterIdentifier
    /**
     * The name of the parameter group to be associated with this cluster.
     *
     * Default: The default Amazon Redshift cluster parameter group. For information about the default parameter group, go to [Working with Amazon Redshift Parameter Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html).
     *
     * Constraints:
     * + Must be 1 to 255 alphanumeric characters or hyphens.
     * + First character must be a letter.
     * + Cannot end with a hyphen or contain two consecutive hyphens.
     */
    public val clusterParameterGroupName: kotlin.String? = builder.clusterParameterGroupName
    /**
     * A list of security groups to be associated with this cluster.
     *
     * Default: The default cluster security group for Amazon Redshift.
     *
     * Cluster security groups only apply to clusters outside of VPCs.
     */
    public val clusterSecurityGroups: List<String>? = builder.clusterSecurityGroups
    /**
     * The name of the subnet group where you want to cluster restored.
     *
     * A snapshot of cluster in VPC can be restored only in VPC. Therefore, you must provide subnet group name where you want the cluster restored.
     */
    public val clusterSubnetGroupName: kotlin.String? = builder.clusterSubnetGroupName
    /**
     * The Amazon Resource Name (ARN) for the IAM role that was set as default for the cluster when the cluster was last modified while it was restored from a snapshot.
     */
    public val defaultIamRoleArn: kotlin.String? = builder.defaultIamRoleArn
    /**
     * The Elastic IP (EIP) address for the cluster. Don't specify the Elastic IP address for a publicly accessible cluster with availability zone relocation turned on.
     */
    public val elasticIp: kotlin.String? = builder.elasticIp
    /**
     * Enables support for restoring an unencrypted snapshot to a cluster encrypted with Key Management Service (KMS) and a customer managed key.
     */
    public val encrypted: kotlin.Boolean? = builder.encrypted
    /**
     * An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see [Enhanced VPC Routing](https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html) in the Amazon Redshift Cluster Management Guide.
     *
     * If this option is `true`, enhanced VPC routing is enabled.
     *
     * Default: false
     */
    public val enhancedVpcRouting: kotlin.Boolean? = builder.enhancedVpcRouting
    /**
     * Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data encryption keys stored in an HSM.
     */
    public val hsmClientCertificateIdentifier: kotlin.String? = builder.hsmClientCertificateIdentifier
    /**
     * Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster can use to retrieve and store keys in an HSM.
     */
    public val hsmConfigurationIdentifier: kotlin.String? = builder.hsmConfigurationIdentifier
    /**
     * A list of Identity and Access Management (IAM) roles that can be used by the cluster to access other Amazon Web Services services. You must supply the IAM roles in their Amazon Resource Name (ARN) format.
     *
     * The maximum number of IAM roles that you can associate is subject to a quota. For more information, go to [Quotas and limits](https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    public val iamRoles: List<String>? = builder.iamRoles
    /**
     * The IP address type for the cluster. Possible values are `ipv4` and `dualstack`.
     */
    public val ipAddressType: kotlin.String? = builder.ipAddressType
    /**
     * The Key Management Service (KMS) key ID of the encryption key that encrypts data in the cluster restored from a shared snapshot. You can also provide the key ID when you restore from an unencrypted snapshot to an encrypted cluster in the same account. Additionally, you can specify a new KMS key ID when you restore from an encrypted snapshot in the same account in order to change it. In that case, the restored cluster is encrypted with the new KMS key ID.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The name of the maintenance track for the restored cluster. When you take a snapshot, the snapshot inherits the `MaintenanceTrack` value from the cluster. The snapshot might be on a different track than the cluster that was the source for the snapshot. For example, suppose that you take a snapshot of a cluster that is on the current track and then change the cluster to be on the trailing track. In this case, the snapshot and the source cluster are on different tracks.
     */
    public val maintenanceTrackName: kotlin.String? = builder.maintenanceTrackName
    /**
     * If `true`, Amazon Redshift uses Secrets Manager to manage the restored cluster's admin credentials. If `ManageMasterPassword` is false or not set, Amazon Redshift uses the admin credentials the cluster had at the time the snapshot was taken.
     */
    public val manageMasterPassword: kotlin.Boolean? = builder.manageMasterPassword
    /**
     * The default number of days to retain a manual snapshot. If the value is -1, the snapshot is retained indefinitely. This setting doesn't change the retention period of existing snapshots.
     *
     * The value must be either -1 or an integer between 1 and 3,653.
     */
    public val manualSnapshotRetentionPeriod: kotlin.Int? = builder.manualSnapshotRetentionPeriod
    /**
     * The ID of the Key Management Service (KMS) key used to encrypt and store the cluster's admin credentials secret. You can only use this parameter if `ManageMasterPassword` is true.
     */
    public val masterPasswordSecretKmsKeyId: kotlin.String? = builder.masterPasswordSecretKmsKeyId
    /**
     * If true, the snapshot will be restored to a cluster deployed in two Availability Zones.
     */
    public val multiAz: kotlin.Boolean? = builder.multiAz
    /**
     * The node type that the restored cluster will be provisioned with.
     *
     * If you have a DC instance type, you must restore into that same instance type and size. In other words, you can only restore a dc2.large node type into another dc2 type. For more information about node types, see [ About Clusters and Nodes](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-about-clusters-and-nodes) in the *Amazon Redshift Cluster Management Guide*.
     */
    public val nodeType: kotlin.String? = builder.nodeType
    /**
     * The number of nodes specified when provisioning the restored cluster.
     */
    public val numberOfNodes: kotlin.Int? = builder.numberOfNodes
    /**
     * The Amazon Web Services account used to create or copy the snapshot. Required if you are restoring a snapshot you do not own, optional if you own the snapshot.
     */
    public val ownerAccount: kotlin.String? = builder.ownerAccount
    /**
     * The port number on which the cluster accepts connections.
     *
     * Default: The same port as the original cluster.
     *
     * Valid values: For clusters with DC2 nodes, must be within the range `1150`-`65535`. For clusters with ra3 nodes, must be within the ranges `5431`-`5455` or `8191`-`8215`.
     */
    public val port: kotlin.Int? = builder.port
    /**
     * The weekly time range (in UTC) during which automated cluster maintenance can occur.
     *
     *  Format: `ddd:hh24:mi-ddd:hh24:mi`
     *
     *  Default: The value selected for the cluster from which the snapshot was taken. For more information about the time blocks for each region, see [Maintenance Windows](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-maintenance-windows) in Amazon Redshift Cluster Management Guide.
     *
     * Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
     *
     * Constraints: Minimum 30-minute window.
     */
    public val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow
    /**
     * If `true`, the cluster can be accessed from a public network.
     */
    public val publiclyAccessible: kotlin.Boolean? = builder.publiclyAccessible
    /**
     * The identifier of the target reserved node offering.
     */
    public val reservedNodeId: kotlin.String? = builder.reservedNodeId
    /**
     * The Amazon Resource Name (ARN) of the snapshot associated with the message to restore from a cluster. You must specify this parameter or `snapshotIdentifier`, but not both.
     */
    public val snapshotArn: kotlin.String? = builder.snapshotArn
    /**
     * The name of the cluster the source snapshot was created from. This parameter is required if your IAM user has a policy containing a snapshot resource element that specifies anything other than * for the cluster name.
     */
    public val snapshotClusterIdentifier: kotlin.String? = builder.snapshotClusterIdentifier
    /**
     * The name of the snapshot from which to create the new cluster. This parameter isn't case sensitive. You must specify this parameter or `snapshotArn`, but not both.
     *
     * Example: `my-snapshot-id`
     */
    public val snapshotIdentifier: kotlin.String? = builder.snapshotIdentifier
    /**
     * A unique identifier for the snapshot schedule.
     */
    public val snapshotScheduleIdentifier: kotlin.String? = builder.snapshotScheduleIdentifier
    /**
     * The identifier of the target reserved node offering.
     */
    public val targetReservedNodeOfferingId: kotlin.String? = builder.targetReservedNodeOfferingId
    /**
     * A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.
     *
     * Default: The default VPC security group is associated with the cluster.
     *
     * VPC security groups only apply to clusters in VPCs.
     */
    public val vpcSecurityGroupIds: List<String>? = builder.vpcSecurityGroupIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.RestoreFromClusterSnapshotRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RestoreFromClusterSnapshotRequest(")
        append("additionalInfo=$additionalInfo,")
        append("allowVersionUpgrade=$allowVersionUpgrade,")
        append("aquaConfigurationStatus=$aquaConfigurationStatus,")
        append("automatedSnapshotRetentionPeriod=$automatedSnapshotRetentionPeriod,")
        append("availabilityZone=$availabilityZone,")
        append("availabilityZoneRelocation=$availabilityZoneRelocation,")
        append("clusterIdentifier=$clusterIdentifier,")
        append("clusterParameterGroupName=$clusterParameterGroupName,")
        append("clusterSecurityGroups=$clusterSecurityGroups,")
        append("clusterSubnetGroupName=$clusterSubnetGroupName,")
        append("defaultIamRoleArn=$defaultIamRoleArn,")
        append("elasticIp=$elasticIp,")
        append("encrypted=$encrypted,")
        append("enhancedVpcRouting=$enhancedVpcRouting,")
        append("hsmClientCertificateIdentifier=$hsmClientCertificateIdentifier,")
        append("hsmConfigurationIdentifier=$hsmConfigurationIdentifier,")
        append("iamRoles=$iamRoles,")
        append("ipAddressType=$ipAddressType,")
        append("kmsKeyId=$kmsKeyId,")
        append("maintenanceTrackName=$maintenanceTrackName,")
        append("manageMasterPassword=$manageMasterPassword,")
        append("manualSnapshotRetentionPeriod=$manualSnapshotRetentionPeriod,")
        append("masterPasswordSecretKmsKeyId=$masterPasswordSecretKmsKeyId,")
        append("multiAz=$multiAz,")
        append("nodeType=$nodeType,")
        append("numberOfNodes=$numberOfNodes,")
        append("ownerAccount=$ownerAccount,")
        append("port=$port,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("publiclyAccessible=$publiclyAccessible,")
        append("reservedNodeId=$reservedNodeId,")
        append("snapshotArn=$snapshotArn,")
        append("snapshotClusterIdentifier=$snapshotClusterIdentifier,")
        append("snapshotIdentifier=$snapshotIdentifier,")
        append("snapshotScheduleIdentifier=$snapshotScheduleIdentifier,")
        append("targetReservedNodeOfferingId=$targetReservedNodeOfferingId,")
        append("vpcSecurityGroupIds=$vpcSecurityGroupIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalInfo?.hashCode() ?: 0
        result = 31 * result + (allowVersionUpgrade?.hashCode() ?: 0)
        result = 31 * result + (aquaConfigurationStatus?.hashCode() ?: 0)
        result = 31 * result + (automatedSnapshotRetentionPeriod ?: 0)
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (availabilityZoneRelocation?.hashCode() ?: 0)
        result = 31 * result + (clusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (clusterParameterGroupName?.hashCode() ?: 0)
        result = 31 * result + (clusterSecurityGroups?.hashCode() ?: 0)
        result = 31 * result + (clusterSubnetGroupName?.hashCode() ?: 0)
        result = 31 * result + (defaultIamRoleArn?.hashCode() ?: 0)
        result = 31 * result + (elasticIp?.hashCode() ?: 0)
        result = 31 * result + (encrypted?.hashCode() ?: 0)
        result = 31 * result + (enhancedVpcRouting?.hashCode() ?: 0)
        result = 31 * result + (hsmClientCertificateIdentifier?.hashCode() ?: 0)
        result = 31 * result + (hsmConfigurationIdentifier?.hashCode() ?: 0)
        result = 31 * result + (iamRoles?.hashCode() ?: 0)
        result = 31 * result + (ipAddressType?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (maintenanceTrackName?.hashCode() ?: 0)
        result = 31 * result + (manageMasterPassword?.hashCode() ?: 0)
        result = 31 * result + (manualSnapshotRetentionPeriod ?: 0)
        result = 31 * result + (masterPasswordSecretKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (multiAz?.hashCode() ?: 0)
        result = 31 * result + (nodeType?.hashCode() ?: 0)
        result = 31 * result + (numberOfNodes ?: 0)
        result = 31 * result + (ownerAccount?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (publiclyAccessible?.hashCode() ?: 0)
        result = 31 * result + (reservedNodeId?.hashCode() ?: 0)
        result = 31 * result + (snapshotArn?.hashCode() ?: 0)
        result = 31 * result + (snapshotClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (snapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (snapshotScheduleIdentifier?.hashCode() ?: 0)
        result = 31 * result + (targetReservedNodeOfferingId?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroupIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RestoreFromClusterSnapshotRequest

        if (additionalInfo != other.additionalInfo) return false
        if (allowVersionUpgrade != other.allowVersionUpgrade) return false
        if (aquaConfigurationStatus != other.aquaConfigurationStatus) return false
        if (automatedSnapshotRetentionPeriod != other.automatedSnapshotRetentionPeriod) return false
        if (availabilityZone != other.availabilityZone) return false
        if (availabilityZoneRelocation != other.availabilityZoneRelocation) return false
        if (clusterIdentifier != other.clusterIdentifier) return false
        if (clusterParameterGroupName != other.clusterParameterGroupName) return false
        if (clusterSecurityGroups != other.clusterSecurityGroups) return false
        if (clusterSubnetGroupName != other.clusterSubnetGroupName) return false
        if (defaultIamRoleArn != other.defaultIamRoleArn) return false
        if (elasticIp != other.elasticIp) return false
        if (encrypted != other.encrypted) return false
        if (enhancedVpcRouting != other.enhancedVpcRouting) return false
        if (hsmClientCertificateIdentifier != other.hsmClientCertificateIdentifier) return false
        if (hsmConfigurationIdentifier != other.hsmConfigurationIdentifier) return false
        if (iamRoles != other.iamRoles) return false
        if (ipAddressType != other.ipAddressType) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (maintenanceTrackName != other.maintenanceTrackName) return false
        if (manageMasterPassword != other.manageMasterPassword) return false
        if (manualSnapshotRetentionPeriod != other.manualSnapshotRetentionPeriod) return false
        if (masterPasswordSecretKmsKeyId != other.masterPasswordSecretKmsKeyId) return false
        if (multiAz != other.multiAz) return false
        if (nodeType != other.nodeType) return false
        if (numberOfNodes != other.numberOfNodes) return false
        if (ownerAccount != other.ownerAccount) return false
        if (port != other.port) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (publiclyAccessible != other.publiclyAccessible) return false
        if (reservedNodeId != other.reservedNodeId) return false
        if (snapshotArn != other.snapshotArn) return false
        if (snapshotClusterIdentifier != other.snapshotClusterIdentifier) return false
        if (snapshotIdentifier != other.snapshotIdentifier) return false
        if (snapshotScheduleIdentifier != other.snapshotScheduleIdentifier) return false
        if (targetReservedNodeOfferingId != other.targetReservedNodeOfferingId) return false
        if (vpcSecurityGroupIds != other.vpcSecurityGroupIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.RestoreFromClusterSnapshotRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Reserved.
         */
        public var additionalInfo: kotlin.String? = null
        /**
         * If `true`, major version upgrades can be applied during the maintenance window to the Amazon Redshift engine that is running on the cluster.
         *
         * Default: `true`
         */
        public var allowVersionUpgrade: kotlin.Boolean? = null
        /**
         * This parameter is retired. It does not set the AQUA configuration status. Amazon Redshift automatically determines whether to use AQUA (Advanced Query Accelerator).
         */
        public var aquaConfigurationStatus: aws.sdk.kotlin.services.redshift.model.AquaConfigurationStatus? = null
        /**
         * The number of days that automated snapshots are retained. If the value is 0, automated snapshots are disabled. Even if automated snapshots are disabled, you can still create manual snapshots when you want with CreateClusterSnapshot.
         *
         * You can't disable automated snapshots for RA3 node types. Set the automated retention period from 1-35 days.
         *
         * Default: The value selected for the cluster from which the snapshot was taken.
         *
         * Constraints: Must be a value from 0 to 35.
         */
        public var automatedSnapshotRetentionPeriod: kotlin.Int? = null
        /**
         * The Amazon EC2 Availability Zone in which to restore the cluster.
         *
         * Default: A random, system-chosen Availability Zone.
         *
         * Example: `us-east-2a`
         */
        public var availabilityZone: kotlin.String? = null
        /**
         * The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster is restored.
         */
        public var availabilityZoneRelocation: kotlin.Boolean? = null
        /**
         * The identifier of the cluster that will be created from restoring the snapshot.
         *
         * Constraints:
         * + Must contain from 1 to 63 alphanumeric characters or hyphens.
         * + Alphabetic characters must be lowercase.
         * + First character must be a letter.
         * + Cannot end with a hyphen or contain two consecutive hyphens.
         * + Must be unique for all clusters within an Amazon Web Services account.
         */
        public var clusterIdentifier: kotlin.String? = null
        /**
         * The name of the parameter group to be associated with this cluster.
         *
         * Default: The default Amazon Redshift cluster parameter group. For information about the default parameter group, go to [Working with Amazon Redshift Parameter Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html).
         *
         * Constraints:
         * + Must be 1 to 255 alphanumeric characters or hyphens.
         * + First character must be a letter.
         * + Cannot end with a hyphen or contain two consecutive hyphens.
         */
        public var clusterParameterGroupName: kotlin.String? = null
        /**
         * A list of security groups to be associated with this cluster.
         *
         * Default: The default cluster security group for Amazon Redshift.
         *
         * Cluster security groups only apply to clusters outside of VPCs.
         */
        public var clusterSecurityGroups: List<String>? = null
        /**
         * The name of the subnet group where you want to cluster restored.
         *
         * A snapshot of cluster in VPC can be restored only in VPC. Therefore, you must provide subnet group name where you want the cluster restored.
         */
        public var clusterSubnetGroupName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for the IAM role that was set as default for the cluster when the cluster was last modified while it was restored from a snapshot.
         */
        public var defaultIamRoleArn: kotlin.String? = null
        /**
         * The Elastic IP (EIP) address for the cluster. Don't specify the Elastic IP address for a publicly accessible cluster with availability zone relocation turned on.
         */
        public var elasticIp: kotlin.String? = null
        /**
         * Enables support for restoring an unencrypted snapshot to a cluster encrypted with Key Management Service (KMS) and a customer managed key.
         */
        public var encrypted: kotlin.Boolean? = null
        /**
         * An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see [Enhanced VPC Routing](https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html) in the Amazon Redshift Cluster Management Guide.
         *
         * If this option is `true`, enhanced VPC routing is enabled.
         *
         * Default: false
         */
        public var enhancedVpcRouting: kotlin.Boolean? = null
        /**
         * Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data encryption keys stored in an HSM.
         */
        public var hsmClientCertificateIdentifier: kotlin.String? = null
        /**
         * Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster can use to retrieve and store keys in an HSM.
         */
        public var hsmConfigurationIdentifier: kotlin.String? = null
        /**
         * A list of Identity and Access Management (IAM) roles that can be used by the cluster to access other Amazon Web Services services. You must supply the IAM roles in their Amazon Resource Name (ARN) format.
         *
         * The maximum number of IAM roles that you can associate is subject to a quota. For more information, go to [Quotas and limits](https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html) in the *Amazon Redshift Cluster Management Guide*.
         */
        public var iamRoles: List<String>? = null
        /**
         * The IP address type for the cluster. Possible values are `ipv4` and `dualstack`.
         */
        public var ipAddressType: kotlin.String? = null
        /**
         * The Key Management Service (KMS) key ID of the encryption key that encrypts data in the cluster restored from a shared snapshot. You can also provide the key ID when you restore from an unencrypted snapshot to an encrypted cluster in the same account. Additionally, you can specify a new KMS key ID when you restore from an encrypted snapshot in the same account in order to change it. In that case, the restored cluster is encrypted with the new KMS key ID.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The name of the maintenance track for the restored cluster. When you take a snapshot, the snapshot inherits the `MaintenanceTrack` value from the cluster. The snapshot might be on a different track than the cluster that was the source for the snapshot. For example, suppose that you take a snapshot of a cluster that is on the current track and then change the cluster to be on the trailing track. In this case, the snapshot and the source cluster are on different tracks.
         */
        public var maintenanceTrackName: kotlin.String? = null
        /**
         * If `true`, Amazon Redshift uses Secrets Manager to manage the restored cluster's admin credentials. If `ManageMasterPassword` is false or not set, Amazon Redshift uses the admin credentials the cluster had at the time the snapshot was taken.
         */
        public var manageMasterPassword: kotlin.Boolean? = null
        /**
         * The default number of days to retain a manual snapshot. If the value is -1, the snapshot is retained indefinitely. This setting doesn't change the retention period of existing snapshots.
         *
         * The value must be either -1 or an integer between 1 and 3,653.
         */
        public var manualSnapshotRetentionPeriod: kotlin.Int? = null
        /**
         * The ID of the Key Management Service (KMS) key used to encrypt and store the cluster's admin credentials secret. You can only use this parameter if `ManageMasterPassword` is true.
         */
        public var masterPasswordSecretKmsKeyId: kotlin.String? = null
        /**
         * If true, the snapshot will be restored to a cluster deployed in two Availability Zones.
         */
        public var multiAz: kotlin.Boolean? = null
        /**
         * The node type that the restored cluster will be provisioned with.
         *
         * If you have a DC instance type, you must restore into that same instance type and size. In other words, you can only restore a dc2.large node type into another dc2 type. For more information about node types, see [ About Clusters and Nodes](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-about-clusters-and-nodes) in the *Amazon Redshift Cluster Management Guide*.
         */
        public var nodeType: kotlin.String? = null
        /**
         * The number of nodes specified when provisioning the restored cluster.
         */
        public var numberOfNodes: kotlin.Int? = null
        /**
         * The Amazon Web Services account used to create or copy the snapshot. Required if you are restoring a snapshot you do not own, optional if you own the snapshot.
         */
        public var ownerAccount: kotlin.String? = null
        /**
         * The port number on which the cluster accepts connections.
         *
         * Default: The same port as the original cluster.
         *
         * Valid values: For clusters with DC2 nodes, must be within the range `1150`-`65535`. For clusters with ra3 nodes, must be within the ranges `5431`-`5455` or `8191`-`8215`.
         */
        public var port: kotlin.Int? = null
        /**
         * The weekly time range (in UTC) during which automated cluster maintenance can occur.
         *
         *  Format: `ddd:hh24:mi-ddd:hh24:mi`
         *
         *  Default: The value selected for the cluster from which the snapshot was taken. For more information about the time blocks for each region, see [Maintenance Windows](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-maintenance-windows) in Amazon Redshift Cluster Management Guide.
         *
         * Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
         *
         * Constraints: Minimum 30-minute window.
         */
        public var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * If `true`, the cluster can be accessed from a public network.
         */
        public var publiclyAccessible: kotlin.Boolean? = null
        /**
         * The identifier of the target reserved node offering.
         */
        public var reservedNodeId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the snapshot associated with the message to restore from a cluster. You must specify this parameter or `snapshotIdentifier`, but not both.
         */
        public var snapshotArn: kotlin.String? = null
        /**
         * The name of the cluster the source snapshot was created from. This parameter is required if your IAM user has a policy containing a snapshot resource element that specifies anything other than * for the cluster name.
         */
        public var snapshotClusterIdentifier: kotlin.String? = null
        /**
         * The name of the snapshot from which to create the new cluster. This parameter isn't case sensitive. You must specify this parameter or `snapshotArn`, but not both.
         *
         * Example: `my-snapshot-id`
         */
        public var snapshotIdentifier: kotlin.String? = null
        /**
         * A unique identifier for the snapshot schedule.
         */
        public var snapshotScheduleIdentifier: kotlin.String? = null
        /**
         * The identifier of the target reserved node offering.
         */
        public var targetReservedNodeOfferingId: kotlin.String? = null
        /**
         * A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.
         *
         * Default: The default VPC security group is associated with the cluster.
         *
         * VPC security groups only apply to clusters in VPCs.
         */
        public var vpcSecurityGroupIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.RestoreFromClusterSnapshotRequest) : this() {
            this.additionalInfo = x.additionalInfo
            this.allowVersionUpgrade = x.allowVersionUpgrade
            this.aquaConfigurationStatus = x.aquaConfigurationStatus
            this.automatedSnapshotRetentionPeriod = x.automatedSnapshotRetentionPeriod
            this.availabilityZone = x.availabilityZone
            this.availabilityZoneRelocation = x.availabilityZoneRelocation
            this.clusterIdentifier = x.clusterIdentifier
            this.clusterParameterGroupName = x.clusterParameterGroupName
            this.clusterSecurityGroups = x.clusterSecurityGroups
            this.clusterSubnetGroupName = x.clusterSubnetGroupName
            this.defaultIamRoleArn = x.defaultIamRoleArn
            this.elasticIp = x.elasticIp
            this.encrypted = x.encrypted
            this.enhancedVpcRouting = x.enhancedVpcRouting
            this.hsmClientCertificateIdentifier = x.hsmClientCertificateIdentifier
            this.hsmConfigurationIdentifier = x.hsmConfigurationIdentifier
            this.iamRoles = x.iamRoles
            this.ipAddressType = x.ipAddressType
            this.kmsKeyId = x.kmsKeyId
            this.maintenanceTrackName = x.maintenanceTrackName
            this.manageMasterPassword = x.manageMasterPassword
            this.manualSnapshotRetentionPeriod = x.manualSnapshotRetentionPeriod
            this.masterPasswordSecretKmsKeyId = x.masterPasswordSecretKmsKeyId
            this.multiAz = x.multiAz
            this.nodeType = x.nodeType
            this.numberOfNodes = x.numberOfNodes
            this.ownerAccount = x.ownerAccount
            this.port = x.port
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.publiclyAccessible = x.publiclyAccessible
            this.reservedNodeId = x.reservedNodeId
            this.snapshotArn = x.snapshotArn
            this.snapshotClusterIdentifier = x.snapshotClusterIdentifier
            this.snapshotIdentifier = x.snapshotIdentifier
            this.snapshotScheduleIdentifier = x.snapshotScheduleIdentifier
            this.targetReservedNodeOfferingId = x.targetReservedNodeOfferingId
            this.vpcSecurityGroupIds = x.vpcSecurityGroupIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.RestoreFromClusterSnapshotRequest = RestoreFromClusterSnapshotRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
