// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a reserved node. You can call the DescribeReservedNodeOfferings API to obtain the available reserved node offerings.
 */
public class ReservedNode private constructor(builder: Builder) {
    /**
     * The currency code for the reserved cluster.
     */
    public val currencyCode: kotlin.String? = builder.currencyCode
    /**
     * The duration of the node reservation in seconds.
     */
    public val duration: kotlin.Int? = builder.duration
    /**
     * The fixed cost Amazon Redshift charges you for this reserved node.
     */
    public val fixedPrice: kotlin.Double? = builder.fixedPrice
    /**
     * The number of reserved compute nodes.
     */
    public val nodeCount: kotlin.Int? = builder.nodeCount
    /**
     * The node type of the reserved node.
     */
    public val nodeType: kotlin.String? = builder.nodeType
    /**
     * The anticipated utilization of the reserved node, as defined in the reserved node offering.
     */
    public val offeringType: kotlin.String? = builder.offeringType
    /**
     * The recurring charges for the reserved node.
     */
    public val recurringCharges: List<RecurringCharge>? = builder.recurringCharges
    /**
     * The unique identifier for the reservation.
     */
    public val reservedNodeId: kotlin.String? = builder.reservedNodeId
    /**
     * The identifier for the reserved node offering.
     */
    public val reservedNodeOfferingId: kotlin.String? = builder.reservedNodeOfferingId
    /**
     *
     */
    public val reservedNodeOfferingType: aws.sdk.kotlin.services.redshift.model.ReservedNodeOfferingType? = builder.reservedNodeOfferingType
    /**
     * The time the reservation started. You purchase a reserved node offering for a duration. This is the start time of that duration.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The state of the reserved compute node.
     *
     * Possible Values:
     * + pending-payment-This reserved node has recently been purchased, and the sale has been approved, but payment has not yet been confirmed.
     * + active-This reserved node is owned by the caller and is available for use.
     * + payment-failed-Payment failed for the purchase attempt.
     * + retired-The reserved node is no longer available.
     * + exchanging-The owner is exchanging the reserved node for another reserved node.
     */
    public val state: kotlin.String? = builder.state
    /**
     * The hourly rate Amazon Redshift charges you for this reserved node.
     */
    public val usagePrice: kotlin.Double? = builder.usagePrice

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.ReservedNode = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReservedNode(")
        append("currencyCode=$currencyCode,")
        append("duration=$duration,")
        append("fixedPrice=$fixedPrice,")
        append("nodeCount=$nodeCount,")
        append("nodeType=$nodeType,")
        append("offeringType=$offeringType,")
        append("recurringCharges=$recurringCharges,")
        append("reservedNodeId=$reservedNodeId,")
        append("reservedNodeOfferingId=$reservedNodeOfferingId,")
        append("reservedNodeOfferingType=$reservedNodeOfferingType,")
        append("startTime=$startTime,")
        append("state=$state,")
        append("usagePrice=$usagePrice")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = currencyCode?.hashCode() ?: 0
        result = 31 * result + (duration ?: 0)
        result = 31 * result + (fixedPrice?.hashCode() ?: 0)
        result = 31 * result + (nodeCount ?: 0)
        result = 31 * result + (nodeType?.hashCode() ?: 0)
        result = 31 * result + (offeringType?.hashCode() ?: 0)
        result = 31 * result + (recurringCharges?.hashCode() ?: 0)
        result = 31 * result + (reservedNodeId?.hashCode() ?: 0)
        result = 31 * result + (reservedNodeOfferingId?.hashCode() ?: 0)
        result = 31 * result + (reservedNodeOfferingType?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (usagePrice?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReservedNode

        if (currencyCode != other.currencyCode) return false
        if (duration != other.duration) return false
        if (!(fixedPrice?.equals(other.fixedPrice) ?: (other.fixedPrice == null))) return false
        if (nodeCount != other.nodeCount) return false
        if (nodeType != other.nodeType) return false
        if (offeringType != other.offeringType) return false
        if (recurringCharges != other.recurringCharges) return false
        if (reservedNodeId != other.reservedNodeId) return false
        if (reservedNodeOfferingId != other.reservedNodeOfferingId) return false
        if (reservedNodeOfferingType != other.reservedNodeOfferingType) return false
        if (startTime != other.startTime) return false
        if (state != other.state) return false
        if (!(usagePrice?.equals(other.usagePrice) ?: (other.usagePrice == null))) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.ReservedNode = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The currency code for the reserved cluster.
         */
        public var currencyCode: kotlin.String? = null
        /**
         * The duration of the node reservation in seconds.
         */
        public var duration: kotlin.Int? = null
        /**
         * The fixed cost Amazon Redshift charges you for this reserved node.
         */
        public var fixedPrice: kotlin.Double? = null
        /**
         * The number of reserved compute nodes.
         */
        public var nodeCount: kotlin.Int? = null
        /**
         * The node type of the reserved node.
         */
        public var nodeType: kotlin.String? = null
        /**
         * The anticipated utilization of the reserved node, as defined in the reserved node offering.
         */
        public var offeringType: kotlin.String? = null
        /**
         * The recurring charges for the reserved node.
         */
        public var recurringCharges: List<RecurringCharge>? = null
        /**
         * The unique identifier for the reservation.
         */
        public var reservedNodeId: kotlin.String? = null
        /**
         * The identifier for the reserved node offering.
         */
        public var reservedNodeOfferingId: kotlin.String? = null
        /**
         *
         */
        public var reservedNodeOfferingType: aws.sdk.kotlin.services.redshift.model.ReservedNodeOfferingType? = null
        /**
         * The time the reservation started. You purchase a reserved node offering for a duration. This is the start time of that duration.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The state of the reserved compute node.
         *
         * Possible Values:
         * + pending-payment-This reserved node has recently been purchased, and the sale has been approved, but payment has not yet been confirmed.
         * + active-This reserved node is owned by the caller and is available for use.
         * + payment-failed-Payment failed for the purchase attempt.
         * + retired-The reserved node is no longer available.
         * + exchanging-The owner is exchanging the reserved node for another reserved node.
         */
        public var state: kotlin.String? = null
        /**
         * The hourly rate Amazon Redshift charges you for this reserved node.
         */
        public var usagePrice: kotlin.Double? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.ReservedNode) : this() {
            this.currencyCode = x.currencyCode
            this.duration = x.duration
            this.fixedPrice = x.fixedPrice
            this.nodeCount = x.nodeCount
            this.nodeType = x.nodeType
            this.offeringType = x.offeringType
            this.recurringCharges = x.recurringCharges
            this.reservedNodeId = x.reservedNodeId
            this.reservedNodeOfferingId = x.reservedNodeOfferingId
            this.reservedNodeOfferingType = x.reservedNodeOfferingType
            this.startTime = x.startTime
            this.state = x.state
            this.usagePrice = x.usagePrice
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.ReservedNode = ReservedNode(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
