// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * An Amazon Redshift Advisor recommended action on the Amazon Redshift cluster.
 */
public class Recommendation private constructor(builder: Builder) {
    /**
     * The unique identifier of the cluster for which the recommendation is returned.
     */
    public val clusterIdentifier: kotlin.String? = builder.clusterIdentifier
    /**
     * The date and time (UTC) that the recommendation was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The description of the recommendation.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A unique identifier of the Advisor recommendation.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The scale of the impact that the Advisor recommendation has to the performance and cost of the cluster.
     */
    public val impactRanking: aws.sdk.kotlin.services.redshift.model.ImpactRankingType? = builder.impactRanking
    /**
     * The Amazon Redshift cluster namespace ARN for which the recommendations is returned.
     */
    public val namespaceArn: kotlin.String? = builder.namespaceArn
    /**
     * The description of what was observed about your cluster.
     */
    public val observation: kotlin.String? = builder.observation
    /**
     * The description of the recommendation.
     */
    public val recommendationText: kotlin.String? = builder.recommendationText
    /**
     * The type of Advisor recommendation.
     */
    public val recommendationType: kotlin.String? = builder.recommendationType
    /**
     * List of Amazon Redshift recommended actions.
     */
    public val recommendedActions: List<RecommendedAction>? = builder.recommendedActions
    /**
     * List of helpful links for more information about the Advisor recommendation.
     */
    public val referenceLinks: List<ReferenceLink>? = builder.referenceLinks
    /**
     * The title of the recommendation.
     */
    public val title: kotlin.String? = builder.title

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.Recommendation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Recommendation(")
        append("clusterIdentifier=$clusterIdentifier,")
        append("createdAt=$createdAt,")
        append("description=$description,")
        append("id=$id,")
        append("impactRanking=$impactRanking,")
        append("namespaceArn=$namespaceArn,")
        append("observation=$observation,")
        append("recommendationText=$recommendationText,")
        append("recommendationType=$recommendationType,")
        append("recommendedActions=$recommendedActions,")
        append("referenceLinks=$referenceLinks,")
        append("title=$title")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterIdentifier?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (impactRanking?.hashCode() ?: 0)
        result = 31 * result + (namespaceArn?.hashCode() ?: 0)
        result = 31 * result + (observation?.hashCode() ?: 0)
        result = 31 * result + (recommendationText?.hashCode() ?: 0)
        result = 31 * result + (recommendationType?.hashCode() ?: 0)
        result = 31 * result + (recommendedActions?.hashCode() ?: 0)
        result = 31 * result + (referenceLinks?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Recommendation

        if (clusterIdentifier != other.clusterIdentifier) return false
        if (createdAt != other.createdAt) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (impactRanking != other.impactRanking) return false
        if (namespaceArn != other.namespaceArn) return false
        if (observation != other.observation) return false
        if (recommendationText != other.recommendationText) return false
        if (recommendationType != other.recommendationType) return false
        if (recommendedActions != other.recommendedActions) return false
        if (referenceLinks != other.referenceLinks) return false
        if (title != other.title) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.Recommendation = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The unique identifier of the cluster for which the recommendation is returned.
         */
        public var clusterIdentifier: kotlin.String? = null
        /**
         * The date and time (UTC) that the recommendation was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the recommendation.
         */
        public var description: kotlin.String? = null
        /**
         * A unique identifier of the Advisor recommendation.
         */
        public var id: kotlin.String? = null
        /**
         * The scale of the impact that the Advisor recommendation has to the performance and cost of the cluster.
         */
        public var impactRanking: aws.sdk.kotlin.services.redshift.model.ImpactRankingType? = null
        /**
         * The Amazon Redshift cluster namespace ARN for which the recommendations is returned.
         */
        public var namespaceArn: kotlin.String? = null
        /**
         * The description of what was observed about your cluster.
         */
        public var observation: kotlin.String? = null
        /**
         * The description of the recommendation.
         */
        public var recommendationText: kotlin.String? = null
        /**
         * The type of Advisor recommendation.
         */
        public var recommendationType: kotlin.String? = null
        /**
         * List of Amazon Redshift recommended actions.
         */
        public var recommendedActions: List<RecommendedAction>? = null
        /**
         * List of helpful links for more information about the Advisor recommendation.
         */
        public var referenceLinks: List<ReferenceLink>? = null
        /**
         * The title of the recommendation.
         */
        public var title: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.Recommendation) : this() {
            this.clusterIdentifier = x.clusterIdentifier
            this.createdAt = x.createdAt
            this.description = x.description
            this.id = x.id
            this.impactRanking = x.impactRanking
            this.namespaceArn = x.namespaceArn
            this.observation = x.observation
            this.recommendationText = x.recommendationText
            this.recommendationType = x.recommendationType
            this.recommendedActions = x.recommendedActions
            this.referenceLinks = x.referenceLinks
            this.title = x.title
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.Recommendation = Recommendation(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
