// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListRecommendationsRequest private constructor(builder: Builder) {
    /**
     * The unique identifier of the Amazon Redshift cluster for which the list of Advisor recommendations is returned. If the neither the cluster identifier and the cluster namespace ARN parameters are specified, then recommendations for all clusters in the account are returned.
     */
    public val clusterIdentifier: kotlin.String? = builder.clusterIdentifier
    /**
     * A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the Marker parameter and retrying the command. If the Marker field is empty, all response records have been retrieved for the request.
     */
    public val marker: kotlin.String? = builder.marker
    /**
     * The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified MaxRecords value, a value is returned in a marker field of the response. You can retrieve the next set of records by retrying the command with the returned marker value.
     */
    public val maxRecords: kotlin.Int? = builder.maxRecords
    /**
     * The Amazon Redshift cluster namespace Amazon Resource Name (ARN) for which the list of Advisor recommendations is returned. If the neither the cluster identifier and the cluster namespace ARN parameters are specified, then recommendations for all clusters in the account are returned.
     */
    public val namespaceArn: kotlin.String? = builder.namespaceArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.ListRecommendationsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListRecommendationsRequest(")
        append("clusterIdentifier=$clusterIdentifier,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords,")
        append("namespaceArn=$namespaceArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterIdentifier?.hashCode() ?: 0
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        result = 31 * result + (namespaceArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListRecommendationsRequest

        if (clusterIdentifier != other.clusterIdentifier) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false
        if (namespaceArn != other.namespaceArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.ListRecommendationsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The unique identifier of the Amazon Redshift cluster for which the list of Advisor recommendations is returned. If the neither the cluster identifier and the cluster namespace ARN parameters are specified, then recommendations for all clusters in the account are returned.
         */
        public var clusterIdentifier: kotlin.String? = null
        /**
         * A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the Marker parameter and retrying the command. If the Marker field is empty, all response records have been retrieved for the request.
         */
        public var marker: kotlin.String? = null
        /**
         * The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified MaxRecords value, a value is returned in a marker field of the response. You can retrieve the next set of records by retrying the command with the returned marker value.
         */
        public var maxRecords: kotlin.Int? = null
        /**
         * The Amazon Redshift cluster namespace Amazon Resource Name (ARN) for which the list of Advisor recommendations is returned. If the neither the cluster identifier and the cluster namespace ARN parameters are specified, then recommendations for all clusters in the account are returned.
         */
        public var namespaceArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.ListRecommendationsRequest) : this() {
            this.clusterIdentifier = x.clusterIdentifier
            this.marker = x.marker
            this.maxRecords = x.maxRecords
            this.namespaceArn = x.namespaceArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.ListRecommendationsRequest = ListRecommendationsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
