// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The request parameters to get cluster credentials.
 */
public class GetClusterCredentialsRequest private constructor(builder: Builder) {
    /**
     * Create a database user with the name specified for the user named in `DbUser` if one does not exist.
     */
    public val autoCreate: kotlin.Boolean? = builder.autoCreate
    /**
     * The unique identifier of the cluster that contains the database for which you are requesting credentials. This parameter is case sensitive.
     */
    public val clusterIdentifier: kotlin.String? = builder.clusterIdentifier
    /**
     * The custom domain name for the cluster credentials.
     */
    public val customDomainName: kotlin.String? = builder.customDomainName
    /**
     * A list of the names of existing database groups that the user named in `DbUser` will join for the current session, in addition to any group memberships for an existing user. If not specified, a new user is added only to PUBLIC.
     *
     * Database group name constraints
     * + Must be 1 to 64 alphanumeric characters or hyphens
     * + Must contain only lowercase letters, numbers, underscore, plus sign, period (dot), at symbol (@), or hyphen.
     * + First character must be a letter.
     * + Must not contain a colon ( : ) or slash ( / ).
     * + Cannot be a reserved word. A list of reserved words can be found in [Reserved Words](http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html) in the Amazon Redshift Database Developer Guide.
     */
    public val dbGroups: List<String>? = builder.dbGroups
    /**
     * The name of a database that `DbUser` is authorized to log on to. If `DbName` is not specified, `DbUser` can log on to any existing database.
     *
     * Constraints:
     * + Must be 1 to 64 alphanumeric characters or hyphens
     * + Must contain uppercase or lowercase letters, numbers, underscore, plus sign, period (dot), at symbol (@), or hyphen.
     * + First character must be a letter.
     * + Must not contain a colon ( : ) or slash ( / ).
     * + Cannot be a reserved word. A list of reserved words can be found in [Reserved Words](http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html) in the Amazon Redshift Database Developer Guide.
     */
    public val dbName: kotlin.String? = builder.dbName
    /**
     * The name of a database user. If a user name matching `DbUser` exists in the database, the temporary user credentials have the same permissions as the existing user. If `DbUser` doesn't exist in the database and `Autocreate` is `True`, a new user is created using the value for `DbUser` with PUBLIC permissions. If a database user matching the value for `DbUser` doesn't exist and `Autocreate` is `False`, then the command succeeds but the connection attempt will fail because the user doesn't exist in the database.
     *
     * For more information, see [CREATE USER](https://docs.aws.amazon.com/redshift/latest/dg/r_CREATE_USER.html) in the Amazon Redshift Database Developer Guide.
     *
     * Constraints:
     * + Must be 1 to 64 alphanumeric characters or hyphens. The user name can't be `PUBLIC`.
     * + Must contain uppercase or lowercase letters, numbers, underscore, plus sign, period (dot), at symbol (@), or hyphen.
     * + First character must be a letter.
     * + Must not contain a colon ( : ) or slash ( / ).
     * + Cannot be a reserved word. A list of reserved words can be found in [Reserved Words](http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html) in the Amazon Redshift Database Developer Guide.
     */
    public val dbUser: kotlin.String? = builder.dbUser
    /**
     * The number of seconds until the returned temporary password expires.
     *
     * Constraint: minimum 900, maximum 3600.
     *
     * Default: 900
     */
    public val durationSeconds: kotlin.Int? = builder.durationSeconds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.GetClusterCredentialsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetClusterCredentialsRequest(")
        append("autoCreate=$autoCreate,")
        append("clusterIdentifier=$clusterIdentifier,")
        append("customDomainName=$customDomainName,")
        append("dbGroups=$dbGroups,")
        append("dbName=$dbName,")
        append("dbUser=$dbUser,")
        append("durationSeconds=$durationSeconds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoCreate?.hashCode() ?: 0
        result = 31 * result + (clusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (customDomainName?.hashCode() ?: 0)
        result = 31 * result + (dbGroups?.hashCode() ?: 0)
        result = 31 * result + (dbName?.hashCode() ?: 0)
        result = 31 * result + (dbUser?.hashCode() ?: 0)
        result = 31 * result + (durationSeconds ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetClusterCredentialsRequest

        if (autoCreate != other.autoCreate) return false
        if (clusterIdentifier != other.clusterIdentifier) return false
        if (customDomainName != other.customDomainName) return false
        if (dbGroups != other.dbGroups) return false
        if (dbName != other.dbName) return false
        if (dbUser != other.dbUser) return false
        if (durationSeconds != other.durationSeconds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.GetClusterCredentialsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Create a database user with the name specified for the user named in `DbUser` if one does not exist.
         */
        public var autoCreate: kotlin.Boolean? = null
        /**
         * The unique identifier of the cluster that contains the database for which you are requesting credentials. This parameter is case sensitive.
         */
        public var clusterIdentifier: kotlin.String? = null
        /**
         * The custom domain name for the cluster credentials.
         */
        public var customDomainName: kotlin.String? = null
        /**
         * A list of the names of existing database groups that the user named in `DbUser` will join for the current session, in addition to any group memberships for an existing user. If not specified, a new user is added only to PUBLIC.
         *
         * Database group name constraints
         * + Must be 1 to 64 alphanumeric characters or hyphens
         * + Must contain only lowercase letters, numbers, underscore, plus sign, period (dot), at symbol (@), or hyphen.
         * + First character must be a letter.
         * + Must not contain a colon ( : ) or slash ( / ).
         * + Cannot be a reserved word. A list of reserved words can be found in [Reserved Words](http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html) in the Amazon Redshift Database Developer Guide.
         */
        public var dbGroups: List<String>? = null
        /**
         * The name of a database that `DbUser` is authorized to log on to. If `DbName` is not specified, `DbUser` can log on to any existing database.
         *
         * Constraints:
         * + Must be 1 to 64 alphanumeric characters or hyphens
         * + Must contain uppercase or lowercase letters, numbers, underscore, plus sign, period (dot), at symbol (@), or hyphen.
         * + First character must be a letter.
         * + Must not contain a colon ( : ) or slash ( / ).
         * + Cannot be a reserved word. A list of reserved words can be found in [Reserved Words](http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html) in the Amazon Redshift Database Developer Guide.
         */
        public var dbName: kotlin.String? = null
        /**
         * The name of a database user. If a user name matching `DbUser` exists in the database, the temporary user credentials have the same permissions as the existing user. If `DbUser` doesn't exist in the database and `Autocreate` is `True`, a new user is created using the value for `DbUser` with PUBLIC permissions. If a database user matching the value for `DbUser` doesn't exist and `Autocreate` is `False`, then the command succeeds but the connection attempt will fail because the user doesn't exist in the database.
         *
         * For more information, see [CREATE USER](https://docs.aws.amazon.com/redshift/latest/dg/r_CREATE_USER.html) in the Amazon Redshift Database Developer Guide.
         *
         * Constraints:
         * + Must be 1 to 64 alphanumeric characters or hyphens. The user name can't be `PUBLIC`.
         * + Must contain uppercase or lowercase letters, numbers, underscore, plus sign, period (dot), at symbol (@), or hyphen.
         * + First character must be a letter.
         * + Must not contain a colon ( : ) or slash ( / ).
         * + Cannot be a reserved word. A list of reserved words can be found in [Reserved Words](http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html) in the Amazon Redshift Database Developer Guide.
         */
        public var dbUser: kotlin.String? = null
        /**
         * The number of seconds until the returned temporary password expires.
         *
         * Constraint: minimum 900, maximum 3600.
         *
         * Default: 900
         */
        public var durationSeconds: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.GetClusterCredentialsRequest) : this() {
            this.autoCreate = x.autoCreate
            this.clusterIdentifier = x.clusterIdentifier
            this.customDomainName = x.customDomainName
            this.dbGroups = x.dbGroups
            this.dbName = x.dbName
            this.dbUser = x.dbUser
            this.durationSeconds = x.durationSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.GetClusterCredentialsRequest = GetClusterCredentialsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
