// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 *
 */
public class DescribeClusterSnapshotsRequest private constructor(builder: Builder) {
    /**
     * A value that indicates whether to return snapshots only for an existing cluster. You can perform table-level restore only by using a snapshot of an existing cluster, that is, a cluster that has not been deleted. Values for this parameter work as follows:
     * + If `ClusterExists` is set to `true`, `ClusterIdentifier` is required.
     * + If `ClusterExists` is set to `false` and `ClusterIdentifier` isn't specified, all snapshots associated with deleted clusters (orphaned snapshots) are returned.
     * + If `ClusterExists` is set to `false` and `ClusterIdentifier` is specified for a deleted cluster, snapshots associated with that cluster are returned.
     * + If `ClusterExists` is set to `false` and `ClusterIdentifier` is specified for an existing cluster, no snapshots are returned.
     */
    public val clusterExists: kotlin.Boolean? = builder.clusterExists
    /**
     * The identifier of the cluster which generated the requested snapshots.
     */
    public val clusterIdentifier: kotlin.String? = builder.clusterIdentifier
    /**
     * A time value that requests only snapshots created at or before the specified time. The time value is specified in ISO 8601 format. For more information about ISO 8601, go to the [ISO8601 Wikipedia page.](http://en.wikipedia.org/wiki/ISO_8601)
     *
     * Example: `2012-07-16T18:00:00Z`
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * An optional parameter that specifies the starting point to return a set of response records. When the results of a DescribeClusterSnapshots request exceed the value specified in `MaxRecords`, Amazon Web Services returns a value in the `Marker` field of the response. You can retrieve the next set of response records by providing the returned marker value in the `Marker` parameter and retrying the request.
     */
    public val marker: kotlin.String? = builder.marker
    /**
     * The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified `MaxRecords` value, a value is returned in a `marker` field of the response. You can retrieve the next set of records by retrying the command with the returned marker value.
     *
     * Default: `100`
     *
     * Constraints: minimum 20, maximum 100.
     */
    public val maxRecords: kotlin.Int? = builder.maxRecords
    /**
     * The Amazon Web Services account used to create or copy the snapshot. Use this field to filter the results to snapshots owned by a particular account. To describe snapshots you own, either specify your Amazon Web Services account, or do not specify the parameter.
     */
    public val ownerAccount: kotlin.String? = builder.ownerAccount
    /**
     * The Amazon Resource Name (ARN) of the snapshot associated with the message to describe cluster snapshots.
     */
    public val snapshotArn: kotlin.String? = builder.snapshotArn
    /**
     * The snapshot identifier of the snapshot about which to return information.
     */
    public val snapshotIdentifier: kotlin.String? = builder.snapshotIdentifier
    /**
     * The type of snapshots for which you are requesting information. By default, snapshots of all types are returned.
     *
     * Valid Values: `automated` | `manual`
     */
    public val snapshotType: kotlin.String? = builder.snapshotType
    /**
     *
     */
    public val sortingEntities: List<SnapshotSortingEntity>? = builder.sortingEntities
    /**
     * A value that requests only snapshots created at or after the specified time. The time value is specified in ISO 8601 format. For more information about ISO 8601, go to the [ISO8601 Wikipedia page.](http://en.wikipedia.org/wiki/ISO_8601)
     *
     * Example: `2012-07-16T18:00:00Z`
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * A tag key or keys for which you want to return all matching cluster snapshots that are associated with the specified key or keys. For example, suppose that you have snapshots that are tagged with keys called `owner` and `environment`. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the snapshots that have either or both of these tag keys associated with them.
     */
    public val tagKeys: List<String>? = builder.tagKeys
    /**
     * A tag value or values for which you want to return all matching cluster snapshots that are associated with the specified tag value or values. For example, suppose that you have snapshots that are tagged with values called `admin` and `test`. If you specify both of these tag values in the request, Amazon Redshift returns a response with the snapshots that have either or both of these tag values associated with them.
     */
    public val tagValues: List<String>? = builder.tagValues

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.DescribeClusterSnapshotsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeClusterSnapshotsRequest(")
        append("clusterExists=$clusterExists,")
        append("clusterIdentifier=$clusterIdentifier,")
        append("endTime=$endTime,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords,")
        append("ownerAccount=$ownerAccount,")
        append("snapshotArn=$snapshotArn,")
        append("snapshotIdentifier=$snapshotIdentifier,")
        append("snapshotType=$snapshotType,")
        append("sortingEntities=$sortingEntities,")
        append("startTime=$startTime,")
        append("tagKeys=$tagKeys,")
        append("tagValues=$tagValues")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterExists?.hashCode() ?: 0
        result = 31 * result + (clusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        result = 31 * result + (ownerAccount?.hashCode() ?: 0)
        result = 31 * result + (snapshotArn?.hashCode() ?: 0)
        result = 31 * result + (snapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (snapshotType?.hashCode() ?: 0)
        result = 31 * result + (sortingEntities?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (tagKeys?.hashCode() ?: 0)
        result = 31 * result + (tagValues?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeClusterSnapshotsRequest

        if (clusterExists != other.clusterExists) return false
        if (clusterIdentifier != other.clusterIdentifier) return false
        if (endTime != other.endTime) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false
        if (ownerAccount != other.ownerAccount) return false
        if (snapshotArn != other.snapshotArn) return false
        if (snapshotIdentifier != other.snapshotIdentifier) return false
        if (snapshotType != other.snapshotType) return false
        if (sortingEntities != other.sortingEntities) return false
        if (startTime != other.startTime) return false
        if (tagKeys != other.tagKeys) return false
        if (tagValues != other.tagValues) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.DescribeClusterSnapshotsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A value that indicates whether to return snapshots only for an existing cluster. You can perform table-level restore only by using a snapshot of an existing cluster, that is, a cluster that has not been deleted. Values for this parameter work as follows:
         * + If `ClusterExists` is set to `true`, `ClusterIdentifier` is required.
         * + If `ClusterExists` is set to `false` and `ClusterIdentifier` isn't specified, all snapshots associated with deleted clusters (orphaned snapshots) are returned.
         * + If `ClusterExists` is set to `false` and `ClusterIdentifier` is specified for a deleted cluster, snapshots associated with that cluster are returned.
         * + If `ClusterExists` is set to `false` and `ClusterIdentifier` is specified for an existing cluster, no snapshots are returned.
         */
        public var clusterExists: kotlin.Boolean? = null
        /**
         * The identifier of the cluster which generated the requested snapshots.
         */
        public var clusterIdentifier: kotlin.String? = null
        /**
         * A time value that requests only snapshots created at or before the specified time. The time value is specified in ISO 8601 format. For more information about ISO 8601, go to the [ISO8601 Wikipedia page.](http://en.wikipedia.org/wiki/ISO_8601)
         *
         * Example: `2012-07-16T18:00:00Z`
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An optional parameter that specifies the starting point to return a set of response records. When the results of a DescribeClusterSnapshots request exceed the value specified in `MaxRecords`, Amazon Web Services returns a value in the `Marker` field of the response. You can retrieve the next set of response records by providing the returned marker value in the `Marker` parameter and retrying the request.
         */
        public var marker: kotlin.String? = null
        /**
         * The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified `MaxRecords` value, a value is returned in a `marker` field of the response. You can retrieve the next set of records by retrying the command with the returned marker value.
         *
         * Default: `100`
         *
         * Constraints: minimum 20, maximum 100.
         */
        public var maxRecords: kotlin.Int? = null
        /**
         * The Amazon Web Services account used to create or copy the snapshot. Use this field to filter the results to snapshots owned by a particular account. To describe snapshots you own, either specify your Amazon Web Services account, or do not specify the parameter.
         */
        public var ownerAccount: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the snapshot associated with the message to describe cluster snapshots.
         */
        public var snapshotArn: kotlin.String? = null
        /**
         * The snapshot identifier of the snapshot about which to return information.
         */
        public var snapshotIdentifier: kotlin.String? = null
        /**
         * The type of snapshots for which you are requesting information. By default, snapshots of all types are returned.
         *
         * Valid Values: `automated` | `manual`
         */
        public var snapshotType: kotlin.String? = null
        /**
         *
         */
        public var sortingEntities: List<SnapshotSortingEntity>? = null
        /**
         * A value that requests only snapshots created at or after the specified time. The time value is specified in ISO 8601 format. For more information about ISO 8601, go to the [ISO8601 Wikipedia page.](http://en.wikipedia.org/wiki/ISO_8601)
         *
         * Example: `2012-07-16T18:00:00Z`
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A tag key or keys for which you want to return all matching cluster snapshots that are associated with the specified key or keys. For example, suppose that you have snapshots that are tagged with keys called `owner` and `environment`. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the snapshots that have either or both of these tag keys associated with them.
         */
        public var tagKeys: List<String>? = null
        /**
         * A tag value or values for which you want to return all matching cluster snapshots that are associated with the specified tag value or values. For example, suppose that you have snapshots that are tagged with values called `admin` and `test`. If you specify both of these tag values in the request, Amazon Redshift returns a response with the snapshots that have either or both of these tag values associated with them.
         */
        public var tagValues: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.DescribeClusterSnapshotsRequest) : this() {
            this.clusterExists = x.clusterExists
            this.clusterIdentifier = x.clusterIdentifier
            this.endTime = x.endTime
            this.marker = x.marker
            this.maxRecords = x.maxRecords
            this.ownerAccount = x.ownerAccount
            this.snapshotArn = x.snapshotArn
            this.snapshotIdentifier = x.snapshotIdentifier
            this.snapshotType = x.snapshotType
            this.sortingEntities = x.sortingEntities
            this.startTime = x.startTime
            this.tagKeys = x.tagKeys
            this.tagValues = x.tagValues
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.DescribeClusterSnapshotsRequest = DescribeClusterSnapshotsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
