// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 *
 */
public class DeleteClusterRequest private constructor(builder: Builder) {
    /**
     * The identifier of the cluster to be deleted.
     *
     * Constraints:
     * + Must contain lowercase characters.
     * + Must contain from 1 to 63 alphanumeric characters or hyphens.
     * + First character must be a letter.
     * + Cannot end with a hyphen or contain two consecutive hyphens.
     */
    public val clusterIdentifier: kotlin.String? = builder.clusterIdentifier
    /**
     * The identifier of the final snapshot that is to be created immediately before deleting the cluster. If this parameter is provided, *SkipFinalClusterSnapshot* must be `false`.
     *
     * Constraints:
     * + Must be 1 to 255 alphanumeric characters.
     * + First character must be a letter.
     * + Cannot end with a hyphen or contain two consecutive hyphens.
     */
    public val finalClusterSnapshotIdentifier: kotlin.String? = builder.finalClusterSnapshotIdentifier
    /**
     * The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is retained indefinitely.
     *
     * The value must be either -1 or an integer between 1 and 3,653.
     *
     * The default value is -1.
     */
    public val finalClusterSnapshotRetentionPeriod: kotlin.Int? = builder.finalClusterSnapshotRetentionPeriod
    /**
     * Determines whether a final snapshot of the cluster is created before Amazon Redshift deletes the cluster. If `true`, a final cluster snapshot is not created. If `false`, a final cluster snapshot is created before the cluster is deleted.
     *
     * The *FinalClusterSnapshotIdentifier* parameter must be specified if *SkipFinalClusterSnapshot* is `false`.
     *
     * Default: `false`
     */
    public val skipFinalClusterSnapshot: kotlin.Boolean? = builder.skipFinalClusterSnapshot

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.DeleteClusterRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteClusterRequest(")
        append("clusterIdentifier=$clusterIdentifier,")
        append("finalClusterSnapshotIdentifier=$finalClusterSnapshotIdentifier,")
        append("finalClusterSnapshotRetentionPeriod=$finalClusterSnapshotRetentionPeriod,")
        append("skipFinalClusterSnapshot=$skipFinalClusterSnapshot")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterIdentifier?.hashCode() ?: 0
        result = 31 * result + (finalClusterSnapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (finalClusterSnapshotRetentionPeriod ?: 0)
        result = 31 * result + (skipFinalClusterSnapshot?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeleteClusterRequest

        if (clusterIdentifier != other.clusterIdentifier) return false
        if (finalClusterSnapshotIdentifier != other.finalClusterSnapshotIdentifier) return false
        if (finalClusterSnapshotRetentionPeriod != other.finalClusterSnapshotRetentionPeriod) return false
        if (skipFinalClusterSnapshot != other.skipFinalClusterSnapshot) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.DeleteClusterRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier of the cluster to be deleted.
         *
         * Constraints:
         * + Must contain lowercase characters.
         * + Must contain from 1 to 63 alphanumeric characters or hyphens.
         * + First character must be a letter.
         * + Cannot end with a hyphen or contain two consecutive hyphens.
         */
        public var clusterIdentifier: kotlin.String? = null
        /**
         * The identifier of the final snapshot that is to be created immediately before deleting the cluster. If this parameter is provided, *SkipFinalClusterSnapshot* must be `false`.
         *
         * Constraints:
         * + Must be 1 to 255 alphanumeric characters.
         * + First character must be a letter.
         * + Cannot end with a hyphen or contain two consecutive hyphens.
         */
        public var finalClusterSnapshotIdentifier: kotlin.String? = null
        /**
         * The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is retained indefinitely.
         *
         * The value must be either -1 or an integer between 1 and 3,653.
         *
         * The default value is -1.
         */
        public var finalClusterSnapshotRetentionPeriod: kotlin.Int? = null
        /**
         * Determines whether a final snapshot of the cluster is created before Amazon Redshift deletes the cluster. If `true`, a final cluster snapshot is not created. If `false`, a final cluster snapshot is created before the cluster is deleted.
         *
         * The *FinalClusterSnapshotIdentifier* parameter must be specified if *SkipFinalClusterSnapshot* is `false`.
         *
         * Default: `false`
         */
        public var skipFinalClusterSnapshot: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.DeleteClusterRequest) : this() {
            this.clusterIdentifier = x.clusterIdentifier
            this.finalClusterSnapshotIdentifier = x.finalClusterSnapshotIdentifier
            this.finalClusterSnapshotRetentionPeriod = x.finalClusterSnapshotRetentionPeriod
            this.skipFinalClusterSnapshot = x.skipFinalClusterSnapshot
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.DeleteClusterRequest = DeleteClusterRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
