// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The association of a datashare from a producer account with a data consumer.
 */
public class DataShareAssociation private constructor(builder: Builder) {
    /**
     * Specifies whether write operations were allowed during data share association.
     */
    public val consumerAcceptedWrites: kotlin.Boolean? = builder.consumerAcceptedWrites
    /**
     * The name of the consumer accounts that have an association with a producer datashare.
     */
    public val consumerIdentifier: kotlin.String? = builder.consumerIdentifier
    /**
     * The Amazon Web Services Region of the consumer accounts that have an association with a producer datashare.
     */
    public val consumerRegion: kotlin.String? = builder.consumerRegion
    /**
     * The creation date of the datashare that is associated.
     */
    public val createdDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createdDate
    /**
     * Specifies whether write operations were allowed during data share authorization.
     */
    public val producerAllowedWrites: kotlin.Boolean? = builder.producerAllowedWrites
    /**
     * The status of the datashare that is associated.
     */
    public val status: aws.sdk.kotlin.services.redshift.model.DataShareStatus? = builder.status
    /**
     * The status change data of the datashare that is associated.
     */
    public val statusChangeDate: aws.smithy.kotlin.runtime.time.Instant? = builder.statusChangeDate

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.DataShareAssociation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DataShareAssociation(")
        append("consumerAcceptedWrites=$consumerAcceptedWrites,")
        append("consumerIdentifier=$consumerIdentifier,")
        append("consumerRegion=$consumerRegion,")
        append("createdDate=$createdDate,")
        append("producerAllowedWrites=$producerAllowedWrites,")
        append("status=$status,")
        append("statusChangeDate=$statusChangeDate")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = consumerAcceptedWrites?.hashCode() ?: 0
        result = 31 * result + (consumerIdentifier?.hashCode() ?: 0)
        result = 31 * result + (consumerRegion?.hashCode() ?: 0)
        result = 31 * result + (createdDate?.hashCode() ?: 0)
        result = 31 * result + (producerAllowedWrites?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusChangeDate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DataShareAssociation

        if (consumerAcceptedWrites != other.consumerAcceptedWrites) return false
        if (consumerIdentifier != other.consumerIdentifier) return false
        if (consumerRegion != other.consumerRegion) return false
        if (createdDate != other.createdDate) return false
        if (producerAllowedWrites != other.producerAllowedWrites) return false
        if (status != other.status) return false
        if (statusChangeDate != other.statusChangeDate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.DataShareAssociation = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies whether write operations were allowed during data share association.
         */
        public var consumerAcceptedWrites: kotlin.Boolean? = null
        /**
         * The name of the consumer accounts that have an association with a producer datashare.
         */
        public var consumerIdentifier: kotlin.String? = null
        /**
         * The Amazon Web Services Region of the consumer accounts that have an association with a producer datashare.
         */
        public var consumerRegion: kotlin.String? = null
        /**
         * The creation date of the datashare that is associated.
         */
        public var createdDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies whether write operations were allowed during data share authorization.
         */
        public var producerAllowedWrites: kotlin.Boolean? = null
        /**
         * The status of the datashare that is associated.
         */
        public var status: aws.sdk.kotlin.services.redshift.model.DataShareStatus? = null
        /**
         * The status change data of the datashare that is associated.
         */
        public var statusChangeDate: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.DataShareAssociation) : this() {
            this.consumerAcceptedWrites = x.consumerAcceptedWrites
            this.consumerIdentifier = x.consumerIdentifier
            this.consumerRegion = x.consumerRegion
            this.createdDate = x.createdDate
            this.producerAllowedWrites = x.producerAllowedWrites
            this.status = x.status
            this.statusChangeDate = x.statusChangeDate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.DataShareAssociation = DataShareAssociation(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
