// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a snapshot schedule. You can set a regular interval for creating snapshots of a cluster. You can also schedule snapshots for specific dates.
 */
public class CreateSnapshotScheduleResponse private constructor(builder: Builder) {
    /**
     * The number of clusters associated with the schedule.
     */
    public val associatedClusterCount: kotlin.Int? = builder.associatedClusterCount
    /**
     * A list of clusters associated with the schedule. A maximum of 100 clusters is returned.
     */
    public val associatedClusters: List<ClusterAssociatedToSchedule>? = builder.associatedClusters
    /**
     *
     */
    public val nextInvocations: List<Instant>? = builder.nextInvocations
    /**
     * A list of ScheduleDefinitions.
     */
    public val scheduleDefinitions: List<String>? = builder.scheduleDefinitions
    /**
     * The description of the schedule.
     */
    public val scheduleDescription: kotlin.String? = builder.scheduleDescription
    /**
     * A unique identifier for the schedule.
     */
    public val scheduleIdentifier: kotlin.String? = builder.scheduleIdentifier
    /**
     * An optional set of tags describing the schedule.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.CreateSnapshotScheduleResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateSnapshotScheduleResponse(")
        append("associatedClusterCount=$associatedClusterCount,")
        append("associatedClusters=$associatedClusters,")
        append("nextInvocations=$nextInvocations,")
        append("scheduleDefinitions=$scheduleDefinitions,")
        append("scheduleDescription=$scheduleDescription,")
        append("scheduleIdentifier=$scheduleIdentifier,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = associatedClusterCount ?: 0
        result = 31 * result + (associatedClusters?.hashCode() ?: 0)
        result = 31 * result + (nextInvocations?.hashCode() ?: 0)
        result = 31 * result + (scheduleDefinitions?.hashCode() ?: 0)
        result = 31 * result + (scheduleDescription?.hashCode() ?: 0)
        result = 31 * result + (scheduleIdentifier?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateSnapshotScheduleResponse

        if (associatedClusterCount != other.associatedClusterCount) return false
        if (associatedClusters != other.associatedClusters) return false
        if (nextInvocations != other.nextInvocations) return false
        if (scheduleDefinitions != other.scheduleDefinitions) return false
        if (scheduleDescription != other.scheduleDescription) return false
        if (scheduleIdentifier != other.scheduleIdentifier) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.CreateSnapshotScheduleResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The number of clusters associated with the schedule.
         */
        public var associatedClusterCount: kotlin.Int? = null
        /**
         * A list of clusters associated with the schedule. A maximum of 100 clusters is returned.
         */
        public var associatedClusters: List<ClusterAssociatedToSchedule>? = null
        /**
         *
         */
        public var nextInvocations: List<Instant>? = null
        /**
         * A list of ScheduleDefinitions.
         */
        public var scheduleDefinitions: List<String>? = null
        /**
         * The description of the schedule.
         */
        public var scheduleDescription: kotlin.String? = null
        /**
         * A unique identifier for the schedule.
         */
        public var scheduleIdentifier: kotlin.String? = null
        /**
         * An optional set of tags describing the schedule.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.CreateSnapshotScheduleResponse) : this() {
            this.associatedClusterCount = x.associatedClusterCount
            this.associatedClusters = x.associatedClusters
            this.nextInvocations = x.nextInvocations
            this.scheduleDefinitions = x.scheduleDefinitions
            this.scheduleDescription = x.scheduleDescription
            this.scheduleIdentifier = x.scheduleIdentifier
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.CreateSnapshotScheduleResponse = CreateSnapshotScheduleResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
