// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Returns the destination region and retention period that are configured for cross-region snapshot copy.
 */
public class ClusterSnapshotCopyStatus private constructor(builder: Builder) {
    /**
     * The destination region that snapshots are automatically copied to when cross-region snapshot copy is enabled.
     */
    public val destinationRegion: kotlin.String? = builder.destinationRegion
    /**
     * The number of days that automated snapshots are retained in the destination region after they are copied from a source region. If the value is -1, the manual snapshot is retained indefinitely.
     *
     * The value must be either -1 or an integer between 1 and 3,653.
     */
    public val manualSnapshotRetentionPeriod: kotlin.Int? = builder.manualSnapshotRetentionPeriod
    /**
     * The number of days that automated snapshots are retained in the destination region after they are copied from a source region.
     */
    public val retentionPeriod: kotlin.Long? = builder.retentionPeriod
    /**
     * The name of the snapshot copy grant.
     */
    public val snapshotCopyGrantName: kotlin.String? = builder.snapshotCopyGrantName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.ClusterSnapshotCopyStatus = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ClusterSnapshotCopyStatus(")
        append("destinationRegion=$destinationRegion,")
        append("manualSnapshotRetentionPeriod=$manualSnapshotRetentionPeriod,")
        append("retentionPeriod=$retentionPeriod,")
        append("snapshotCopyGrantName=$snapshotCopyGrantName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = destinationRegion?.hashCode() ?: 0
        result = 31 * result + (manualSnapshotRetentionPeriod ?: 0)
        result = 31 * result + (retentionPeriod?.hashCode() ?: 0)
        result = 31 * result + (snapshotCopyGrantName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ClusterSnapshotCopyStatus

        if (destinationRegion != other.destinationRegion) return false
        if (manualSnapshotRetentionPeriod != other.manualSnapshotRetentionPeriod) return false
        if (retentionPeriod != other.retentionPeriod) return false
        if (snapshotCopyGrantName != other.snapshotCopyGrantName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.ClusterSnapshotCopyStatus = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The destination region that snapshots are automatically copied to when cross-region snapshot copy is enabled.
         */
        public var destinationRegion: kotlin.String? = null
        /**
         * The number of days that automated snapshots are retained in the destination region after they are copied from a source region. If the value is -1, the manual snapshot is retained indefinitely.
         *
         * The value must be either -1 or an integer between 1 and 3,653.
         */
        public var manualSnapshotRetentionPeriod: kotlin.Int? = null
        /**
         * The number of days that automated snapshots are retained in the destination region after they are copied from a source region.
         */
        public var retentionPeriod: kotlin.Long? = null
        /**
         * The name of the snapshot copy grant.
         */
        public var snapshotCopyGrantName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.ClusterSnapshotCopyStatus) : this() {
            this.destinationRegion = x.destinationRegion
            this.manualSnapshotRetentionPeriod = x.manualSnapshotRetentionPeriod
            this.retentionPeriod = x.retentionPeriod
            this.snapshotCopyGrantName = x.snapshotCopyGrantName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.ClusterSnapshotCopyStatus = ClusterSnapshotCopyStatus(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
