// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.redshift.auth.DefaultRedshiftAuthSchemeProvider
import aws.sdk.kotlin.services.redshift.auth.RedshiftAuthSchemeProvider
import aws.sdk.kotlin.services.redshift.endpoints.DefaultRedshiftEndpointProvider
import aws.sdk.kotlin.services.redshift.endpoints.RedshiftEndpointParameters
import aws.sdk.kotlin.services.redshift.endpoints.RedshiftEndpointProvider
import aws.sdk.kotlin.services.redshift.model.AcceptReservedNodeExchangeRequest
import aws.sdk.kotlin.services.redshift.model.AcceptReservedNodeExchangeResponse
import aws.sdk.kotlin.services.redshift.model.AddPartnerRequest
import aws.sdk.kotlin.services.redshift.model.AddPartnerResponse
import aws.sdk.kotlin.services.redshift.model.AssociateDataShareConsumerRequest
import aws.sdk.kotlin.services.redshift.model.AssociateDataShareConsumerResponse
import aws.sdk.kotlin.services.redshift.model.AuthorizeClusterSecurityGroupIngressRequest
import aws.sdk.kotlin.services.redshift.model.AuthorizeClusterSecurityGroupIngressResponse
import aws.sdk.kotlin.services.redshift.model.AuthorizeDataShareRequest
import aws.sdk.kotlin.services.redshift.model.AuthorizeDataShareResponse
import aws.sdk.kotlin.services.redshift.model.AuthorizeEndpointAccessRequest
import aws.sdk.kotlin.services.redshift.model.AuthorizeEndpointAccessResponse
import aws.sdk.kotlin.services.redshift.model.AuthorizeSnapshotAccessRequest
import aws.sdk.kotlin.services.redshift.model.AuthorizeSnapshotAccessResponse
import aws.sdk.kotlin.services.redshift.model.BatchDeleteClusterSnapshotsRequest
import aws.sdk.kotlin.services.redshift.model.BatchDeleteClusterSnapshotsResponse
import aws.sdk.kotlin.services.redshift.model.BatchModifyClusterSnapshotsRequest
import aws.sdk.kotlin.services.redshift.model.BatchModifyClusterSnapshotsResponse
import aws.sdk.kotlin.services.redshift.model.CancelResizeRequest
import aws.sdk.kotlin.services.redshift.model.CancelResizeResponse
import aws.sdk.kotlin.services.redshift.model.CopyClusterSnapshotRequest
import aws.sdk.kotlin.services.redshift.model.CopyClusterSnapshotResponse
import aws.sdk.kotlin.services.redshift.model.CreateAuthenticationProfileRequest
import aws.sdk.kotlin.services.redshift.model.CreateAuthenticationProfileResponse
import aws.sdk.kotlin.services.redshift.model.CreateClusterParameterGroupRequest
import aws.sdk.kotlin.services.redshift.model.CreateClusterParameterGroupResponse
import aws.sdk.kotlin.services.redshift.model.CreateClusterRequest
import aws.sdk.kotlin.services.redshift.model.CreateClusterResponse
import aws.sdk.kotlin.services.redshift.model.CreateClusterSecurityGroupRequest
import aws.sdk.kotlin.services.redshift.model.CreateClusterSecurityGroupResponse
import aws.sdk.kotlin.services.redshift.model.CreateClusterSnapshotRequest
import aws.sdk.kotlin.services.redshift.model.CreateClusterSnapshotResponse
import aws.sdk.kotlin.services.redshift.model.CreateClusterSubnetGroupRequest
import aws.sdk.kotlin.services.redshift.model.CreateClusterSubnetGroupResponse
import aws.sdk.kotlin.services.redshift.model.CreateCustomDomainAssociationRequest
import aws.sdk.kotlin.services.redshift.model.CreateCustomDomainAssociationResponse
import aws.sdk.kotlin.services.redshift.model.CreateEndpointAccessRequest
import aws.sdk.kotlin.services.redshift.model.CreateEndpointAccessResponse
import aws.sdk.kotlin.services.redshift.model.CreateEventSubscriptionRequest
import aws.sdk.kotlin.services.redshift.model.CreateEventSubscriptionResponse
import aws.sdk.kotlin.services.redshift.model.CreateHsmClientCertificateRequest
import aws.sdk.kotlin.services.redshift.model.CreateHsmClientCertificateResponse
import aws.sdk.kotlin.services.redshift.model.CreateHsmConfigurationRequest
import aws.sdk.kotlin.services.redshift.model.CreateHsmConfigurationResponse
import aws.sdk.kotlin.services.redshift.model.CreateRedshiftIdcApplicationRequest
import aws.sdk.kotlin.services.redshift.model.CreateRedshiftIdcApplicationResponse
import aws.sdk.kotlin.services.redshift.model.CreateScheduledActionRequest
import aws.sdk.kotlin.services.redshift.model.CreateScheduledActionResponse
import aws.sdk.kotlin.services.redshift.model.CreateSnapshotCopyGrantRequest
import aws.sdk.kotlin.services.redshift.model.CreateSnapshotCopyGrantResponse
import aws.sdk.kotlin.services.redshift.model.CreateSnapshotScheduleRequest
import aws.sdk.kotlin.services.redshift.model.CreateSnapshotScheduleResponse
import aws.sdk.kotlin.services.redshift.model.CreateTagsRequest
import aws.sdk.kotlin.services.redshift.model.CreateTagsResponse
import aws.sdk.kotlin.services.redshift.model.CreateUsageLimitRequest
import aws.sdk.kotlin.services.redshift.model.CreateUsageLimitResponse
import aws.sdk.kotlin.services.redshift.model.DeauthorizeDataShareRequest
import aws.sdk.kotlin.services.redshift.model.DeauthorizeDataShareResponse
import aws.sdk.kotlin.services.redshift.model.DeleteAuthenticationProfileRequest
import aws.sdk.kotlin.services.redshift.model.DeleteAuthenticationProfileResponse
import aws.sdk.kotlin.services.redshift.model.DeleteClusterParameterGroupRequest
import aws.sdk.kotlin.services.redshift.model.DeleteClusterParameterGroupResponse
import aws.sdk.kotlin.services.redshift.model.DeleteClusterRequest
import aws.sdk.kotlin.services.redshift.model.DeleteClusterResponse
import aws.sdk.kotlin.services.redshift.model.DeleteClusterSecurityGroupRequest
import aws.sdk.kotlin.services.redshift.model.DeleteClusterSecurityGroupResponse
import aws.sdk.kotlin.services.redshift.model.DeleteClusterSnapshotRequest
import aws.sdk.kotlin.services.redshift.model.DeleteClusterSnapshotResponse
import aws.sdk.kotlin.services.redshift.model.DeleteClusterSubnetGroupRequest
import aws.sdk.kotlin.services.redshift.model.DeleteClusterSubnetGroupResponse
import aws.sdk.kotlin.services.redshift.model.DeleteCustomDomainAssociationRequest
import aws.sdk.kotlin.services.redshift.model.DeleteCustomDomainAssociationResponse
import aws.sdk.kotlin.services.redshift.model.DeleteEndpointAccessRequest
import aws.sdk.kotlin.services.redshift.model.DeleteEndpointAccessResponse
import aws.sdk.kotlin.services.redshift.model.DeleteEventSubscriptionRequest
import aws.sdk.kotlin.services.redshift.model.DeleteEventSubscriptionResponse
import aws.sdk.kotlin.services.redshift.model.DeleteHsmClientCertificateRequest
import aws.sdk.kotlin.services.redshift.model.DeleteHsmClientCertificateResponse
import aws.sdk.kotlin.services.redshift.model.DeleteHsmConfigurationRequest
import aws.sdk.kotlin.services.redshift.model.DeleteHsmConfigurationResponse
import aws.sdk.kotlin.services.redshift.model.DeletePartnerRequest
import aws.sdk.kotlin.services.redshift.model.DeletePartnerResponse
import aws.sdk.kotlin.services.redshift.model.DeleteRedshiftIdcApplicationRequest
import aws.sdk.kotlin.services.redshift.model.DeleteRedshiftIdcApplicationResponse
import aws.sdk.kotlin.services.redshift.model.DeleteResourcePolicyRequest
import aws.sdk.kotlin.services.redshift.model.DeleteResourcePolicyResponse
import aws.sdk.kotlin.services.redshift.model.DeleteScheduledActionRequest
import aws.sdk.kotlin.services.redshift.model.DeleteScheduledActionResponse
import aws.sdk.kotlin.services.redshift.model.DeleteSnapshotCopyGrantRequest
import aws.sdk.kotlin.services.redshift.model.DeleteSnapshotCopyGrantResponse
import aws.sdk.kotlin.services.redshift.model.DeleteSnapshotScheduleRequest
import aws.sdk.kotlin.services.redshift.model.DeleteSnapshotScheduleResponse
import aws.sdk.kotlin.services.redshift.model.DeleteTagsRequest
import aws.sdk.kotlin.services.redshift.model.DeleteTagsResponse
import aws.sdk.kotlin.services.redshift.model.DeleteUsageLimitRequest
import aws.sdk.kotlin.services.redshift.model.DeleteUsageLimitResponse
import aws.sdk.kotlin.services.redshift.model.DescribeAccountAttributesRequest
import aws.sdk.kotlin.services.redshift.model.DescribeAccountAttributesResponse
import aws.sdk.kotlin.services.redshift.model.DescribeAuthenticationProfilesRequest
import aws.sdk.kotlin.services.redshift.model.DescribeAuthenticationProfilesResponse
import aws.sdk.kotlin.services.redshift.model.DescribeClusterDbRevisionsRequest
import aws.sdk.kotlin.services.redshift.model.DescribeClusterDbRevisionsResponse
import aws.sdk.kotlin.services.redshift.model.DescribeClusterParameterGroupsRequest
import aws.sdk.kotlin.services.redshift.model.DescribeClusterParameterGroupsResponse
import aws.sdk.kotlin.services.redshift.model.DescribeClusterParametersRequest
import aws.sdk.kotlin.services.redshift.model.DescribeClusterParametersResponse
import aws.sdk.kotlin.services.redshift.model.DescribeClusterSecurityGroupsRequest
import aws.sdk.kotlin.services.redshift.model.DescribeClusterSecurityGroupsResponse
import aws.sdk.kotlin.services.redshift.model.DescribeClusterSnapshotsRequest
import aws.sdk.kotlin.services.redshift.model.DescribeClusterSnapshotsResponse
import aws.sdk.kotlin.services.redshift.model.DescribeClusterSubnetGroupsRequest
import aws.sdk.kotlin.services.redshift.model.DescribeClusterSubnetGroupsResponse
import aws.sdk.kotlin.services.redshift.model.DescribeClusterTracksRequest
import aws.sdk.kotlin.services.redshift.model.DescribeClusterTracksResponse
import aws.sdk.kotlin.services.redshift.model.DescribeClusterVersionsRequest
import aws.sdk.kotlin.services.redshift.model.DescribeClusterVersionsResponse
import aws.sdk.kotlin.services.redshift.model.DescribeClustersRequest
import aws.sdk.kotlin.services.redshift.model.DescribeClustersResponse
import aws.sdk.kotlin.services.redshift.model.DescribeCustomDomainAssociationsRequest
import aws.sdk.kotlin.services.redshift.model.DescribeCustomDomainAssociationsResponse
import aws.sdk.kotlin.services.redshift.model.DescribeDataSharesForConsumerRequest
import aws.sdk.kotlin.services.redshift.model.DescribeDataSharesForConsumerResponse
import aws.sdk.kotlin.services.redshift.model.DescribeDataSharesForProducerRequest
import aws.sdk.kotlin.services.redshift.model.DescribeDataSharesForProducerResponse
import aws.sdk.kotlin.services.redshift.model.DescribeDataSharesRequest
import aws.sdk.kotlin.services.redshift.model.DescribeDataSharesResponse
import aws.sdk.kotlin.services.redshift.model.DescribeDefaultClusterParametersRequest
import aws.sdk.kotlin.services.redshift.model.DescribeDefaultClusterParametersResponse
import aws.sdk.kotlin.services.redshift.model.DescribeEndpointAccessRequest
import aws.sdk.kotlin.services.redshift.model.DescribeEndpointAccessResponse
import aws.sdk.kotlin.services.redshift.model.DescribeEndpointAuthorizationRequest
import aws.sdk.kotlin.services.redshift.model.DescribeEndpointAuthorizationResponse
import aws.sdk.kotlin.services.redshift.model.DescribeEventCategoriesRequest
import aws.sdk.kotlin.services.redshift.model.DescribeEventCategoriesResponse
import aws.sdk.kotlin.services.redshift.model.DescribeEventSubscriptionsRequest
import aws.sdk.kotlin.services.redshift.model.DescribeEventSubscriptionsResponse
import aws.sdk.kotlin.services.redshift.model.DescribeEventsRequest
import aws.sdk.kotlin.services.redshift.model.DescribeEventsResponse
import aws.sdk.kotlin.services.redshift.model.DescribeHsmClientCertificatesRequest
import aws.sdk.kotlin.services.redshift.model.DescribeHsmClientCertificatesResponse
import aws.sdk.kotlin.services.redshift.model.DescribeHsmConfigurationsRequest
import aws.sdk.kotlin.services.redshift.model.DescribeHsmConfigurationsResponse
import aws.sdk.kotlin.services.redshift.model.DescribeInboundIntegrationsRequest
import aws.sdk.kotlin.services.redshift.model.DescribeInboundIntegrationsResponse
import aws.sdk.kotlin.services.redshift.model.DescribeLoggingStatusRequest
import aws.sdk.kotlin.services.redshift.model.DescribeLoggingStatusResponse
import aws.sdk.kotlin.services.redshift.model.DescribeNodeConfigurationOptionsRequest
import aws.sdk.kotlin.services.redshift.model.DescribeNodeConfigurationOptionsResponse
import aws.sdk.kotlin.services.redshift.model.DescribeOrderableClusterOptionsRequest
import aws.sdk.kotlin.services.redshift.model.DescribeOrderableClusterOptionsResponse
import aws.sdk.kotlin.services.redshift.model.DescribePartnersRequest
import aws.sdk.kotlin.services.redshift.model.DescribePartnersResponse
import aws.sdk.kotlin.services.redshift.model.DescribeRedshiftIdcApplicationsRequest
import aws.sdk.kotlin.services.redshift.model.DescribeRedshiftIdcApplicationsResponse
import aws.sdk.kotlin.services.redshift.model.DescribeReservedNodeExchangeStatusRequest
import aws.sdk.kotlin.services.redshift.model.DescribeReservedNodeExchangeStatusResponse
import aws.sdk.kotlin.services.redshift.model.DescribeReservedNodeOfferingsRequest
import aws.sdk.kotlin.services.redshift.model.DescribeReservedNodeOfferingsResponse
import aws.sdk.kotlin.services.redshift.model.DescribeReservedNodesRequest
import aws.sdk.kotlin.services.redshift.model.DescribeReservedNodesResponse
import aws.sdk.kotlin.services.redshift.model.DescribeResizeRequest
import aws.sdk.kotlin.services.redshift.model.DescribeResizeResponse
import aws.sdk.kotlin.services.redshift.model.DescribeScheduledActionsRequest
import aws.sdk.kotlin.services.redshift.model.DescribeScheduledActionsResponse
import aws.sdk.kotlin.services.redshift.model.DescribeSnapshotCopyGrantsRequest
import aws.sdk.kotlin.services.redshift.model.DescribeSnapshotCopyGrantsResponse
import aws.sdk.kotlin.services.redshift.model.DescribeSnapshotSchedulesRequest
import aws.sdk.kotlin.services.redshift.model.DescribeSnapshotSchedulesResponse
import aws.sdk.kotlin.services.redshift.model.DescribeStorageRequest
import aws.sdk.kotlin.services.redshift.model.DescribeStorageResponse
import aws.sdk.kotlin.services.redshift.model.DescribeTableRestoreStatusRequest
import aws.sdk.kotlin.services.redshift.model.DescribeTableRestoreStatusResponse
import aws.sdk.kotlin.services.redshift.model.DescribeTagsRequest
import aws.sdk.kotlin.services.redshift.model.DescribeTagsResponse
import aws.sdk.kotlin.services.redshift.model.DescribeUsageLimitsRequest
import aws.sdk.kotlin.services.redshift.model.DescribeUsageLimitsResponse
import aws.sdk.kotlin.services.redshift.model.DisableLoggingRequest
import aws.sdk.kotlin.services.redshift.model.DisableLoggingResponse
import aws.sdk.kotlin.services.redshift.model.DisableSnapshotCopyRequest
import aws.sdk.kotlin.services.redshift.model.DisableSnapshotCopyResponse
import aws.sdk.kotlin.services.redshift.model.DisassociateDataShareConsumerRequest
import aws.sdk.kotlin.services.redshift.model.DisassociateDataShareConsumerResponse
import aws.sdk.kotlin.services.redshift.model.EnableLoggingRequest
import aws.sdk.kotlin.services.redshift.model.EnableLoggingResponse
import aws.sdk.kotlin.services.redshift.model.EnableSnapshotCopyRequest
import aws.sdk.kotlin.services.redshift.model.EnableSnapshotCopyResponse
import aws.sdk.kotlin.services.redshift.model.FailoverPrimaryComputeRequest
import aws.sdk.kotlin.services.redshift.model.FailoverPrimaryComputeResponse
import aws.sdk.kotlin.services.redshift.model.GetClusterCredentialsRequest
import aws.sdk.kotlin.services.redshift.model.GetClusterCredentialsResponse
import aws.sdk.kotlin.services.redshift.model.GetClusterCredentialsWithIamRequest
import aws.sdk.kotlin.services.redshift.model.GetClusterCredentialsWithIamResponse
import aws.sdk.kotlin.services.redshift.model.GetReservedNodeExchangeConfigurationOptionsRequest
import aws.sdk.kotlin.services.redshift.model.GetReservedNodeExchangeConfigurationOptionsResponse
import aws.sdk.kotlin.services.redshift.model.GetReservedNodeExchangeOfferingsRequest
import aws.sdk.kotlin.services.redshift.model.GetReservedNodeExchangeOfferingsResponse
import aws.sdk.kotlin.services.redshift.model.GetResourcePolicyRequest
import aws.sdk.kotlin.services.redshift.model.GetResourcePolicyResponse
import aws.sdk.kotlin.services.redshift.model.ListRecommendationsRequest
import aws.sdk.kotlin.services.redshift.model.ListRecommendationsResponse
import aws.sdk.kotlin.services.redshift.model.ModifyAquaConfigurationRequest
import aws.sdk.kotlin.services.redshift.model.ModifyAquaConfigurationResponse
import aws.sdk.kotlin.services.redshift.model.ModifyAuthenticationProfileRequest
import aws.sdk.kotlin.services.redshift.model.ModifyAuthenticationProfileResponse
import aws.sdk.kotlin.services.redshift.model.ModifyClusterDbRevisionRequest
import aws.sdk.kotlin.services.redshift.model.ModifyClusterDbRevisionResponse
import aws.sdk.kotlin.services.redshift.model.ModifyClusterIamRolesRequest
import aws.sdk.kotlin.services.redshift.model.ModifyClusterIamRolesResponse
import aws.sdk.kotlin.services.redshift.model.ModifyClusterMaintenanceRequest
import aws.sdk.kotlin.services.redshift.model.ModifyClusterMaintenanceResponse
import aws.sdk.kotlin.services.redshift.model.ModifyClusterParameterGroupRequest
import aws.sdk.kotlin.services.redshift.model.ModifyClusterParameterGroupResponse
import aws.sdk.kotlin.services.redshift.model.ModifyClusterRequest
import aws.sdk.kotlin.services.redshift.model.ModifyClusterResponse
import aws.sdk.kotlin.services.redshift.model.ModifyClusterSnapshotRequest
import aws.sdk.kotlin.services.redshift.model.ModifyClusterSnapshotResponse
import aws.sdk.kotlin.services.redshift.model.ModifyClusterSnapshotScheduleRequest
import aws.sdk.kotlin.services.redshift.model.ModifyClusterSnapshotScheduleResponse
import aws.sdk.kotlin.services.redshift.model.ModifyClusterSubnetGroupRequest
import aws.sdk.kotlin.services.redshift.model.ModifyClusterSubnetGroupResponse
import aws.sdk.kotlin.services.redshift.model.ModifyCustomDomainAssociationRequest
import aws.sdk.kotlin.services.redshift.model.ModifyCustomDomainAssociationResponse
import aws.sdk.kotlin.services.redshift.model.ModifyEndpointAccessRequest
import aws.sdk.kotlin.services.redshift.model.ModifyEndpointAccessResponse
import aws.sdk.kotlin.services.redshift.model.ModifyEventSubscriptionRequest
import aws.sdk.kotlin.services.redshift.model.ModifyEventSubscriptionResponse
import aws.sdk.kotlin.services.redshift.model.ModifyRedshiftIdcApplicationRequest
import aws.sdk.kotlin.services.redshift.model.ModifyRedshiftIdcApplicationResponse
import aws.sdk.kotlin.services.redshift.model.ModifyScheduledActionRequest
import aws.sdk.kotlin.services.redshift.model.ModifyScheduledActionResponse
import aws.sdk.kotlin.services.redshift.model.ModifySnapshotCopyRetentionPeriodRequest
import aws.sdk.kotlin.services.redshift.model.ModifySnapshotCopyRetentionPeriodResponse
import aws.sdk.kotlin.services.redshift.model.ModifySnapshotScheduleRequest
import aws.sdk.kotlin.services.redshift.model.ModifySnapshotScheduleResponse
import aws.sdk.kotlin.services.redshift.model.ModifyUsageLimitRequest
import aws.sdk.kotlin.services.redshift.model.ModifyUsageLimitResponse
import aws.sdk.kotlin.services.redshift.model.PauseClusterRequest
import aws.sdk.kotlin.services.redshift.model.PauseClusterResponse
import aws.sdk.kotlin.services.redshift.model.PurchaseReservedNodeOfferingRequest
import aws.sdk.kotlin.services.redshift.model.PurchaseReservedNodeOfferingResponse
import aws.sdk.kotlin.services.redshift.model.PutResourcePolicyRequest
import aws.sdk.kotlin.services.redshift.model.PutResourcePolicyResponse
import aws.sdk.kotlin.services.redshift.model.RebootClusterRequest
import aws.sdk.kotlin.services.redshift.model.RebootClusterResponse
import aws.sdk.kotlin.services.redshift.model.RejectDataShareRequest
import aws.sdk.kotlin.services.redshift.model.RejectDataShareResponse
import aws.sdk.kotlin.services.redshift.model.ResetClusterParameterGroupRequest
import aws.sdk.kotlin.services.redshift.model.ResetClusterParameterGroupResponse
import aws.sdk.kotlin.services.redshift.model.ResizeClusterRequest
import aws.sdk.kotlin.services.redshift.model.ResizeClusterResponse
import aws.sdk.kotlin.services.redshift.model.RestoreFromClusterSnapshotRequest
import aws.sdk.kotlin.services.redshift.model.RestoreFromClusterSnapshotResponse
import aws.sdk.kotlin.services.redshift.model.RestoreTableFromClusterSnapshotRequest
import aws.sdk.kotlin.services.redshift.model.RestoreTableFromClusterSnapshotResponse
import aws.sdk.kotlin.services.redshift.model.ResumeClusterRequest
import aws.sdk.kotlin.services.redshift.model.ResumeClusterResponse
import aws.sdk.kotlin.services.redshift.model.RevokeClusterSecurityGroupIngressRequest
import aws.sdk.kotlin.services.redshift.model.RevokeClusterSecurityGroupIngressResponse
import aws.sdk.kotlin.services.redshift.model.RevokeEndpointAccessRequest
import aws.sdk.kotlin.services.redshift.model.RevokeEndpointAccessResponse
import aws.sdk.kotlin.services.redshift.model.RevokeSnapshotAccessRequest
import aws.sdk.kotlin.services.redshift.model.RevokeSnapshotAccessResponse
import aws.sdk.kotlin.services.redshift.model.RotateEncryptionKeyRequest
import aws.sdk.kotlin.services.redshift.model.RotateEncryptionKeyResponse
import aws.sdk.kotlin.services.redshift.model.UpdatePartnerStatusRequest
import aws.sdk.kotlin.services.redshift.model.UpdatePartnerStatusResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Redshift"
public const val SdkVersion: String = "1.3.24"
public const val ServiceApiVersion: String = "2012-12-01"

/**
 * # Amazon Redshift
 * **Overview**
 *
 * This is an interface reference for Amazon Redshift. It contains documentation for one of the programming or command line interfaces you can use to manage Amazon Redshift clusters. Note that Amazon Redshift is asynchronous, which means that some interfaces may require techniques, such as polling or asynchronous callback handlers, to determine when a command has been applied. In this reference, the parameter descriptions indicate whether a change is applied immediately, on the next instance reboot, or during the next maintenance window. For a summary of the Amazon Redshift cluster management interfaces, go to [Using the Amazon Redshift Management Interfaces](https://docs.aws.amazon.com/redshift/latest/mgmt/using-aws-sdk.html).
 *
 * Amazon Redshift manages all the work of setting up, operating, and scaling a data warehouse: provisioning capacity, monitoring and backing up the cluster, and applying patches and upgrades to the Amazon Redshift engine. You can focus on using your data to acquire new insights for your business and customers.
 *
 * If you are a first-time user of Amazon Redshift, we recommend that you begin by reading the [Amazon Redshift Getting Started Guide](https://docs.aws.amazon.com/redshift/latest/gsg/getting-started.html).
 *
 * If you are a database developer, the [Amazon Redshift Database Developer Guide](https://docs.aws.amazon.com/redshift/latest/dg/welcome.html) explains how to design, build, query, and maintain the databases that make up your data warehouse.
 */
public interface RedshiftClient : SdkClient {
    /**
     * RedshiftClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, RedshiftClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Redshift",
                "REDSHIFT",
                "redshift",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, RedshiftClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): RedshiftClient = DefaultRedshiftClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: RedshiftEndpointProvider = builder.endpointProvider ?: DefaultRedshiftEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: RedshiftAuthSchemeProvider = builder.authSchemeProvider ?: DefaultRedshiftAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Redshift"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: RedshiftEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: RedshiftAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Exchanges a DC1 Reserved Node for a DC2 Reserved Node with no changes to the configuration (term, payment type, or number of nodes) and no additional costs.
     */
    public suspend fun acceptReservedNodeExchange(input: AcceptReservedNodeExchangeRequest): AcceptReservedNodeExchangeResponse

    /**
     * Adds a partner integration to a cluster. This operation authorizes a partner to push status updates for the specified database. To complete the integration, you also set up the integration on the partner website.
     */
    public suspend fun addPartner(input: AddPartnerRequest): AddPartnerResponse

    /**
     * From a datashare consumer account, associates a datashare with the account (AssociateEntireAccount) or the specified namespace (ConsumerArn). If you make this association, the consumer can consume the datashare.
     */
    public suspend fun associateDataShareConsumer(input: AssociateDataShareConsumerRequest): AssociateDataShareConsumerResponse

    /**
     * Adds an inbound (ingress) rule to an Amazon Redshift security group. Depending on whether the application accessing your cluster is running on the Internet or an Amazon EC2 instance, you can authorize inbound access to either a Classless Interdomain Routing (CIDR)/Internet Protocol (IP) range or to an Amazon EC2 security group. You can add as many as 20 ingress rules to an Amazon Redshift security group.
     *
     * If you authorize access to an Amazon EC2 security group, specify *EC2SecurityGroupName* and *EC2SecurityGroupOwnerId*. The Amazon EC2 security group and Amazon Redshift cluster must be in the same Amazon Web Services Region.
     *
     * If you authorize access to a CIDR/IP address range, specify *CIDRIP*. For an overview of CIDR blocks, see the Wikipedia article on [Classless Inter-Domain Routing](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
     *
     * You must also associate the security group with a cluster so that clients running on these IP addresses or the EC2 instance are authorized to connect to the cluster. For information about managing security groups, go to [Working with Security Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    public suspend fun authorizeClusterSecurityGroupIngress(input: AuthorizeClusterSecurityGroupIngressRequest): AuthorizeClusterSecurityGroupIngressResponse

    /**
     * From a data producer account, authorizes the sharing of a datashare with one or more consumer accounts or managing entities. To authorize a datashare for a data consumer, the producer account must have the correct access permissions.
     */
    public suspend fun authorizeDataShare(input: AuthorizeDataShareRequest): AuthorizeDataShareResponse

    /**
     * Grants access to a cluster.
     */
    public suspend fun authorizeEndpointAccess(input: AuthorizeEndpointAccessRequest): AuthorizeEndpointAccessResponse

    /**
     * Authorizes the specified Amazon Web Services account to restore the specified snapshot.
     *
     *  For more information about working with snapshots, go to [Amazon Redshift Snapshots](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    public suspend fun authorizeSnapshotAccess(input: AuthorizeSnapshotAccessRequest): AuthorizeSnapshotAccessResponse

    /**
     * Deletes a set of cluster snapshots.
     */
    public suspend fun batchDeleteClusterSnapshots(input: BatchDeleteClusterSnapshotsRequest): BatchDeleteClusterSnapshotsResponse

    /**
     * Modifies the settings for a set of cluster snapshots.
     */
    public suspend fun batchModifyClusterSnapshots(input: BatchModifyClusterSnapshotsRequest): BatchModifyClusterSnapshotsResponse

    /**
     * Cancels a resize operation for a cluster.
     */
    public suspend fun cancelResize(input: CancelResizeRequest): CancelResizeResponse

    /**
     * Copies the specified automated cluster snapshot to a new manual cluster snapshot. The source must be an automated snapshot and it must be in the available state.
     *
     * When you delete a cluster, Amazon Redshift deletes any automated snapshots of the cluster. Also, when the retention period of the snapshot expires, Amazon Redshift automatically deletes it. If you want to keep an automated snapshot for a longer period, you can make a manual copy of the snapshot. Manual snapshots are retained until you delete them.
     *
     *  For more information about working with snapshots, go to [Amazon Redshift Snapshots](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    public suspend fun copyClusterSnapshot(input: CopyClusterSnapshotRequest): CopyClusterSnapshotResponse

    /**
     * Creates an authentication profile with the specified parameters.
     */
    public suspend fun createAuthenticationProfile(input: CreateAuthenticationProfileRequest): CreateAuthenticationProfileResponse

    /**
     * Creates a new cluster with the specified parameters.
     *
     * To create a cluster in Virtual Private Cloud (VPC), you must provide a cluster subnet group name. The cluster subnet group identifies the subnets of your VPC that Amazon Redshift uses when creating the cluster. For more information about managing clusters, go to [Amazon Redshift Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    public suspend fun createCluster(input: CreateClusterRequest): CreateClusterResponse

    /**
     * Creates an Amazon Redshift parameter group.
     *
     * Creating parameter groups is independent of creating clusters. You can associate a cluster with a parameter group when you create the cluster. You can also associate an existing cluster with a parameter group after the cluster is created by using ModifyCluster.
     *
     * Parameters in the parameter group define specific behavior that applies to the databases you create on the cluster. For more information about parameters and parameter groups, go to [Amazon Redshift Parameter Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    public suspend fun createClusterParameterGroup(input: CreateClusterParameterGroupRequest): CreateClusterParameterGroupResponse

    /**
     * Creates a new Amazon Redshift security group. You use security groups to control access to non-VPC clusters.
     *
     *  For information about managing security groups, go to [Amazon Redshift Cluster Security Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    public suspend fun createClusterSecurityGroup(input: CreateClusterSecurityGroupRequest): CreateClusterSecurityGroupResponse

    /**
     * Creates a manual snapshot of the specified cluster. The cluster must be in the `available` state.
     *
     *  For more information about working with snapshots, go to [Amazon Redshift Snapshots](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    public suspend fun createClusterSnapshot(input: CreateClusterSnapshotRequest): CreateClusterSnapshotResponse

    /**
     * Creates a new Amazon Redshift subnet group. You must provide a list of one or more subnets in your existing Amazon Virtual Private Cloud (Amazon VPC) when creating Amazon Redshift subnet group.
     *
     *  For information about subnet groups, go to [Amazon Redshift Cluster Subnet Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-cluster-subnet-groups.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    public suspend fun createClusterSubnetGroup(input: CreateClusterSubnetGroupRequest): CreateClusterSubnetGroupResponse

    /**
     * Used to create a custom domain name for a cluster. Properties include the custom domain name, the cluster the custom domain is associated with, and the certificate Amazon Resource Name (ARN).
     */
    public suspend fun createCustomDomainAssociation(input: CreateCustomDomainAssociationRequest): CreateCustomDomainAssociationResponse

    /**
     * Creates a Redshift-managed VPC endpoint.
     */
    public suspend fun createEndpointAccess(input: CreateEndpointAccessRequest): CreateEndpointAccessResponse

    /**
     * Creates an Amazon Redshift event notification subscription. This action requires an ARN (Amazon Resource Name) of an Amazon SNS topic created by either the Amazon Redshift console, the Amazon SNS console, or the Amazon SNS API. To obtain an ARN with Amazon SNS, you must create a topic in Amazon SNS and subscribe to the topic. The ARN is displayed in the SNS console.
     *
     * You can specify the source type, and lists of Amazon Redshift source IDs, event categories, and event severities. Notifications will be sent for all events you want that match those criteria. For example, you can specify source type = cluster, source ID = my-cluster-1 and mycluster2, event categories = Availability, Backup, and severity = ERROR. The subscription will only send notifications for those ERROR events in the Availability and Backup categories for the specified clusters.
     *
     * If you specify both the source type and source IDs, such as source type = cluster and source identifier = my-cluster-1, notifications will be sent for all the cluster events for my-cluster-1. If you specify a source type but do not specify a source identifier, you will receive notice of the events for the objects of that type in your Amazon Web Services account. If you do not specify either the SourceType nor the SourceIdentifier, you will be notified of events generated from all Amazon Redshift sources belonging to your Amazon Web Services account. You must specify a source type if you specify a source ID.
     */
    public suspend fun createEventSubscription(input: CreateEventSubscriptionRequest): CreateEventSubscriptionResponse

    /**
     * Creates an HSM client certificate that an Amazon Redshift cluster will use to connect to the client's HSM in order to store and retrieve the keys used to encrypt the cluster databases.
     *
     * The command returns a public key, which you must store in the HSM. In addition to creating the HSM certificate, you must create an Amazon Redshift HSM configuration that provides a cluster the information needed to store and use encryption keys in the HSM. For more information, go to [Hardware Security Modules](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html#working-with-HSM) in the *Amazon Redshift Cluster Management Guide*.
     */
    public suspend fun createHsmClientCertificate(input: CreateHsmClientCertificateRequest): CreateHsmClientCertificateResponse

    /**
     * Creates an HSM configuration that contains the information required by an Amazon Redshift cluster to store and use database encryption keys in a Hardware Security Module (HSM). After creating the HSM configuration, you can specify it as a parameter when creating a cluster. The cluster will then store its encryption keys in the HSM.
     *
     * In addition to creating an HSM configuration, you must also create an HSM client certificate. For more information, go to [Hardware Security Modules](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-HSM.html) in the Amazon Redshift Cluster Management Guide.
     */
    public suspend fun createHsmConfiguration(input: CreateHsmConfigurationRequest): CreateHsmConfigurationResponse

    /**
     * Creates an Amazon Redshift application for use with IAM Identity Center.
     */
    public suspend fun createRedshiftIdcApplication(input: CreateRedshiftIdcApplicationRequest): CreateRedshiftIdcApplicationResponse

    /**
     * Creates a scheduled action. A scheduled action contains a schedule and an Amazon Redshift API action. For example, you can create a schedule of when to run the `ResizeCluster` API operation.
     */
    public suspend fun createScheduledAction(input: CreateScheduledActionRequest): CreateScheduledActionResponse

    /**
     * Creates a snapshot copy grant that permits Amazon Redshift to use an encrypted symmetric key from Key Management Service (KMS) to encrypt copied snapshots in a destination region.
     *
     *  For more information about managing snapshot copy grants, go to [Amazon Redshift Database Encryption](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    public suspend fun createSnapshotCopyGrant(input: CreateSnapshotCopyGrantRequest): CreateSnapshotCopyGrantResponse

    /**
     * Create a snapshot schedule that can be associated to a cluster and which overrides the default system backup schedule.
     */
    public suspend fun createSnapshotSchedule(input: CreateSnapshotScheduleRequest = CreateSnapshotScheduleRequest { }): CreateSnapshotScheduleResponse

    /**
     * Adds tags to a cluster.
     *
     * A resource can have up to 50 tags. If you try to create more than 50 tags for a resource, you will receive an error and the attempt will fail.
     *
     * If you specify a key that already exists for the resource, the value for that key will be updated with the new value.
     */
    public suspend fun createTags(input: CreateTagsRequest): CreateTagsResponse

    /**
     * Creates a usage limit for a specified Amazon Redshift feature on a cluster. The usage limit is identified by the returned usage limit identifier.
     */
    public suspend fun createUsageLimit(input: CreateUsageLimitRequest): CreateUsageLimitResponse

    /**
     * From a datashare producer account, removes authorization from the specified datashare.
     */
    public suspend fun deauthorizeDataShare(input: DeauthorizeDataShareRequest): DeauthorizeDataShareResponse

    /**
     * Deletes an authentication profile.
     */
    public suspend fun deleteAuthenticationProfile(input: DeleteAuthenticationProfileRequest): DeleteAuthenticationProfileResponse

    /**
     * Deletes a previously provisioned cluster without its final snapshot being created. A successful response from the web service indicates that the request was received correctly. Use DescribeClusters to monitor the status of the deletion. The delete operation cannot be canceled or reverted once submitted. For more information about managing clusters, go to [Amazon Redshift Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html) in the *Amazon Redshift Cluster Management Guide*.
     *
     * If you want to shut down the cluster and retain it for future use, set *SkipFinalClusterSnapshot* to `false` and specify a name for *FinalClusterSnapshotIdentifier*. You can later restore this snapshot to resume using the cluster. If a final cluster snapshot is requested, the status of the cluster will be "final-snapshot" while the snapshot is being taken, then it's "deleting" once Amazon Redshift begins deleting the cluster.
     *
     *  For more information about managing clusters, go to [Amazon Redshift Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    public suspend fun deleteCluster(input: DeleteClusterRequest): DeleteClusterResponse

    /**
     * Deletes a specified Amazon Redshift parameter group.
     *
     * You cannot delete a parameter group if it is associated with a cluster.
     */
    public suspend fun deleteClusterParameterGroup(input: DeleteClusterParameterGroupRequest): DeleteClusterParameterGroupResponse

    /**
     * Deletes an Amazon Redshift security group.
     *
     * You cannot delete a security group that is associated with any clusters. You cannot delete the default security group.
     *
     *  For information about managing security groups, go to [Amazon Redshift Cluster Security Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    public suspend fun deleteClusterSecurityGroup(input: DeleteClusterSecurityGroupRequest): DeleteClusterSecurityGroupResponse

    /**
     * Deletes the specified manual snapshot. The snapshot must be in the `available` state, with no other users authorized to access the snapshot.
     *
     * Unlike automated snapshots, manual snapshots are retained even after you delete your cluster. Amazon Redshift does not delete your manual snapshots. You must delete manual snapshot explicitly to avoid getting charged. If other accounts are authorized to access the snapshot, you must revoke all of the authorizations before you can delete the snapshot.
     */
    public suspend fun deleteClusterSnapshot(input: DeleteClusterSnapshotRequest): DeleteClusterSnapshotResponse

    /**
     * Deletes the specified cluster subnet group.
     */
    public suspend fun deleteClusterSubnetGroup(input: DeleteClusterSubnetGroupRequest): DeleteClusterSubnetGroupResponse

    /**
     * Contains information about deleting a custom domain association for a cluster.
     */
    public suspend fun deleteCustomDomainAssociation(input: DeleteCustomDomainAssociationRequest): DeleteCustomDomainAssociationResponse

    /**
     * Deletes a Redshift-managed VPC endpoint.
     */
    public suspend fun deleteEndpointAccess(input: DeleteEndpointAccessRequest): DeleteEndpointAccessResponse

    /**
     * Deletes an Amazon Redshift event notification subscription.
     */
    public suspend fun deleteEventSubscription(input: DeleteEventSubscriptionRequest): DeleteEventSubscriptionResponse

    /**
     * Deletes the specified HSM client certificate.
     */
    public suspend fun deleteHsmClientCertificate(input: DeleteHsmClientCertificateRequest): DeleteHsmClientCertificateResponse

    /**
     * Deletes the specified Amazon Redshift HSM configuration.
     */
    public suspend fun deleteHsmConfiguration(input: DeleteHsmConfigurationRequest): DeleteHsmConfigurationResponse

    /**
     * Deletes a partner integration from a cluster. Data can still flow to the cluster until the integration is deleted at the partner's website.
     */
    public suspend fun deletePartner(input: DeletePartnerRequest): DeletePartnerResponse

    /**
     * Deletes an Amazon Redshift IAM Identity Center application.
     */
    public suspend fun deleteRedshiftIdcApplication(input: DeleteRedshiftIdcApplicationRequest): DeleteRedshiftIdcApplicationResponse

    /**
     * Deletes the resource policy for a specified resource.
     */
    public suspend fun deleteResourcePolicy(input: DeleteResourcePolicyRequest): DeleteResourcePolicyResponse

    /**
     * Deletes a scheduled action.
     */
    public suspend fun deleteScheduledAction(input: DeleteScheduledActionRequest): DeleteScheduledActionResponse

    /**
     * Deletes the specified snapshot copy grant.
     */
    public suspend fun deleteSnapshotCopyGrant(input: DeleteSnapshotCopyGrantRequest): DeleteSnapshotCopyGrantResponse

    /**
     * Deletes a snapshot schedule.
     */
    public suspend fun deleteSnapshotSchedule(input: DeleteSnapshotScheduleRequest): DeleteSnapshotScheduleResponse

    /**
     * Deletes tags from a resource. You must provide the ARN of the resource from which you want to delete the tag or tags.
     */
    public suspend fun deleteTags(input: DeleteTagsRequest): DeleteTagsResponse

    /**
     * Deletes a usage limit from a cluster.
     */
    public suspend fun deleteUsageLimit(input: DeleteUsageLimitRequest): DeleteUsageLimitResponse

    /**
     * Returns a list of attributes attached to an account
     */
    public suspend fun describeAccountAttributes(input: DescribeAccountAttributesRequest = DescribeAccountAttributesRequest { }): DescribeAccountAttributesResponse

    /**
     * Describes an authentication profile.
     */
    public suspend fun describeAuthenticationProfiles(input: DescribeAuthenticationProfilesRequest = DescribeAuthenticationProfilesRequest { }): DescribeAuthenticationProfilesResponse

    /**
     * Returns an array of `ClusterDbRevision` objects.
     */
    public suspend fun describeClusterDbRevisions(input: DescribeClusterDbRevisionsRequest = DescribeClusterDbRevisionsRequest { }): DescribeClusterDbRevisionsResponse

    /**
     * Returns a list of Amazon Redshift parameter groups, including parameter groups you created and the default parameter group. For each parameter group, the response includes the parameter group name, description, and parameter group family name. You can optionally specify a name to retrieve the description of a specific parameter group.
     *
     *  For more information about parameters and parameter groups, go to [Amazon Redshift Parameter Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html) in the *Amazon Redshift Cluster Management Guide*.
     *
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all parameter groups that match any combination of the specified keys and values. For example, if you have `owner` and `environment` for tag keys, and `admin` and `test` for tag values, all parameter groups that have any combination of those values are returned.
     *
     * If both tag keys and values are omitted from the request, parameter groups are returned regardless of whether they have tag keys or values associated with them.
     */
    public suspend fun describeClusterParameterGroups(input: DescribeClusterParameterGroupsRequest = DescribeClusterParameterGroupsRequest { }): DescribeClusterParameterGroupsResponse

    /**
     * Returns a detailed list of parameters contained within the specified Amazon Redshift parameter group. For each parameter the response includes information such as parameter name, description, data type, value, whether the parameter value is modifiable, and so on.
     *
     * You can specify *source* filter to retrieve parameters of only specific type. For example, to retrieve parameters that were modified by a user action such as from ModifyClusterParameterGroup, you can specify *source* equal to *user*.
     *
     *  For more information about parameters and parameter groups, go to [Amazon Redshift Parameter Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    public suspend fun describeClusterParameters(input: DescribeClusterParametersRequest): DescribeClusterParametersResponse

    /**
     * Returns information about Amazon Redshift security groups. If the name of a security group is specified, the response will contain only information about only that security group.
     *
     *  For information about managing security groups, go to [Amazon Redshift Cluster Security Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html) in the *Amazon Redshift Cluster Management Guide*.
     *
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all security groups that match any combination of the specified keys and values. For example, if you have `owner` and `environment` for tag keys, and `admin` and `test` for tag values, all security groups that have any combination of those values are returned.
     *
     * If both tag keys and values are omitted from the request, security groups are returned regardless of whether they have tag keys or values associated with them.
     */
    public suspend fun describeClusterSecurityGroups(input: DescribeClusterSecurityGroupsRequest = DescribeClusterSecurityGroupsRequest { }): DescribeClusterSecurityGroupsResponse

    /**
     * Returns one or more snapshot objects, which contain metadata about your cluster snapshots. By default, this operation returns information about all snapshots of all clusters that are owned by your Amazon Web Services account. No information is returned for snapshots owned by inactive Amazon Web Services accounts.
     *
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all snapshots that match any combination of the specified keys and values. For example, if you have `owner` and `environment` for tag keys, and `admin` and `test` for tag values, all snapshots that have any combination of those values are returned. Only snapshots that you own are returned in the response; shared snapshots are not returned with the tag key and tag value request parameters.
     *
     * If both tag keys and values are omitted from the request, snapshots are returned regardless of whether they have tag keys or values associated with them.
     */
    public suspend fun describeClusterSnapshots(input: DescribeClusterSnapshotsRequest = DescribeClusterSnapshotsRequest { }): DescribeClusterSnapshotsResponse

    /**
     * Returns one or more cluster subnet group objects, which contain metadata about your cluster subnet groups. By default, this operation returns information about all cluster subnet groups that are defined in your Amazon Web Services account.
     *
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all subnet groups that match any combination of the specified keys and values. For example, if you have `owner` and `environment` for tag keys, and `admin` and `test` for tag values, all subnet groups that have any combination of those values are returned.
     *
     * If both tag keys and values are omitted from the request, subnet groups are returned regardless of whether they have tag keys or values associated with them.
     */
    public suspend fun describeClusterSubnetGroups(input: DescribeClusterSubnetGroupsRequest = DescribeClusterSubnetGroupsRequest { }): DescribeClusterSubnetGroupsResponse

    /**
     * Returns a list of all the available maintenance tracks.
     */
    public suspend fun describeClusterTracks(input: DescribeClusterTracksRequest = DescribeClusterTracksRequest { }): DescribeClusterTracksResponse

    /**
     * Returns descriptions of the available Amazon Redshift cluster versions. You can call this operation even before creating any clusters to learn more about the Amazon Redshift versions. For more information about managing clusters, go to [Amazon Redshift Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    public suspend fun describeClusterVersions(input: DescribeClusterVersionsRequest = DescribeClusterVersionsRequest { }): DescribeClusterVersionsResponse

    /**
     * Returns properties of provisioned clusters including general cluster properties, cluster database properties, maintenance and backup properties, and security and access properties. This operation supports pagination. For more information about managing clusters, go to [Amazon Redshift Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html) in the *Amazon Redshift Cluster Management Guide*.
     *
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all clusters that match any combination of the specified keys and values. For example, if you have `owner` and `environment` for tag keys, and `admin` and `test` for tag values, all clusters that have any combination of those values are returned.
     *
     * If both tag keys and values are omitted from the request, clusters are returned regardless of whether they have tag keys or values associated with them.
     */
    public suspend fun describeClusters(input: DescribeClustersRequest = DescribeClustersRequest { }): DescribeClustersResponse

    /**
     * Contains information about custom domain associations for a cluster.
     */
    public suspend fun describeCustomDomainAssociations(input: DescribeCustomDomainAssociationsRequest = DescribeCustomDomainAssociationsRequest { }): DescribeCustomDomainAssociationsResponse

    /**
     * Shows the status of any inbound or outbound datashares available in the specified account.
     */
    public suspend fun describeDataShares(input: DescribeDataSharesRequest = DescribeDataSharesRequest { }): DescribeDataSharesResponse

    /**
     * Returns a list of datashares where the account identifier being called is a consumer account identifier.
     */
    public suspend fun describeDataSharesForConsumer(input: DescribeDataSharesForConsumerRequest = DescribeDataSharesForConsumerRequest { }): DescribeDataSharesForConsumerResponse

    /**
     * Returns a list of datashares when the account identifier being called is a producer account identifier.
     */
    public suspend fun describeDataSharesForProducer(input: DescribeDataSharesForProducerRequest = DescribeDataSharesForProducerRequest { }): DescribeDataSharesForProducerResponse

    /**
     * Returns a list of parameter settings for the specified parameter group family.
     *
     *  For more information about parameters and parameter groups, go to [Amazon Redshift Parameter Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    public suspend fun describeDefaultClusterParameters(input: DescribeDefaultClusterParametersRequest): DescribeDefaultClusterParametersResponse

    /**
     * Describes a Redshift-managed VPC endpoint.
     */
    public suspend fun describeEndpointAccess(input: DescribeEndpointAccessRequest = DescribeEndpointAccessRequest { }): DescribeEndpointAccessResponse

    /**
     * Describes an endpoint authorization.
     */
    public suspend fun describeEndpointAuthorization(input: DescribeEndpointAuthorizationRequest = DescribeEndpointAuthorizationRequest { }): DescribeEndpointAuthorizationResponse

    /**
     * Displays a list of event categories for all event source types, or for a specified source type. For a list of the event categories and source types, go to [Amazon Redshift Event Notifications](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-event-notifications.html).
     */
    public suspend fun describeEventCategories(input: DescribeEventCategoriesRequest = DescribeEventCategoriesRequest { }): DescribeEventCategoriesResponse

    /**
     * Lists descriptions of all the Amazon Redshift event notification subscriptions for a customer account. If you specify a subscription name, lists the description for that subscription.
     *
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all event notification subscriptions that match any combination of the specified keys and values. For example, if you have `owner` and `environment` for tag keys, and `admin` and `test` for tag values, all subscriptions that have any combination of those values are returned.
     *
     * If both tag keys and values are omitted from the request, subscriptions are returned regardless of whether they have tag keys or values associated with them.
     */
    public suspend fun describeEventSubscriptions(input: DescribeEventSubscriptionsRequest = DescribeEventSubscriptionsRequest { }): DescribeEventSubscriptionsResponse

    /**
     * Returns events related to clusters, security groups, snapshots, and parameter groups for the past 14 days. Events specific to a particular cluster, security group, snapshot or parameter group can be obtained by providing the name as a parameter. By default, the past hour of events are returned.
     */
    public suspend fun describeEvents(input: DescribeEventsRequest = DescribeEventsRequest { }): DescribeEventsResponse

    /**
     * Returns information about the specified HSM client certificate. If no certificate ID is specified, returns information about all the HSM certificates owned by your Amazon Web Services account.
     *
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all HSM client certificates that match any combination of the specified keys and values. For example, if you have `owner` and `environment` for tag keys, and `admin` and `test` for tag values, all HSM client certificates that have any combination of those values are returned.
     *
     * If both tag keys and values are omitted from the request, HSM client certificates are returned regardless of whether they have tag keys or values associated with them.
     */
    public suspend fun describeHsmClientCertificates(input: DescribeHsmClientCertificatesRequest = DescribeHsmClientCertificatesRequest { }): DescribeHsmClientCertificatesResponse

    /**
     * Returns information about the specified Amazon Redshift HSM configuration. If no configuration ID is specified, returns information about all the HSM configurations owned by your Amazon Web Services account.
     *
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all HSM connections that match any combination of the specified keys and values. For example, if you have `owner` and `environment` for tag keys, and `admin` and `test` for tag values, all HSM connections that have any combination of those values are returned.
     *
     * If both tag keys and values are omitted from the request, HSM connections are returned regardless of whether they have tag keys or values associated with them.
     */
    public suspend fun describeHsmConfigurations(input: DescribeHsmConfigurationsRequest = DescribeHsmConfigurationsRequest { }): DescribeHsmConfigurationsResponse

    /**
     * Returns a list of inbound integrations.
     */
    public suspend fun describeInboundIntegrations(input: DescribeInboundIntegrationsRequest = DescribeInboundIntegrationsRequest { }): DescribeInboundIntegrationsResponse

    /**
     * Describes whether information, such as queries and connection attempts, is being logged for the specified Amazon Redshift cluster.
     */
    public suspend fun describeLoggingStatus(input: DescribeLoggingStatusRequest): DescribeLoggingStatusResponse

    /**
     * Returns properties of possible node configurations such as node type, number of nodes, and disk usage for the specified action type.
     */
    public suspend fun describeNodeConfigurationOptions(input: DescribeNodeConfigurationOptionsRequest): DescribeNodeConfigurationOptionsResponse

    /**
     * Returns a list of orderable cluster options. Before you create a new cluster you can use this operation to find what options are available, such as the EC2 Availability Zones (AZ) in the specific Amazon Web Services Region that you can specify, and the node types you can request. The node types differ by available storage, memory, CPU and price. With the cost involved you might want to obtain a list of cluster options in the specific region and specify values when creating a cluster. For more information about managing clusters, go to [Amazon Redshift Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    public suspend fun describeOrderableClusterOptions(input: DescribeOrderableClusterOptionsRequest = DescribeOrderableClusterOptionsRequest { }): DescribeOrderableClusterOptionsResponse

    /**
     * Returns information about the partner integrations defined for a cluster.
     */
    public suspend fun describePartners(input: DescribePartnersRequest): DescribePartnersResponse

    /**
     * Lists the Amazon Redshift IAM Identity Center applications.
     */
    public suspend fun describeRedshiftIdcApplications(input: DescribeRedshiftIdcApplicationsRequest = DescribeRedshiftIdcApplicationsRequest { }): DescribeRedshiftIdcApplicationsResponse

    /**
     * Returns exchange status details and associated metadata for a reserved-node exchange. Statuses include such values as in progress and requested.
     */
    public suspend fun describeReservedNodeExchangeStatus(input: DescribeReservedNodeExchangeStatusRequest = DescribeReservedNodeExchangeStatusRequest { }): DescribeReservedNodeExchangeStatusResponse

    /**
     * Returns a list of the available reserved node offerings by Amazon Redshift with their descriptions including the node type, the fixed and recurring costs of reserving the node and duration the node will be reserved for you. These descriptions help you determine which reserve node offering you want to purchase. You then use the unique offering ID in you call to PurchaseReservedNodeOffering to reserve one or more nodes for your Amazon Redshift cluster.
     *
     *  For more information about reserved node offerings, go to [Purchasing Reserved Nodes](https://docs.aws.amazon.com/redshift/latest/mgmt/purchase-reserved-node-instance.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    public suspend fun describeReservedNodeOfferings(input: DescribeReservedNodeOfferingsRequest = DescribeReservedNodeOfferingsRequest { }): DescribeReservedNodeOfferingsResponse

    /**
     * Returns the descriptions of the reserved nodes.
     */
    public suspend fun describeReservedNodes(input: DescribeReservedNodesRequest = DescribeReservedNodesRequest { }): DescribeReservedNodesResponse

    /**
     * Returns information about the last resize operation for the specified cluster. If no resize operation has ever been initiated for the specified cluster, a `HTTP 404` error is returned. If a resize operation was initiated and completed, the status of the resize remains as `SUCCEEDED` until the next resize.
     *
     * A resize operation can be requested using ModifyCluster and specifying a different number or type of nodes for the cluster.
     */
    public suspend fun describeResize(input: DescribeResizeRequest): DescribeResizeResponse

    /**
     * Describes properties of scheduled actions.
     */
    public suspend fun describeScheduledActions(input: DescribeScheduledActionsRequest = DescribeScheduledActionsRequest { }): DescribeScheduledActionsResponse

    /**
     * Returns a list of snapshot copy grants owned by the Amazon Web Services account in the destination region.
     *
     *  For more information about managing snapshot copy grants, go to [Amazon Redshift Database Encryption](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    public suspend fun describeSnapshotCopyGrants(input: DescribeSnapshotCopyGrantsRequest = DescribeSnapshotCopyGrantsRequest { }): DescribeSnapshotCopyGrantsResponse

    /**
     * Returns a list of snapshot schedules.
     */
    public suspend fun describeSnapshotSchedules(input: DescribeSnapshotSchedulesRequest = DescribeSnapshotSchedulesRequest { }): DescribeSnapshotSchedulesResponse

    /**
     * Returns account level backups storage size and provisional storage.
     */
    public suspend fun describeStorage(input: DescribeStorageRequest = DescribeStorageRequest { }): DescribeStorageResponse

    /**
     * Lists the status of one or more table restore requests made using the RestoreTableFromClusterSnapshot API action. If you don't specify a value for the `TableRestoreRequestId` parameter, then `DescribeTableRestoreStatus` returns the status of all table restore requests ordered by the date and time of the request in ascending order. Otherwise `DescribeTableRestoreStatus` returns the status of the table specified by `TableRestoreRequestId`.
     */
    public suspend fun describeTableRestoreStatus(input: DescribeTableRestoreStatusRequest = DescribeTableRestoreStatusRequest { }): DescribeTableRestoreStatusResponse

    /**
     * Returns a list of tags. You can return tags from a specific resource by specifying an ARN, or you can return all tags for a given type of resource, such as clusters, snapshots, and so on.
     *
     * The following are limitations for `DescribeTags`:
     * + You cannot specify an ARN and a resource-type value together in the same request.
     * + You cannot use the `MaxRecords` and `Marker` parameters together with the ARN parameter.
     * + The `MaxRecords` parameter can be a range from 10 to 50 results to return in a request.
     *
     * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all resources that match any combination of the specified keys and values. For example, if you have `owner` and `environment` for tag keys, and `admin` and `test` for tag values, all resources that have any combination of those values are returned.
     *
     * If both tag keys and values are omitted from the request, resources are returned regardless of whether they have tag keys or values associated with them.
     */
    public suspend fun describeTags(input: DescribeTagsRequest = DescribeTagsRequest { }): DescribeTagsResponse

    /**
     * Shows usage limits on a cluster. Results are filtered based on the combination of input usage limit identifier, cluster identifier, and feature type parameters:
     * + If usage limit identifier, cluster identifier, and feature type are not provided, then all usage limit objects for the current account in the current region are returned.
     * + If usage limit identifier is provided, then the corresponding usage limit object is returned.
     * + If cluster identifier is provided, then all usage limit objects for the specified cluster are returned.
     * + If cluster identifier and feature type are provided, then all usage limit objects for the combination of cluster and feature are returned.
     */
    public suspend fun describeUsageLimits(input: DescribeUsageLimitsRequest = DescribeUsageLimitsRequest { }): DescribeUsageLimitsResponse

    /**
     * Stops logging information, such as queries and connection attempts, for the specified Amazon Redshift cluster.
     */
    public suspend fun disableLogging(input: DisableLoggingRequest): DisableLoggingResponse

    /**
     * Disables the automatic copying of snapshots from one region to another region for a specified cluster.
     *
     * If your cluster and its snapshots are encrypted using an encrypted symmetric key from Key Management Service, use DeleteSnapshotCopyGrant to delete the grant that grants Amazon Redshift permission to the key in the destination region.
     */
    public suspend fun disableSnapshotCopy(input: DisableSnapshotCopyRequest): DisableSnapshotCopyResponse

    /**
     * From a datashare consumer account, remove association for the specified datashare.
     */
    public suspend fun disassociateDataShareConsumer(input: DisassociateDataShareConsumerRequest): DisassociateDataShareConsumerResponse

    /**
     * Starts logging information, such as queries and connection attempts, for the specified Amazon Redshift cluster.
     */
    public suspend fun enableLogging(input: EnableLoggingRequest): EnableLoggingResponse

    /**
     * Enables the automatic copy of snapshots from one region to another region for a specified cluster.
     */
    public suspend fun enableSnapshotCopy(input: EnableSnapshotCopyRequest): EnableSnapshotCopyResponse

    /**
     * Fails over the primary compute unit of the specified Multi-AZ cluster to another Availability Zone.
     */
    public suspend fun failoverPrimaryCompute(input: FailoverPrimaryComputeRequest): FailoverPrimaryComputeResponse

    /**
     * Returns a database user name and temporary password with temporary authorization to log on to an Amazon Redshift database. The action returns the database user name prefixed with `IAM:` if `AutoCreate` is `False` or `IAMA:` if `AutoCreate` is `True`. You can optionally specify one or more database user groups that the user will join at log on. By default, the temporary credentials expire in 900 seconds. You can optionally specify a duration between 900 seconds (15 minutes) and 3600 seconds (60 minutes). For more information, see [Using IAM Authentication to Generate Database User Credentials](https://docs.aws.amazon.com/redshift/latest/mgmt/generating-user-credentials.html) in the Amazon Redshift Cluster Management Guide.
     *
     * The Identity and Access Management (IAM) user or role that runs GetClusterCredentials must have an IAM policy attached that allows access to all necessary actions and resources. For more information about permissions, see [Resource Policies for GetClusterCredentials](https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html#redshift-policy-resources.getclustercredentials-resources) in the Amazon Redshift Cluster Management Guide.
     *
     * If the `DbGroups` parameter is specified, the IAM policy must allow the `redshift:JoinGroup` action with access to the listed `dbgroups`.
     *
     * In addition, if the `AutoCreate` parameter is set to `True`, then the policy must include the `redshift:CreateClusterUser` permission.
     *
     * If the `DbName` parameter is specified, the IAM policy must allow access to the resource `dbname` for the specified database name.
     */
    public suspend fun getClusterCredentials(input: GetClusterCredentialsRequest): GetClusterCredentialsResponse

    /**
     * Returns a database user name and temporary password with temporary authorization to log in to an Amazon Redshift database. The database user is mapped 1:1 to the source Identity and Access Management (IAM) identity. For more information about IAM identities, see [IAM Identities (users, user groups, and roles)](https://docs.aws.amazon.com/IAM/latest/UserGuide/id.html) in the Amazon Web Services Identity and Access Management User Guide.
     *
     * The Identity and Access Management (IAM) identity that runs this operation must have an IAM policy attached that allows access to all necessary actions and resources. For more information about permissions, see [Using identity-based policies (IAM policies)](https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html) in the Amazon Redshift Cluster Management Guide.
     */
    public suspend fun getClusterCredentialsWithIam(input: GetClusterCredentialsWithIamRequest = GetClusterCredentialsWithIamRequest { }): GetClusterCredentialsWithIamResponse

    /**
     * Gets the configuration options for the reserved-node exchange. These options include information about the source reserved node and target reserved node offering. Details include the node type, the price, the node count, and the offering type.
     */
    public suspend fun getReservedNodeExchangeConfigurationOptions(input: GetReservedNodeExchangeConfigurationOptionsRequest): GetReservedNodeExchangeConfigurationOptionsResponse

    /**
     * Returns an array of DC2 ReservedNodeOfferings that matches the payment type, term, and usage price of the given DC1 reserved node.
     */
    public suspend fun getReservedNodeExchangeOfferings(input: GetReservedNodeExchangeOfferingsRequest): GetReservedNodeExchangeOfferingsResponse

    /**
     * Get the resource policy for a specified resource.
     */
    public suspend fun getResourcePolicy(input: GetResourcePolicyRequest): GetResourcePolicyResponse

    /**
     * List the Amazon Redshift Advisor recommendations for one or multiple Amazon Redshift clusters in an Amazon Web Services account.
     */
    public suspend fun listRecommendations(input: ListRecommendationsRequest = ListRecommendationsRequest { }): ListRecommendationsResponse

    /**
     * This operation is retired. Calling this operation does not change AQUA configuration. Amazon Redshift automatically determines whether to use AQUA (Advanced Query Accelerator).
     */
    public suspend fun modifyAquaConfiguration(input: ModifyAquaConfigurationRequest): ModifyAquaConfigurationResponse

    /**
     * Modifies an authentication profile.
     */
    public suspend fun modifyAuthenticationProfile(input: ModifyAuthenticationProfileRequest): ModifyAuthenticationProfileResponse

    /**
     * Modifies the settings for a cluster.
     *
     * You can also change node type and the number of nodes to scale up or down the cluster. When resizing a cluster, you must specify both the number of nodes and the node type even if one of the parameters does not change.
     *
     * You can add another security or parameter group, or change the admin user password. Resetting a cluster password or modifying the security groups associated with a cluster do not need a reboot. However, modifying a parameter group requires a reboot for parameters to take effect. For more information about managing clusters, go to [Amazon Redshift Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    public suspend fun modifyCluster(input: ModifyClusterRequest): ModifyClusterResponse

    /**
     * Modifies the database revision of a cluster. The database revision is a unique revision of the database running in a cluster.
     */
    public suspend fun modifyClusterDbRevision(input: ModifyClusterDbRevisionRequest): ModifyClusterDbRevisionResponse

    /**
     * Modifies the list of Identity and Access Management (IAM) roles that can be used by the cluster to access other Amazon Web Services services.
     *
     * The maximum number of IAM roles that you can associate is subject to a quota. For more information, go to [Quotas and limits](https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    public suspend fun modifyClusterIamRoles(input: ModifyClusterIamRolesRequest): ModifyClusterIamRolesResponse

    /**
     * Modifies the maintenance settings of a cluster.
     */
    public suspend fun modifyClusterMaintenance(input: ModifyClusterMaintenanceRequest): ModifyClusterMaintenanceResponse

    /**
     * Modifies the parameters of a parameter group. For the parameters parameter, it can't contain ASCII characters.
     *
     *  For more information about parameters and parameter groups, go to [Amazon Redshift Parameter Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    public suspend fun modifyClusterParameterGroup(input: ModifyClusterParameterGroupRequest): ModifyClusterParameterGroupResponse

    /**
     * Modifies the settings for a snapshot.
     *
     * This exanmple modifies the manual retention period setting for a cluster snapshot.
     */
    public suspend fun modifyClusterSnapshot(input: ModifyClusterSnapshotRequest): ModifyClusterSnapshotResponse

    /**
     * Modifies a snapshot schedule for a cluster.
     */
    public suspend fun modifyClusterSnapshotSchedule(input: ModifyClusterSnapshotScheduleRequest): ModifyClusterSnapshotScheduleResponse

    /**
     * Modifies a cluster subnet group to include the specified list of VPC subnets. The operation replaces the existing list of subnets with the new list of subnets.
     */
    public suspend fun modifyClusterSubnetGroup(input: ModifyClusterSubnetGroupRequest): ModifyClusterSubnetGroupResponse

    /**
     * Contains information for changing a custom domain association.
     */
    public suspend fun modifyCustomDomainAssociation(input: ModifyCustomDomainAssociationRequest): ModifyCustomDomainAssociationResponse

    /**
     * Modifies a Redshift-managed VPC endpoint.
     */
    public suspend fun modifyEndpointAccess(input: ModifyEndpointAccessRequest): ModifyEndpointAccessResponse

    /**
     * Modifies an existing Amazon Redshift event notification subscription.
     */
    public suspend fun modifyEventSubscription(input: ModifyEventSubscriptionRequest): ModifyEventSubscriptionResponse

    /**
     * Changes an existing Amazon Redshift IAM Identity Center application.
     */
    public suspend fun modifyRedshiftIdcApplication(input: ModifyRedshiftIdcApplicationRequest): ModifyRedshiftIdcApplicationResponse

    /**
     * Modifies a scheduled action.
     */
    public suspend fun modifyScheduledAction(input: ModifyScheduledActionRequest): ModifyScheduledActionResponse

    /**
     * Modifies the number of days to retain snapshots in the destination Amazon Web Services Region after they are copied from the source Amazon Web Services Region. By default, this operation only changes the retention period of copied automated snapshots. The retention periods for both new and existing copied automated snapshots are updated with the new retention period. You can set the manual option to change only the retention periods of copied manual snapshots. If you set this option, only newly copied manual snapshots have the new retention period.
     */
    public suspend fun modifySnapshotCopyRetentionPeriod(input: ModifySnapshotCopyRetentionPeriodRequest): ModifySnapshotCopyRetentionPeriodResponse

    /**
     * Modifies a snapshot schedule. Any schedule associated with a cluster is modified asynchronously.
     */
    public suspend fun modifySnapshotSchedule(input: ModifySnapshotScheduleRequest): ModifySnapshotScheduleResponse

    /**
     * Modifies a usage limit in a cluster. You can't modify the feature type or period of a usage limit.
     */
    public suspend fun modifyUsageLimit(input: ModifyUsageLimitRequest): ModifyUsageLimitResponse

    /**
     * Pauses a cluster.
     */
    public suspend fun pauseCluster(input: PauseClusterRequest): PauseClusterResponse

    /**
     * Allows you to purchase reserved nodes. Amazon Redshift offers a predefined set of reserved node offerings. You can purchase one or more of the offerings. You can call the DescribeReservedNodeOfferings API to obtain the available reserved node offerings. You can call this API by providing a specific reserved node offering and the number of nodes you want to reserve.
     *
     *  For more information about reserved node offerings, go to [Purchasing Reserved Nodes](https://docs.aws.amazon.com/redshift/latest/mgmt/purchase-reserved-node-instance.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    public suspend fun purchaseReservedNodeOffering(input: PurchaseReservedNodeOfferingRequest): PurchaseReservedNodeOfferingResponse

    /**
     * Updates the resource policy for a specified resource.
     */
    public suspend fun putResourcePolicy(input: PutResourcePolicyRequest): PutResourcePolicyResponse

    /**
     * Reboots a cluster. This action is taken as soon as possible. It results in a momentary outage to the cluster, during which the cluster status is set to `rebooting`. A cluster event is created when the reboot is completed. Any pending cluster modifications (see ModifyCluster) are applied at this reboot. For more information about managing clusters, go to [Amazon Redshift Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    public suspend fun rebootCluster(input: RebootClusterRequest): RebootClusterResponse

    /**
     * From a datashare consumer account, rejects the specified datashare.
     */
    public suspend fun rejectDataShare(input: RejectDataShareRequest): RejectDataShareResponse

    /**
     * Sets one or more parameters of the specified parameter group to their default values and sets the source values of the parameters to "engine-default". To reset the entire parameter group specify the *ResetAllParameters* parameter. For parameter changes to take effect you must reboot any associated clusters.
     */
    public suspend fun resetClusterParameterGroup(input: ResetClusterParameterGroupRequest): ResetClusterParameterGroupResponse

    /**
     * Changes the size of the cluster. You can change the cluster's type, or change the number or type of nodes. The default behavior is to use the elastic resize method. With an elastic resize, your cluster is available for read and write operations more quickly than with the classic resize method.
     *
     * Elastic resize operations have the following restrictions:
     * + You can only resize clusters of the following types:
     *    + dc2.large
     *    + dc2.8xlarge
     *    + ra3.xlplus
     *    + ra3.4xlarge
     *    + ra3.16xlarge
     * + The type of nodes that you add must match the node type for the cluster.
     */
    public suspend fun resizeCluster(input: ResizeClusterRequest): ResizeClusterResponse

    /**
     * Creates a new cluster from a snapshot. By default, Amazon Redshift creates the resulting cluster with the same configuration as the original cluster from which the snapshot was created, except that the new cluster is created with the default cluster security and parameter groups. After Amazon Redshift creates the cluster, you can use the ModifyCluster API to associate a different security group and different parameter group with the restored cluster. If you are using a DS node type, you can also choose to change to another DS node type of the same size during restore.
     *
     * If you restore a cluster into a VPC, you must provide a cluster subnet group where you want the cluster restored.
     *
     *  For more information about working with snapshots, go to [Amazon Redshift Snapshots](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    public suspend fun restoreFromClusterSnapshot(input: RestoreFromClusterSnapshotRequest): RestoreFromClusterSnapshotResponse

    /**
     * Creates a new table from a table in an Amazon Redshift cluster snapshot. You must create the new table within the Amazon Redshift cluster that the snapshot was taken from.
     *
     * You cannot use `RestoreTableFromClusterSnapshot` to restore a table with the same name as an existing table in an Amazon Redshift cluster. That is, you cannot overwrite an existing table in a cluster with a restored table. If you want to replace your original table with a new, restored table, then rename or drop your original table before you call `RestoreTableFromClusterSnapshot`. When you have renamed your original table, then you can pass the original name of the table as the `NewTableName` parameter value in the call to `RestoreTableFromClusterSnapshot`. This way, you can replace the original table with the table created from the snapshot.
     *
     * You can't use this operation to restore tables with [interleaved sort keys](https://docs.aws.amazon.com/redshift/latest/dg/t_Sorting_data.html#t_Sorting_data-interleaved).
     */
    public suspend fun restoreTableFromClusterSnapshot(input: RestoreTableFromClusterSnapshotRequest): RestoreTableFromClusterSnapshotResponse

    /**
     * Resumes a paused cluster.
     */
    public suspend fun resumeCluster(input: ResumeClusterRequest): ResumeClusterResponse

    /**
     * Revokes an ingress rule in an Amazon Redshift security group for a previously authorized IP range or Amazon EC2 security group. To add an ingress rule, see AuthorizeClusterSecurityGroupIngress. For information about managing security groups, go to [Amazon Redshift Cluster Security Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    public suspend fun revokeClusterSecurityGroupIngress(input: RevokeClusterSecurityGroupIngressRequest): RevokeClusterSecurityGroupIngressResponse

    /**
     * Revokes access to a cluster.
     */
    public suspend fun revokeEndpointAccess(input: RevokeEndpointAccessRequest = RevokeEndpointAccessRequest { }): RevokeEndpointAccessResponse

    /**
     * Removes the ability of the specified Amazon Web Services account to restore the specified snapshot. If the account is currently restoring the snapshot, the restore will run to completion.
     *
     *  For more information about working with snapshots, go to [Amazon Redshift Snapshots](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    public suspend fun revokeSnapshotAccess(input: RevokeSnapshotAccessRequest): RevokeSnapshotAccessResponse

    /**
     * Rotates the encryption keys for a cluster.
     */
    public suspend fun rotateEncryptionKey(input: RotateEncryptionKeyRequest): RotateEncryptionKeyResponse

    /**
     * Updates the status of a partner integration.
     */
    public suspend fun updatePartnerStatus(input: UpdatePartnerStatusRequest): UpdatePartnerStatusResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun RedshiftClient.withConfig(block: RedshiftClient.Config.Builder.() -> Unit): RedshiftClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultRedshiftClient(newConfig)
}

/**
 * Exchanges a DC1 Reserved Node for a DC2 Reserved Node with no changes to the configuration (term, payment type, or number of nodes) and no additional costs.
 */
public suspend inline fun RedshiftClient.acceptReservedNodeExchange(crossinline block: AcceptReservedNodeExchangeRequest.Builder.() -> Unit): AcceptReservedNodeExchangeResponse = acceptReservedNodeExchange(AcceptReservedNodeExchangeRequest.Builder().apply(block).build())

/**
 * Adds a partner integration to a cluster. This operation authorizes a partner to push status updates for the specified database. To complete the integration, you also set up the integration on the partner website.
 */
public suspend inline fun RedshiftClient.addPartner(crossinline block: AddPartnerRequest.Builder.() -> Unit): AddPartnerResponse = addPartner(AddPartnerRequest.Builder().apply(block).build())

/**
 * From a datashare consumer account, associates a datashare with the account (AssociateEntireAccount) or the specified namespace (ConsumerArn). If you make this association, the consumer can consume the datashare.
 */
public suspend inline fun RedshiftClient.associateDataShareConsumer(crossinline block: AssociateDataShareConsumerRequest.Builder.() -> Unit): AssociateDataShareConsumerResponse = associateDataShareConsumer(AssociateDataShareConsumerRequest.Builder().apply(block).build())

/**
 * Adds an inbound (ingress) rule to an Amazon Redshift security group. Depending on whether the application accessing your cluster is running on the Internet or an Amazon EC2 instance, you can authorize inbound access to either a Classless Interdomain Routing (CIDR)/Internet Protocol (IP) range or to an Amazon EC2 security group. You can add as many as 20 ingress rules to an Amazon Redshift security group.
 *
 * If you authorize access to an Amazon EC2 security group, specify *EC2SecurityGroupName* and *EC2SecurityGroupOwnerId*. The Amazon EC2 security group and Amazon Redshift cluster must be in the same Amazon Web Services Region.
 *
 * If you authorize access to a CIDR/IP address range, specify *CIDRIP*. For an overview of CIDR blocks, see the Wikipedia article on [Classless Inter-Domain Routing](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
 *
 * You must also associate the security group with a cluster so that clients running on these IP addresses or the EC2 instance are authorized to connect to the cluster. For information about managing security groups, go to [Working with Security Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html) in the *Amazon Redshift Cluster Management Guide*.
 */
public suspend inline fun RedshiftClient.authorizeClusterSecurityGroupIngress(crossinline block: AuthorizeClusterSecurityGroupIngressRequest.Builder.() -> Unit): AuthorizeClusterSecurityGroupIngressResponse = authorizeClusterSecurityGroupIngress(AuthorizeClusterSecurityGroupIngressRequest.Builder().apply(block).build())

/**
 * From a data producer account, authorizes the sharing of a datashare with one or more consumer accounts or managing entities. To authorize a datashare for a data consumer, the producer account must have the correct access permissions.
 */
public suspend inline fun RedshiftClient.authorizeDataShare(crossinline block: AuthorizeDataShareRequest.Builder.() -> Unit): AuthorizeDataShareResponse = authorizeDataShare(AuthorizeDataShareRequest.Builder().apply(block).build())

/**
 * Grants access to a cluster.
 */
public suspend inline fun RedshiftClient.authorizeEndpointAccess(crossinline block: AuthorizeEndpointAccessRequest.Builder.() -> Unit): AuthorizeEndpointAccessResponse = authorizeEndpointAccess(AuthorizeEndpointAccessRequest.Builder().apply(block).build())

/**
 * Authorizes the specified Amazon Web Services account to restore the specified snapshot.
 *
 *  For more information about working with snapshots, go to [Amazon Redshift Snapshots](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html) in the *Amazon Redshift Cluster Management Guide*.
 */
public suspend inline fun RedshiftClient.authorizeSnapshotAccess(crossinline block: AuthorizeSnapshotAccessRequest.Builder.() -> Unit): AuthorizeSnapshotAccessResponse = authorizeSnapshotAccess(AuthorizeSnapshotAccessRequest.Builder().apply(block).build())

/**
 * Deletes a set of cluster snapshots.
 */
public suspend inline fun RedshiftClient.batchDeleteClusterSnapshots(crossinline block: BatchDeleteClusterSnapshotsRequest.Builder.() -> Unit): BatchDeleteClusterSnapshotsResponse = batchDeleteClusterSnapshots(BatchDeleteClusterSnapshotsRequest.Builder().apply(block).build())

/**
 * Modifies the settings for a set of cluster snapshots.
 */
public suspend inline fun RedshiftClient.batchModifyClusterSnapshots(crossinline block: BatchModifyClusterSnapshotsRequest.Builder.() -> Unit): BatchModifyClusterSnapshotsResponse = batchModifyClusterSnapshots(BatchModifyClusterSnapshotsRequest.Builder().apply(block).build())

/**
 * Cancels a resize operation for a cluster.
 */
public suspend inline fun RedshiftClient.cancelResize(crossinline block: CancelResizeRequest.Builder.() -> Unit): CancelResizeResponse = cancelResize(CancelResizeRequest.Builder().apply(block).build())

/**
 * Copies the specified automated cluster snapshot to a new manual cluster snapshot. The source must be an automated snapshot and it must be in the available state.
 *
 * When you delete a cluster, Amazon Redshift deletes any automated snapshots of the cluster. Also, when the retention period of the snapshot expires, Amazon Redshift automatically deletes it. If you want to keep an automated snapshot for a longer period, you can make a manual copy of the snapshot. Manual snapshots are retained until you delete them.
 *
 *  For more information about working with snapshots, go to [Amazon Redshift Snapshots](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html) in the *Amazon Redshift Cluster Management Guide*.
 */
public suspend inline fun RedshiftClient.copyClusterSnapshot(crossinline block: CopyClusterSnapshotRequest.Builder.() -> Unit): CopyClusterSnapshotResponse = copyClusterSnapshot(CopyClusterSnapshotRequest.Builder().apply(block).build())

/**
 * Creates an authentication profile with the specified parameters.
 */
public suspend inline fun RedshiftClient.createAuthenticationProfile(crossinline block: CreateAuthenticationProfileRequest.Builder.() -> Unit): CreateAuthenticationProfileResponse = createAuthenticationProfile(CreateAuthenticationProfileRequest.Builder().apply(block).build())

/**
 * Creates a new cluster with the specified parameters.
 *
 * To create a cluster in Virtual Private Cloud (VPC), you must provide a cluster subnet group name. The cluster subnet group identifies the subnets of your VPC that Amazon Redshift uses when creating the cluster. For more information about managing clusters, go to [Amazon Redshift Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html) in the *Amazon Redshift Cluster Management Guide*.
 */
public suspend inline fun RedshiftClient.createCluster(crossinline block: CreateClusterRequest.Builder.() -> Unit): CreateClusterResponse = createCluster(CreateClusterRequest.Builder().apply(block).build())

/**
 * Creates an Amazon Redshift parameter group.
 *
 * Creating parameter groups is independent of creating clusters. You can associate a cluster with a parameter group when you create the cluster. You can also associate an existing cluster with a parameter group after the cluster is created by using ModifyCluster.
 *
 * Parameters in the parameter group define specific behavior that applies to the databases you create on the cluster. For more information about parameters and parameter groups, go to [Amazon Redshift Parameter Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html) in the *Amazon Redshift Cluster Management Guide*.
 */
public suspend inline fun RedshiftClient.createClusterParameterGroup(crossinline block: CreateClusterParameterGroupRequest.Builder.() -> Unit): CreateClusterParameterGroupResponse = createClusterParameterGroup(CreateClusterParameterGroupRequest.Builder().apply(block).build())

/**
 * Creates a new Amazon Redshift security group. You use security groups to control access to non-VPC clusters.
 *
 *  For information about managing security groups, go to [Amazon Redshift Cluster Security Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html) in the *Amazon Redshift Cluster Management Guide*.
 */
public suspend inline fun RedshiftClient.createClusterSecurityGroup(crossinline block: CreateClusterSecurityGroupRequest.Builder.() -> Unit): CreateClusterSecurityGroupResponse = createClusterSecurityGroup(CreateClusterSecurityGroupRequest.Builder().apply(block).build())

/**
 * Creates a manual snapshot of the specified cluster. The cluster must be in the `available` state.
 *
 *  For more information about working with snapshots, go to [Amazon Redshift Snapshots](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html) in the *Amazon Redshift Cluster Management Guide*.
 */
public suspend inline fun RedshiftClient.createClusterSnapshot(crossinline block: CreateClusterSnapshotRequest.Builder.() -> Unit): CreateClusterSnapshotResponse = createClusterSnapshot(CreateClusterSnapshotRequest.Builder().apply(block).build())

/**
 * Creates a new Amazon Redshift subnet group. You must provide a list of one or more subnets in your existing Amazon Virtual Private Cloud (Amazon VPC) when creating Amazon Redshift subnet group.
 *
 *  For information about subnet groups, go to [Amazon Redshift Cluster Subnet Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-cluster-subnet-groups.html) in the *Amazon Redshift Cluster Management Guide*.
 */
public suspend inline fun RedshiftClient.createClusterSubnetGroup(crossinline block: CreateClusterSubnetGroupRequest.Builder.() -> Unit): CreateClusterSubnetGroupResponse = createClusterSubnetGroup(CreateClusterSubnetGroupRequest.Builder().apply(block).build())

/**
 * Used to create a custom domain name for a cluster. Properties include the custom domain name, the cluster the custom domain is associated with, and the certificate Amazon Resource Name (ARN).
 */
public suspend inline fun RedshiftClient.createCustomDomainAssociation(crossinline block: CreateCustomDomainAssociationRequest.Builder.() -> Unit): CreateCustomDomainAssociationResponse = createCustomDomainAssociation(CreateCustomDomainAssociationRequest.Builder().apply(block).build())

/**
 * Creates a Redshift-managed VPC endpoint.
 */
public suspend inline fun RedshiftClient.createEndpointAccess(crossinline block: CreateEndpointAccessRequest.Builder.() -> Unit): CreateEndpointAccessResponse = createEndpointAccess(CreateEndpointAccessRequest.Builder().apply(block).build())

/**
 * Creates an Amazon Redshift event notification subscription. This action requires an ARN (Amazon Resource Name) of an Amazon SNS topic created by either the Amazon Redshift console, the Amazon SNS console, or the Amazon SNS API. To obtain an ARN with Amazon SNS, you must create a topic in Amazon SNS and subscribe to the topic. The ARN is displayed in the SNS console.
 *
 * You can specify the source type, and lists of Amazon Redshift source IDs, event categories, and event severities. Notifications will be sent for all events you want that match those criteria. For example, you can specify source type = cluster, source ID = my-cluster-1 and mycluster2, event categories = Availability, Backup, and severity = ERROR. The subscription will only send notifications for those ERROR events in the Availability and Backup categories for the specified clusters.
 *
 * If you specify both the source type and source IDs, such as source type = cluster and source identifier = my-cluster-1, notifications will be sent for all the cluster events for my-cluster-1. If you specify a source type but do not specify a source identifier, you will receive notice of the events for the objects of that type in your Amazon Web Services account. If you do not specify either the SourceType nor the SourceIdentifier, you will be notified of events generated from all Amazon Redshift sources belonging to your Amazon Web Services account. You must specify a source type if you specify a source ID.
 */
public suspend inline fun RedshiftClient.createEventSubscription(crossinline block: CreateEventSubscriptionRequest.Builder.() -> Unit): CreateEventSubscriptionResponse = createEventSubscription(CreateEventSubscriptionRequest.Builder().apply(block).build())

/**
 * Creates an HSM client certificate that an Amazon Redshift cluster will use to connect to the client's HSM in order to store and retrieve the keys used to encrypt the cluster databases.
 *
 * The command returns a public key, which you must store in the HSM. In addition to creating the HSM certificate, you must create an Amazon Redshift HSM configuration that provides a cluster the information needed to store and use encryption keys in the HSM. For more information, go to [Hardware Security Modules](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html#working-with-HSM) in the *Amazon Redshift Cluster Management Guide*.
 */
public suspend inline fun RedshiftClient.createHsmClientCertificate(crossinline block: CreateHsmClientCertificateRequest.Builder.() -> Unit): CreateHsmClientCertificateResponse = createHsmClientCertificate(CreateHsmClientCertificateRequest.Builder().apply(block).build())

/**
 * Creates an HSM configuration that contains the information required by an Amazon Redshift cluster to store and use database encryption keys in a Hardware Security Module (HSM). After creating the HSM configuration, you can specify it as a parameter when creating a cluster. The cluster will then store its encryption keys in the HSM.
 *
 * In addition to creating an HSM configuration, you must also create an HSM client certificate. For more information, go to [Hardware Security Modules](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-HSM.html) in the Amazon Redshift Cluster Management Guide.
 */
public suspend inline fun RedshiftClient.createHsmConfiguration(crossinline block: CreateHsmConfigurationRequest.Builder.() -> Unit): CreateHsmConfigurationResponse = createHsmConfiguration(CreateHsmConfigurationRequest.Builder().apply(block).build())

/**
 * Creates an Amazon Redshift application for use with IAM Identity Center.
 */
public suspend inline fun RedshiftClient.createRedshiftIdcApplication(crossinline block: CreateRedshiftIdcApplicationRequest.Builder.() -> Unit): CreateRedshiftIdcApplicationResponse = createRedshiftIdcApplication(CreateRedshiftIdcApplicationRequest.Builder().apply(block).build())

/**
 * Creates a scheduled action. A scheduled action contains a schedule and an Amazon Redshift API action. For example, you can create a schedule of when to run the `ResizeCluster` API operation.
 */
public suspend inline fun RedshiftClient.createScheduledAction(crossinline block: CreateScheduledActionRequest.Builder.() -> Unit): CreateScheduledActionResponse = createScheduledAction(CreateScheduledActionRequest.Builder().apply(block).build())

/**
 * Creates a snapshot copy grant that permits Amazon Redshift to use an encrypted symmetric key from Key Management Service (KMS) to encrypt copied snapshots in a destination region.
 *
 *  For more information about managing snapshot copy grants, go to [Amazon Redshift Database Encryption](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html) in the *Amazon Redshift Cluster Management Guide*.
 */
public suspend inline fun RedshiftClient.createSnapshotCopyGrant(crossinline block: CreateSnapshotCopyGrantRequest.Builder.() -> Unit): CreateSnapshotCopyGrantResponse = createSnapshotCopyGrant(CreateSnapshotCopyGrantRequest.Builder().apply(block).build())

/**
 * Create a snapshot schedule that can be associated to a cluster and which overrides the default system backup schedule.
 */
public suspend inline fun RedshiftClient.createSnapshotSchedule(crossinline block: CreateSnapshotScheduleRequest.Builder.() -> Unit): CreateSnapshotScheduleResponse = createSnapshotSchedule(CreateSnapshotScheduleRequest.Builder().apply(block).build())

/**
 * Adds tags to a cluster.
 *
 * A resource can have up to 50 tags. If you try to create more than 50 tags for a resource, you will receive an error and the attempt will fail.
 *
 * If you specify a key that already exists for the resource, the value for that key will be updated with the new value.
 */
public suspend inline fun RedshiftClient.createTags(crossinline block: CreateTagsRequest.Builder.() -> Unit): CreateTagsResponse = createTags(CreateTagsRequest.Builder().apply(block).build())

/**
 * Creates a usage limit for a specified Amazon Redshift feature on a cluster. The usage limit is identified by the returned usage limit identifier.
 */
public suspend inline fun RedshiftClient.createUsageLimit(crossinline block: CreateUsageLimitRequest.Builder.() -> Unit): CreateUsageLimitResponse = createUsageLimit(CreateUsageLimitRequest.Builder().apply(block).build())

/**
 * From a datashare producer account, removes authorization from the specified datashare.
 */
public suspend inline fun RedshiftClient.deauthorizeDataShare(crossinline block: DeauthorizeDataShareRequest.Builder.() -> Unit): DeauthorizeDataShareResponse = deauthorizeDataShare(DeauthorizeDataShareRequest.Builder().apply(block).build())

/**
 * Deletes an authentication profile.
 */
public suspend inline fun RedshiftClient.deleteAuthenticationProfile(crossinline block: DeleteAuthenticationProfileRequest.Builder.() -> Unit): DeleteAuthenticationProfileResponse = deleteAuthenticationProfile(DeleteAuthenticationProfileRequest.Builder().apply(block).build())

/**
 * Deletes a previously provisioned cluster without its final snapshot being created. A successful response from the web service indicates that the request was received correctly. Use DescribeClusters to monitor the status of the deletion. The delete operation cannot be canceled or reverted once submitted. For more information about managing clusters, go to [Amazon Redshift Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html) in the *Amazon Redshift Cluster Management Guide*.
 *
 * If you want to shut down the cluster and retain it for future use, set *SkipFinalClusterSnapshot* to `false` and specify a name for *FinalClusterSnapshotIdentifier*. You can later restore this snapshot to resume using the cluster. If a final cluster snapshot is requested, the status of the cluster will be "final-snapshot" while the snapshot is being taken, then it's "deleting" once Amazon Redshift begins deleting the cluster.
 *
 *  For more information about managing clusters, go to [Amazon Redshift Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html) in the *Amazon Redshift Cluster Management Guide*.
 */
public suspend inline fun RedshiftClient.deleteCluster(crossinline block: DeleteClusterRequest.Builder.() -> Unit): DeleteClusterResponse = deleteCluster(DeleteClusterRequest.Builder().apply(block).build())

/**
 * Deletes a specified Amazon Redshift parameter group.
 *
 * You cannot delete a parameter group if it is associated with a cluster.
 */
public suspend inline fun RedshiftClient.deleteClusterParameterGroup(crossinline block: DeleteClusterParameterGroupRequest.Builder.() -> Unit): DeleteClusterParameterGroupResponse = deleteClusterParameterGroup(DeleteClusterParameterGroupRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon Redshift security group.
 *
 * You cannot delete a security group that is associated with any clusters. You cannot delete the default security group.
 *
 *  For information about managing security groups, go to [Amazon Redshift Cluster Security Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html) in the *Amazon Redshift Cluster Management Guide*.
 */
public suspend inline fun RedshiftClient.deleteClusterSecurityGroup(crossinline block: DeleteClusterSecurityGroupRequest.Builder.() -> Unit): DeleteClusterSecurityGroupResponse = deleteClusterSecurityGroup(DeleteClusterSecurityGroupRequest.Builder().apply(block).build())

/**
 * Deletes the specified manual snapshot. The snapshot must be in the `available` state, with no other users authorized to access the snapshot.
 *
 * Unlike automated snapshots, manual snapshots are retained even after you delete your cluster. Amazon Redshift does not delete your manual snapshots. You must delete manual snapshot explicitly to avoid getting charged. If other accounts are authorized to access the snapshot, you must revoke all of the authorizations before you can delete the snapshot.
 */
public suspend inline fun RedshiftClient.deleteClusterSnapshot(crossinline block: DeleteClusterSnapshotRequest.Builder.() -> Unit): DeleteClusterSnapshotResponse = deleteClusterSnapshot(DeleteClusterSnapshotRequest.Builder().apply(block).build())

/**
 * Deletes the specified cluster subnet group.
 */
public suspend inline fun RedshiftClient.deleteClusterSubnetGroup(crossinline block: DeleteClusterSubnetGroupRequest.Builder.() -> Unit): DeleteClusterSubnetGroupResponse = deleteClusterSubnetGroup(DeleteClusterSubnetGroupRequest.Builder().apply(block).build())

/**
 * Contains information about deleting a custom domain association for a cluster.
 */
public suspend inline fun RedshiftClient.deleteCustomDomainAssociation(crossinline block: DeleteCustomDomainAssociationRequest.Builder.() -> Unit): DeleteCustomDomainAssociationResponse = deleteCustomDomainAssociation(DeleteCustomDomainAssociationRequest.Builder().apply(block).build())

/**
 * Deletes a Redshift-managed VPC endpoint.
 */
public suspend inline fun RedshiftClient.deleteEndpointAccess(crossinline block: DeleteEndpointAccessRequest.Builder.() -> Unit): DeleteEndpointAccessResponse = deleteEndpointAccess(DeleteEndpointAccessRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon Redshift event notification subscription.
 */
public suspend inline fun RedshiftClient.deleteEventSubscription(crossinline block: DeleteEventSubscriptionRequest.Builder.() -> Unit): DeleteEventSubscriptionResponse = deleteEventSubscription(DeleteEventSubscriptionRequest.Builder().apply(block).build())

/**
 * Deletes the specified HSM client certificate.
 */
public suspend inline fun RedshiftClient.deleteHsmClientCertificate(crossinline block: DeleteHsmClientCertificateRequest.Builder.() -> Unit): DeleteHsmClientCertificateResponse = deleteHsmClientCertificate(DeleteHsmClientCertificateRequest.Builder().apply(block).build())

/**
 * Deletes the specified Amazon Redshift HSM configuration.
 */
public suspend inline fun RedshiftClient.deleteHsmConfiguration(crossinline block: DeleteHsmConfigurationRequest.Builder.() -> Unit): DeleteHsmConfigurationResponse = deleteHsmConfiguration(DeleteHsmConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes a partner integration from a cluster. Data can still flow to the cluster until the integration is deleted at the partner's website.
 */
public suspend inline fun RedshiftClient.deletePartner(crossinline block: DeletePartnerRequest.Builder.() -> Unit): DeletePartnerResponse = deletePartner(DeletePartnerRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon Redshift IAM Identity Center application.
 */
public suspend inline fun RedshiftClient.deleteRedshiftIdcApplication(crossinline block: DeleteRedshiftIdcApplicationRequest.Builder.() -> Unit): DeleteRedshiftIdcApplicationResponse = deleteRedshiftIdcApplication(DeleteRedshiftIdcApplicationRequest.Builder().apply(block).build())

/**
 * Deletes the resource policy for a specified resource.
 */
public suspend inline fun RedshiftClient.deleteResourcePolicy(crossinline block: DeleteResourcePolicyRequest.Builder.() -> Unit): DeleteResourcePolicyResponse = deleteResourcePolicy(DeleteResourcePolicyRequest.Builder().apply(block).build())

/**
 * Deletes a scheduled action.
 */
public suspend inline fun RedshiftClient.deleteScheduledAction(crossinline block: DeleteScheduledActionRequest.Builder.() -> Unit): DeleteScheduledActionResponse = deleteScheduledAction(DeleteScheduledActionRequest.Builder().apply(block).build())

/**
 * Deletes the specified snapshot copy grant.
 */
public suspend inline fun RedshiftClient.deleteSnapshotCopyGrant(crossinline block: DeleteSnapshotCopyGrantRequest.Builder.() -> Unit): DeleteSnapshotCopyGrantResponse = deleteSnapshotCopyGrant(DeleteSnapshotCopyGrantRequest.Builder().apply(block).build())

/**
 * Deletes a snapshot schedule.
 */
public suspend inline fun RedshiftClient.deleteSnapshotSchedule(crossinline block: DeleteSnapshotScheduleRequest.Builder.() -> Unit): DeleteSnapshotScheduleResponse = deleteSnapshotSchedule(DeleteSnapshotScheduleRequest.Builder().apply(block).build())

/**
 * Deletes tags from a resource. You must provide the ARN of the resource from which you want to delete the tag or tags.
 */
public suspend inline fun RedshiftClient.deleteTags(crossinline block: DeleteTagsRequest.Builder.() -> Unit): DeleteTagsResponse = deleteTags(DeleteTagsRequest.Builder().apply(block).build())

/**
 * Deletes a usage limit from a cluster.
 */
public suspend inline fun RedshiftClient.deleteUsageLimit(crossinline block: DeleteUsageLimitRequest.Builder.() -> Unit): DeleteUsageLimitResponse = deleteUsageLimit(DeleteUsageLimitRequest.Builder().apply(block).build())

/**
 * Returns a list of attributes attached to an account
 */
public suspend inline fun RedshiftClient.describeAccountAttributes(crossinline block: DescribeAccountAttributesRequest.Builder.() -> Unit): DescribeAccountAttributesResponse = describeAccountAttributes(DescribeAccountAttributesRequest.Builder().apply(block).build())

/**
 * Describes an authentication profile.
 */
public suspend inline fun RedshiftClient.describeAuthenticationProfiles(crossinline block: DescribeAuthenticationProfilesRequest.Builder.() -> Unit): DescribeAuthenticationProfilesResponse = describeAuthenticationProfiles(DescribeAuthenticationProfilesRequest.Builder().apply(block).build())

/**
 * Returns an array of `ClusterDbRevision` objects.
 */
public suspend inline fun RedshiftClient.describeClusterDbRevisions(crossinline block: DescribeClusterDbRevisionsRequest.Builder.() -> Unit): DescribeClusterDbRevisionsResponse = describeClusterDbRevisions(DescribeClusterDbRevisionsRequest.Builder().apply(block).build())

/**
 * Returns a list of Amazon Redshift parameter groups, including parameter groups you created and the default parameter group. For each parameter group, the response includes the parameter group name, description, and parameter group family name. You can optionally specify a name to retrieve the description of a specific parameter group.
 *
 *  For more information about parameters and parameter groups, go to [Amazon Redshift Parameter Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html) in the *Amazon Redshift Cluster Management Guide*.
 *
 * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all parameter groups that match any combination of the specified keys and values. For example, if you have `owner` and `environment` for tag keys, and `admin` and `test` for tag values, all parameter groups that have any combination of those values are returned.
 *
 * If both tag keys and values are omitted from the request, parameter groups are returned regardless of whether they have tag keys or values associated with them.
 */
public suspend inline fun RedshiftClient.describeClusterParameterGroups(crossinline block: DescribeClusterParameterGroupsRequest.Builder.() -> Unit): DescribeClusterParameterGroupsResponse = describeClusterParameterGroups(DescribeClusterParameterGroupsRequest.Builder().apply(block).build())

/**
 * Returns a detailed list of parameters contained within the specified Amazon Redshift parameter group. For each parameter the response includes information such as parameter name, description, data type, value, whether the parameter value is modifiable, and so on.
 *
 * You can specify *source* filter to retrieve parameters of only specific type. For example, to retrieve parameters that were modified by a user action such as from ModifyClusterParameterGroup, you can specify *source* equal to *user*.
 *
 *  For more information about parameters and parameter groups, go to [Amazon Redshift Parameter Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html) in the *Amazon Redshift Cluster Management Guide*.
 */
public suspend inline fun RedshiftClient.describeClusterParameters(crossinline block: DescribeClusterParametersRequest.Builder.() -> Unit): DescribeClusterParametersResponse = describeClusterParameters(DescribeClusterParametersRequest.Builder().apply(block).build())

/**
 * Returns information about Amazon Redshift security groups. If the name of a security group is specified, the response will contain only information about only that security group.
 *
 *  For information about managing security groups, go to [Amazon Redshift Cluster Security Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html) in the *Amazon Redshift Cluster Management Guide*.
 *
 * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all security groups that match any combination of the specified keys and values. For example, if you have `owner` and `environment` for tag keys, and `admin` and `test` for tag values, all security groups that have any combination of those values are returned.
 *
 * If both tag keys and values are omitted from the request, security groups are returned regardless of whether they have tag keys or values associated with them.
 */
public suspend inline fun RedshiftClient.describeClusterSecurityGroups(crossinline block: DescribeClusterSecurityGroupsRequest.Builder.() -> Unit): DescribeClusterSecurityGroupsResponse = describeClusterSecurityGroups(DescribeClusterSecurityGroupsRequest.Builder().apply(block).build())

/**
 * Returns one or more snapshot objects, which contain metadata about your cluster snapshots. By default, this operation returns information about all snapshots of all clusters that are owned by your Amazon Web Services account. No information is returned for snapshots owned by inactive Amazon Web Services accounts.
 *
 * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all snapshots that match any combination of the specified keys and values. For example, if you have `owner` and `environment` for tag keys, and `admin` and `test` for tag values, all snapshots that have any combination of those values are returned. Only snapshots that you own are returned in the response; shared snapshots are not returned with the tag key and tag value request parameters.
 *
 * If both tag keys and values are omitted from the request, snapshots are returned regardless of whether they have tag keys or values associated with them.
 */
public suspend inline fun RedshiftClient.describeClusterSnapshots(crossinline block: DescribeClusterSnapshotsRequest.Builder.() -> Unit): DescribeClusterSnapshotsResponse = describeClusterSnapshots(DescribeClusterSnapshotsRequest.Builder().apply(block).build())

/**
 * Returns one or more cluster subnet group objects, which contain metadata about your cluster subnet groups. By default, this operation returns information about all cluster subnet groups that are defined in your Amazon Web Services account.
 *
 * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all subnet groups that match any combination of the specified keys and values. For example, if you have `owner` and `environment` for tag keys, and `admin` and `test` for tag values, all subnet groups that have any combination of those values are returned.
 *
 * If both tag keys and values are omitted from the request, subnet groups are returned regardless of whether they have tag keys or values associated with them.
 */
public suspend inline fun RedshiftClient.describeClusterSubnetGroups(crossinline block: DescribeClusterSubnetGroupsRequest.Builder.() -> Unit): DescribeClusterSubnetGroupsResponse = describeClusterSubnetGroups(DescribeClusterSubnetGroupsRequest.Builder().apply(block).build())

/**
 * Returns a list of all the available maintenance tracks.
 */
public suspend inline fun RedshiftClient.describeClusterTracks(crossinline block: DescribeClusterTracksRequest.Builder.() -> Unit): DescribeClusterTracksResponse = describeClusterTracks(DescribeClusterTracksRequest.Builder().apply(block).build())

/**
 * Returns descriptions of the available Amazon Redshift cluster versions. You can call this operation even before creating any clusters to learn more about the Amazon Redshift versions. For more information about managing clusters, go to [Amazon Redshift Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html) in the *Amazon Redshift Cluster Management Guide*.
 */
public suspend inline fun RedshiftClient.describeClusterVersions(crossinline block: DescribeClusterVersionsRequest.Builder.() -> Unit): DescribeClusterVersionsResponse = describeClusterVersions(DescribeClusterVersionsRequest.Builder().apply(block).build())

/**
 * Returns properties of provisioned clusters including general cluster properties, cluster database properties, maintenance and backup properties, and security and access properties. This operation supports pagination. For more information about managing clusters, go to [Amazon Redshift Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html) in the *Amazon Redshift Cluster Management Guide*.
 *
 * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all clusters that match any combination of the specified keys and values. For example, if you have `owner` and `environment` for tag keys, and `admin` and `test` for tag values, all clusters that have any combination of those values are returned.
 *
 * If both tag keys and values are omitted from the request, clusters are returned regardless of whether they have tag keys or values associated with them.
 */
public suspend inline fun RedshiftClient.describeClusters(crossinline block: DescribeClustersRequest.Builder.() -> Unit): DescribeClustersResponse = describeClusters(DescribeClustersRequest.Builder().apply(block).build())

/**
 * Contains information about custom domain associations for a cluster.
 */
public suspend inline fun RedshiftClient.describeCustomDomainAssociations(crossinline block: DescribeCustomDomainAssociationsRequest.Builder.() -> Unit): DescribeCustomDomainAssociationsResponse = describeCustomDomainAssociations(DescribeCustomDomainAssociationsRequest.Builder().apply(block).build())

/**
 * Shows the status of any inbound or outbound datashares available in the specified account.
 */
public suspend inline fun RedshiftClient.describeDataShares(crossinline block: DescribeDataSharesRequest.Builder.() -> Unit): DescribeDataSharesResponse = describeDataShares(DescribeDataSharesRequest.Builder().apply(block).build())

/**
 * Returns a list of datashares where the account identifier being called is a consumer account identifier.
 */
public suspend inline fun RedshiftClient.describeDataSharesForConsumer(crossinline block: DescribeDataSharesForConsumerRequest.Builder.() -> Unit): DescribeDataSharesForConsumerResponse = describeDataSharesForConsumer(DescribeDataSharesForConsumerRequest.Builder().apply(block).build())

/**
 * Returns a list of datashares when the account identifier being called is a producer account identifier.
 */
public suspend inline fun RedshiftClient.describeDataSharesForProducer(crossinline block: DescribeDataSharesForProducerRequest.Builder.() -> Unit): DescribeDataSharesForProducerResponse = describeDataSharesForProducer(DescribeDataSharesForProducerRequest.Builder().apply(block).build())

/**
 * Returns a list of parameter settings for the specified parameter group family.
 *
 *  For more information about parameters and parameter groups, go to [Amazon Redshift Parameter Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html) in the *Amazon Redshift Cluster Management Guide*.
 */
public suspend inline fun RedshiftClient.describeDefaultClusterParameters(crossinline block: DescribeDefaultClusterParametersRequest.Builder.() -> Unit): DescribeDefaultClusterParametersResponse = describeDefaultClusterParameters(DescribeDefaultClusterParametersRequest.Builder().apply(block).build())

/**
 * Describes a Redshift-managed VPC endpoint.
 */
public suspend inline fun RedshiftClient.describeEndpointAccess(crossinline block: DescribeEndpointAccessRequest.Builder.() -> Unit): DescribeEndpointAccessResponse = describeEndpointAccess(DescribeEndpointAccessRequest.Builder().apply(block).build())

/**
 * Describes an endpoint authorization.
 */
public suspend inline fun RedshiftClient.describeEndpointAuthorization(crossinline block: DescribeEndpointAuthorizationRequest.Builder.() -> Unit): DescribeEndpointAuthorizationResponse = describeEndpointAuthorization(DescribeEndpointAuthorizationRequest.Builder().apply(block).build())

/**
 * Displays a list of event categories for all event source types, or for a specified source type. For a list of the event categories and source types, go to [Amazon Redshift Event Notifications](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-event-notifications.html).
 */
public suspend inline fun RedshiftClient.describeEventCategories(crossinline block: DescribeEventCategoriesRequest.Builder.() -> Unit): DescribeEventCategoriesResponse = describeEventCategories(DescribeEventCategoriesRequest.Builder().apply(block).build())

/**
 * Lists descriptions of all the Amazon Redshift event notification subscriptions for a customer account. If you specify a subscription name, lists the description for that subscription.
 *
 * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all event notification subscriptions that match any combination of the specified keys and values. For example, if you have `owner` and `environment` for tag keys, and `admin` and `test` for tag values, all subscriptions that have any combination of those values are returned.
 *
 * If both tag keys and values are omitted from the request, subscriptions are returned regardless of whether they have tag keys or values associated with them.
 */
public suspend inline fun RedshiftClient.describeEventSubscriptions(crossinline block: DescribeEventSubscriptionsRequest.Builder.() -> Unit): DescribeEventSubscriptionsResponse = describeEventSubscriptions(DescribeEventSubscriptionsRequest.Builder().apply(block).build())

/**
 * Returns events related to clusters, security groups, snapshots, and parameter groups for the past 14 days. Events specific to a particular cluster, security group, snapshot or parameter group can be obtained by providing the name as a parameter. By default, the past hour of events are returned.
 */
public suspend inline fun RedshiftClient.describeEvents(crossinline block: DescribeEventsRequest.Builder.() -> Unit): DescribeEventsResponse = describeEvents(DescribeEventsRequest.Builder().apply(block).build())

/**
 * Returns information about the specified HSM client certificate. If no certificate ID is specified, returns information about all the HSM certificates owned by your Amazon Web Services account.
 *
 * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all HSM client certificates that match any combination of the specified keys and values. For example, if you have `owner` and `environment` for tag keys, and `admin` and `test` for tag values, all HSM client certificates that have any combination of those values are returned.
 *
 * If both tag keys and values are omitted from the request, HSM client certificates are returned regardless of whether they have tag keys or values associated with them.
 */
public suspend inline fun RedshiftClient.describeHsmClientCertificates(crossinline block: DescribeHsmClientCertificatesRequest.Builder.() -> Unit): DescribeHsmClientCertificatesResponse = describeHsmClientCertificates(DescribeHsmClientCertificatesRequest.Builder().apply(block).build())

/**
 * Returns information about the specified Amazon Redshift HSM configuration. If no configuration ID is specified, returns information about all the HSM configurations owned by your Amazon Web Services account.
 *
 * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all HSM connections that match any combination of the specified keys and values. For example, if you have `owner` and `environment` for tag keys, and `admin` and `test` for tag values, all HSM connections that have any combination of those values are returned.
 *
 * If both tag keys and values are omitted from the request, HSM connections are returned regardless of whether they have tag keys or values associated with them.
 */
public suspend inline fun RedshiftClient.describeHsmConfigurations(crossinline block: DescribeHsmConfigurationsRequest.Builder.() -> Unit): DescribeHsmConfigurationsResponse = describeHsmConfigurations(DescribeHsmConfigurationsRequest.Builder().apply(block).build())

/**
 * Returns a list of inbound integrations.
 */
public suspend inline fun RedshiftClient.describeInboundIntegrations(crossinline block: DescribeInboundIntegrationsRequest.Builder.() -> Unit): DescribeInboundIntegrationsResponse = describeInboundIntegrations(DescribeInboundIntegrationsRequest.Builder().apply(block).build())

/**
 * Describes whether information, such as queries and connection attempts, is being logged for the specified Amazon Redshift cluster.
 */
public suspend inline fun RedshiftClient.describeLoggingStatus(crossinline block: DescribeLoggingStatusRequest.Builder.() -> Unit): DescribeLoggingStatusResponse = describeLoggingStatus(DescribeLoggingStatusRequest.Builder().apply(block).build())

/**
 * Returns properties of possible node configurations such as node type, number of nodes, and disk usage for the specified action type.
 */
public suspend inline fun RedshiftClient.describeNodeConfigurationOptions(crossinline block: DescribeNodeConfigurationOptionsRequest.Builder.() -> Unit): DescribeNodeConfigurationOptionsResponse = describeNodeConfigurationOptions(DescribeNodeConfigurationOptionsRequest.Builder().apply(block).build())

/**
 * Returns a list of orderable cluster options. Before you create a new cluster you can use this operation to find what options are available, such as the EC2 Availability Zones (AZ) in the specific Amazon Web Services Region that you can specify, and the node types you can request. The node types differ by available storage, memory, CPU and price. With the cost involved you might want to obtain a list of cluster options in the specific region and specify values when creating a cluster. For more information about managing clusters, go to [Amazon Redshift Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html) in the *Amazon Redshift Cluster Management Guide*.
 */
public suspend inline fun RedshiftClient.describeOrderableClusterOptions(crossinline block: DescribeOrderableClusterOptionsRequest.Builder.() -> Unit): DescribeOrderableClusterOptionsResponse = describeOrderableClusterOptions(DescribeOrderableClusterOptionsRequest.Builder().apply(block).build())

/**
 * Returns information about the partner integrations defined for a cluster.
 */
public suspend inline fun RedshiftClient.describePartners(crossinline block: DescribePartnersRequest.Builder.() -> Unit): DescribePartnersResponse = describePartners(DescribePartnersRequest.Builder().apply(block).build())

/**
 * Lists the Amazon Redshift IAM Identity Center applications.
 */
public suspend inline fun RedshiftClient.describeRedshiftIdcApplications(crossinline block: DescribeRedshiftIdcApplicationsRequest.Builder.() -> Unit): DescribeRedshiftIdcApplicationsResponse = describeRedshiftIdcApplications(DescribeRedshiftIdcApplicationsRequest.Builder().apply(block).build())

/**
 * Returns exchange status details and associated metadata for a reserved-node exchange. Statuses include such values as in progress and requested.
 */
public suspend inline fun RedshiftClient.describeReservedNodeExchangeStatus(crossinline block: DescribeReservedNodeExchangeStatusRequest.Builder.() -> Unit): DescribeReservedNodeExchangeStatusResponse = describeReservedNodeExchangeStatus(DescribeReservedNodeExchangeStatusRequest.Builder().apply(block).build())

/**
 * Returns a list of the available reserved node offerings by Amazon Redshift with their descriptions including the node type, the fixed and recurring costs of reserving the node and duration the node will be reserved for you. These descriptions help you determine which reserve node offering you want to purchase. You then use the unique offering ID in you call to PurchaseReservedNodeOffering to reserve one or more nodes for your Amazon Redshift cluster.
 *
 *  For more information about reserved node offerings, go to [Purchasing Reserved Nodes](https://docs.aws.amazon.com/redshift/latest/mgmt/purchase-reserved-node-instance.html) in the *Amazon Redshift Cluster Management Guide*.
 */
public suspend inline fun RedshiftClient.describeReservedNodeOfferings(crossinline block: DescribeReservedNodeOfferingsRequest.Builder.() -> Unit): DescribeReservedNodeOfferingsResponse = describeReservedNodeOfferings(DescribeReservedNodeOfferingsRequest.Builder().apply(block).build())

/**
 * Returns the descriptions of the reserved nodes.
 */
public suspend inline fun RedshiftClient.describeReservedNodes(crossinline block: DescribeReservedNodesRequest.Builder.() -> Unit): DescribeReservedNodesResponse = describeReservedNodes(DescribeReservedNodesRequest.Builder().apply(block).build())

/**
 * Returns information about the last resize operation for the specified cluster. If no resize operation has ever been initiated for the specified cluster, a `HTTP 404` error is returned. If a resize operation was initiated and completed, the status of the resize remains as `SUCCEEDED` until the next resize.
 *
 * A resize operation can be requested using ModifyCluster and specifying a different number or type of nodes for the cluster.
 */
public suspend inline fun RedshiftClient.describeResize(crossinline block: DescribeResizeRequest.Builder.() -> Unit): DescribeResizeResponse = describeResize(DescribeResizeRequest.Builder().apply(block).build())

/**
 * Describes properties of scheduled actions.
 */
public suspend inline fun RedshiftClient.describeScheduledActions(crossinline block: DescribeScheduledActionsRequest.Builder.() -> Unit): DescribeScheduledActionsResponse = describeScheduledActions(DescribeScheduledActionsRequest.Builder().apply(block).build())

/**
 * Returns a list of snapshot copy grants owned by the Amazon Web Services account in the destination region.
 *
 *  For more information about managing snapshot copy grants, go to [Amazon Redshift Database Encryption](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html) in the *Amazon Redshift Cluster Management Guide*.
 */
public suspend inline fun RedshiftClient.describeSnapshotCopyGrants(crossinline block: DescribeSnapshotCopyGrantsRequest.Builder.() -> Unit): DescribeSnapshotCopyGrantsResponse = describeSnapshotCopyGrants(DescribeSnapshotCopyGrantsRequest.Builder().apply(block).build())

/**
 * Returns a list of snapshot schedules.
 */
public suspend inline fun RedshiftClient.describeSnapshotSchedules(crossinline block: DescribeSnapshotSchedulesRequest.Builder.() -> Unit): DescribeSnapshotSchedulesResponse = describeSnapshotSchedules(DescribeSnapshotSchedulesRequest.Builder().apply(block).build())

/**
 * Returns account level backups storage size and provisional storage.
 */
public suspend inline fun RedshiftClient.describeStorage(crossinline block: DescribeStorageRequest.Builder.() -> Unit): DescribeStorageResponse = describeStorage(DescribeStorageRequest.Builder().apply(block).build())

/**
 * Lists the status of one or more table restore requests made using the RestoreTableFromClusterSnapshot API action. If you don't specify a value for the `TableRestoreRequestId` parameter, then `DescribeTableRestoreStatus` returns the status of all table restore requests ordered by the date and time of the request in ascending order. Otherwise `DescribeTableRestoreStatus` returns the status of the table specified by `TableRestoreRequestId`.
 */
public suspend inline fun RedshiftClient.describeTableRestoreStatus(crossinline block: DescribeTableRestoreStatusRequest.Builder.() -> Unit): DescribeTableRestoreStatusResponse = describeTableRestoreStatus(DescribeTableRestoreStatusRequest.Builder().apply(block).build())

/**
 * Returns a list of tags. You can return tags from a specific resource by specifying an ARN, or you can return all tags for a given type of resource, such as clusters, snapshots, and so on.
 *
 * The following are limitations for `DescribeTags`:
 * + You cannot specify an ARN and a resource-type value together in the same request.
 * + You cannot use the `MaxRecords` and `Marker` parameters together with the ARN parameter.
 * + The `MaxRecords` parameter can be a range from 10 to 50 results to return in a request.
 *
 * If you specify both tag keys and tag values in the same request, Amazon Redshift returns all resources that match any combination of the specified keys and values. For example, if you have `owner` and `environment` for tag keys, and `admin` and `test` for tag values, all resources that have any combination of those values are returned.
 *
 * If both tag keys and values are omitted from the request, resources are returned regardless of whether they have tag keys or values associated with them.
 */
public suspend inline fun RedshiftClient.describeTags(crossinline block: DescribeTagsRequest.Builder.() -> Unit): DescribeTagsResponse = describeTags(DescribeTagsRequest.Builder().apply(block).build())

/**
 * Shows usage limits on a cluster. Results are filtered based on the combination of input usage limit identifier, cluster identifier, and feature type parameters:
 * + If usage limit identifier, cluster identifier, and feature type are not provided, then all usage limit objects for the current account in the current region are returned.
 * + If usage limit identifier is provided, then the corresponding usage limit object is returned.
 * + If cluster identifier is provided, then all usage limit objects for the specified cluster are returned.
 * + If cluster identifier and feature type are provided, then all usage limit objects for the combination of cluster and feature are returned.
 */
public suspend inline fun RedshiftClient.describeUsageLimits(crossinline block: DescribeUsageLimitsRequest.Builder.() -> Unit): DescribeUsageLimitsResponse = describeUsageLimits(DescribeUsageLimitsRequest.Builder().apply(block).build())

/**
 * Stops logging information, such as queries and connection attempts, for the specified Amazon Redshift cluster.
 */
public suspend inline fun RedshiftClient.disableLogging(crossinline block: DisableLoggingRequest.Builder.() -> Unit): DisableLoggingResponse = disableLogging(DisableLoggingRequest.Builder().apply(block).build())

/**
 * Disables the automatic copying of snapshots from one region to another region for a specified cluster.
 *
 * If your cluster and its snapshots are encrypted using an encrypted symmetric key from Key Management Service, use DeleteSnapshotCopyGrant to delete the grant that grants Amazon Redshift permission to the key in the destination region.
 */
public suspend inline fun RedshiftClient.disableSnapshotCopy(crossinline block: DisableSnapshotCopyRequest.Builder.() -> Unit): DisableSnapshotCopyResponse = disableSnapshotCopy(DisableSnapshotCopyRequest.Builder().apply(block).build())

/**
 * From a datashare consumer account, remove association for the specified datashare.
 */
public suspend inline fun RedshiftClient.disassociateDataShareConsumer(crossinline block: DisassociateDataShareConsumerRequest.Builder.() -> Unit): DisassociateDataShareConsumerResponse = disassociateDataShareConsumer(DisassociateDataShareConsumerRequest.Builder().apply(block).build())

/**
 * Starts logging information, such as queries and connection attempts, for the specified Amazon Redshift cluster.
 */
public suspend inline fun RedshiftClient.enableLogging(crossinline block: EnableLoggingRequest.Builder.() -> Unit): EnableLoggingResponse = enableLogging(EnableLoggingRequest.Builder().apply(block).build())

/**
 * Enables the automatic copy of snapshots from one region to another region for a specified cluster.
 */
public suspend inline fun RedshiftClient.enableSnapshotCopy(crossinline block: EnableSnapshotCopyRequest.Builder.() -> Unit): EnableSnapshotCopyResponse = enableSnapshotCopy(EnableSnapshotCopyRequest.Builder().apply(block).build())

/**
 * Fails over the primary compute unit of the specified Multi-AZ cluster to another Availability Zone.
 */
public suspend inline fun RedshiftClient.failoverPrimaryCompute(crossinline block: FailoverPrimaryComputeRequest.Builder.() -> Unit): FailoverPrimaryComputeResponse = failoverPrimaryCompute(FailoverPrimaryComputeRequest.Builder().apply(block).build())

/**
 * Returns a database user name and temporary password with temporary authorization to log on to an Amazon Redshift database. The action returns the database user name prefixed with `IAM:` if `AutoCreate` is `False` or `IAMA:` if `AutoCreate` is `True`. You can optionally specify one or more database user groups that the user will join at log on. By default, the temporary credentials expire in 900 seconds. You can optionally specify a duration between 900 seconds (15 minutes) and 3600 seconds (60 minutes). For more information, see [Using IAM Authentication to Generate Database User Credentials](https://docs.aws.amazon.com/redshift/latest/mgmt/generating-user-credentials.html) in the Amazon Redshift Cluster Management Guide.
 *
 * The Identity and Access Management (IAM) user or role that runs GetClusterCredentials must have an IAM policy attached that allows access to all necessary actions and resources. For more information about permissions, see [Resource Policies for GetClusterCredentials](https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html#redshift-policy-resources.getclustercredentials-resources) in the Amazon Redshift Cluster Management Guide.
 *
 * If the `DbGroups` parameter is specified, the IAM policy must allow the `redshift:JoinGroup` action with access to the listed `dbgroups`.
 *
 * In addition, if the `AutoCreate` parameter is set to `True`, then the policy must include the `redshift:CreateClusterUser` permission.
 *
 * If the `DbName` parameter is specified, the IAM policy must allow access to the resource `dbname` for the specified database name.
 */
public suspend inline fun RedshiftClient.getClusterCredentials(crossinline block: GetClusterCredentialsRequest.Builder.() -> Unit): GetClusterCredentialsResponse = getClusterCredentials(GetClusterCredentialsRequest.Builder().apply(block).build())

/**
 * Returns a database user name and temporary password with temporary authorization to log in to an Amazon Redshift database. The database user is mapped 1:1 to the source Identity and Access Management (IAM) identity. For more information about IAM identities, see [IAM Identities (users, user groups, and roles)](https://docs.aws.amazon.com/IAM/latest/UserGuide/id.html) in the Amazon Web Services Identity and Access Management User Guide.
 *
 * The Identity and Access Management (IAM) identity that runs this operation must have an IAM policy attached that allows access to all necessary actions and resources. For more information about permissions, see [Using identity-based policies (IAM policies)](https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html) in the Amazon Redshift Cluster Management Guide.
 */
public suspend inline fun RedshiftClient.getClusterCredentialsWithIam(crossinline block: GetClusterCredentialsWithIamRequest.Builder.() -> Unit): GetClusterCredentialsWithIamResponse = getClusterCredentialsWithIam(GetClusterCredentialsWithIamRequest.Builder().apply(block).build())

/**
 * Gets the configuration options for the reserved-node exchange. These options include information about the source reserved node and target reserved node offering. Details include the node type, the price, the node count, and the offering type.
 */
public suspend inline fun RedshiftClient.getReservedNodeExchangeConfigurationOptions(crossinline block: GetReservedNodeExchangeConfigurationOptionsRequest.Builder.() -> Unit): GetReservedNodeExchangeConfigurationOptionsResponse = getReservedNodeExchangeConfigurationOptions(GetReservedNodeExchangeConfigurationOptionsRequest.Builder().apply(block).build())

/**
 * Returns an array of DC2 ReservedNodeOfferings that matches the payment type, term, and usage price of the given DC1 reserved node.
 */
public suspend inline fun RedshiftClient.getReservedNodeExchangeOfferings(crossinline block: GetReservedNodeExchangeOfferingsRequest.Builder.() -> Unit): GetReservedNodeExchangeOfferingsResponse = getReservedNodeExchangeOfferings(GetReservedNodeExchangeOfferingsRequest.Builder().apply(block).build())

/**
 * Get the resource policy for a specified resource.
 */
public suspend inline fun RedshiftClient.getResourcePolicy(crossinline block: GetResourcePolicyRequest.Builder.() -> Unit): GetResourcePolicyResponse = getResourcePolicy(GetResourcePolicyRequest.Builder().apply(block).build())

/**
 * List the Amazon Redshift Advisor recommendations for one or multiple Amazon Redshift clusters in an Amazon Web Services account.
 */
public suspend inline fun RedshiftClient.listRecommendations(crossinline block: ListRecommendationsRequest.Builder.() -> Unit): ListRecommendationsResponse = listRecommendations(ListRecommendationsRequest.Builder().apply(block).build())

/**
 * This operation is retired. Calling this operation does not change AQUA configuration. Amazon Redshift automatically determines whether to use AQUA (Advanced Query Accelerator).
 */
public suspend inline fun RedshiftClient.modifyAquaConfiguration(crossinline block: ModifyAquaConfigurationRequest.Builder.() -> Unit): ModifyAquaConfigurationResponse = modifyAquaConfiguration(ModifyAquaConfigurationRequest.Builder().apply(block).build())

/**
 * Modifies an authentication profile.
 */
public suspend inline fun RedshiftClient.modifyAuthenticationProfile(crossinline block: ModifyAuthenticationProfileRequest.Builder.() -> Unit): ModifyAuthenticationProfileResponse = modifyAuthenticationProfile(ModifyAuthenticationProfileRequest.Builder().apply(block).build())

/**
 * Modifies the settings for a cluster.
 *
 * You can also change node type and the number of nodes to scale up or down the cluster. When resizing a cluster, you must specify both the number of nodes and the node type even if one of the parameters does not change.
 *
 * You can add another security or parameter group, or change the admin user password. Resetting a cluster password or modifying the security groups associated with a cluster do not need a reboot. However, modifying a parameter group requires a reboot for parameters to take effect. For more information about managing clusters, go to [Amazon Redshift Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html) in the *Amazon Redshift Cluster Management Guide*.
 */
public suspend inline fun RedshiftClient.modifyCluster(crossinline block: ModifyClusterRequest.Builder.() -> Unit): ModifyClusterResponse = modifyCluster(ModifyClusterRequest.Builder().apply(block).build())

/**
 * Modifies the database revision of a cluster. The database revision is a unique revision of the database running in a cluster.
 */
public suspend inline fun RedshiftClient.modifyClusterDbRevision(crossinline block: ModifyClusterDbRevisionRequest.Builder.() -> Unit): ModifyClusterDbRevisionResponse = modifyClusterDbRevision(ModifyClusterDbRevisionRequest.Builder().apply(block).build())

/**
 * Modifies the list of Identity and Access Management (IAM) roles that can be used by the cluster to access other Amazon Web Services services.
 *
 * The maximum number of IAM roles that you can associate is subject to a quota. For more information, go to [Quotas and limits](https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html) in the *Amazon Redshift Cluster Management Guide*.
 */
public suspend inline fun RedshiftClient.modifyClusterIamRoles(crossinline block: ModifyClusterIamRolesRequest.Builder.() -> Unit): ModifyClusterIamRolesResponse = modifyClusterIamRoles(ModifyClusterIamRolesRequest.Builder().apply(block).build())

/**
 * Modifies the maintenance settings of a cluster.
 */
public suspend inline fun RedshiftClient.modifyClusterMaintenance(crossinline block: ModifyClusterMaintenanceRequest.Builder.() -> Unit): ModifyClusterMaintenanceResponse = modifyClusterMaintenance(ModifyClusterMaintenanceRequest.Builder().apply(block).build())

/**
 * Modifies the parameters of a parameter group. For the parameters parameter, it can't contain ASCII characters.
 *
 *  For more information about parameters and parameter groups, go to [Amazon Redshift Parameter Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html) in the *Amazon Redshift Cluster Management Guide*.
 */
public suspend inline fun RedshiftClient.modifyClusterParameterGroup(crossinline block: ModifyClusterParameterGroupRequest.Builder.() -> Unit): ModifyClusterParameterGroupResponse = modifyClusterParameterGroup(ModifyClusterParameterGroupRequest.Builder().apply(block).build())

/**
 * Modifies the settings for a snapshot.
 *
 * This exanmple modifies the manual retention period setting for a cluster snapshot.
 */
public suspend inline fun RedshiftClient.modifyClusterSnapshot(crossinline block: ModifyClusterSnapshotRequest.Builder.() -> Unit): ModifyClusterSnapshotResponse = modifyClusterSnapshot(ModifyClusterSnapshotRequest.Builder().apply(block).build())

/**
 * Modifies a snapshot schedule for a cluster.
 */
public suspend inline fun RedshiftClient.modifyClusterSnapshotSchedule(crossinline block: ModifyClusterSnapshotScheduleRequest.Builder.() -> Unit): ModifyClusterSnapshotScheduleResponse = modifyClusterSnapshotSchedule(ModifyClusterSnapshotScheduleRequest.Builder().apply(block).build())

/**
 * Modifies a cluster subnet group to include the specified list of VPC subnets. The operation replaces the existing list of subnets with the new list of subnets.
 */
public suspend inline fun RedshiftClient.modifyClusterSubnetGroup(crossinline block: ModifyClusterSubnetGroupRequest.Builder.() -> Unit): ModifyClusterSubnetGroupResponse = modifyClusterSubnetGroup(ModifyClusterSubnetGroupRequest.Builder().apply(block).build())

/**
 * Contains information for changing a custom domain association.
 */
public suspend inline fun RedshiftClient.modifyCustomDomainAssociation(crossinline block: ModifyCustomDomainAssociationRequest.Builder.() -> Unit): ModifyCustomDomainAssociationResponse = modifyCustomDomainAssociation(ModifyCustomDomainAssociationRequest.Builder().apply(block).build())

/**
 * Modifies a Redshift-managed VPC endpoint.
 */
public suspend inline fun RedshiftClient.modifyEndpointAccess(crossinline block: ModifyEndpointAccessRequest.Builder.() -> Unit): ModifyEndpointAccessResponse = modifyEndpointAccess(ModifyEndpointAccessRequest.Builder().apply(block).build())

/**
 * Modifies an existing Amazon Redshift event notification subscription.
 */
public suspend inline fun RedshiftClient.modifyEventSubscription(crossinline block: ModifyEventSubscriptionRequest.Builder.() -> Unit): ModifyEventSubscriptionResponse = modifyEventSubscription(ModifyEventSubscriptionRequest.Builder().apply(block).build())

/**
 * Changes an existing Amazon Redshift IAM Identity Center application.
 */
public suspend inline fun RedshiftClient.modifyRedshiftIdcApplication(crossinline block: ModifyRedshiftIdcApplicationRequest.Builder.() -> Unit): ModifyRedshiftIdcApplicationResponse = modifyRedshiftIdcApplication(ModifyRedshiftIdcApplicationRequest.Builder().apply(block).build())

/**
 * Modifies a scheduled action.
 */
public suspend inline fun RedshiftClient.modifyScheduledAction(crossinline block: ModifyScheduledActionRequest.Builder.() -> Unit): ModifyScheduledActionResponse = modifyScheduledAction(ModifyScheduledActionRequest.Builder().apply(block).build())

/**
 * Modifies the number of days to retain snapshots in the destination Amazon Web Services Region after they are copied from the source Amazon Web Services Region. By default, this operation only changes the retention period of copied automated snapshots. The retention periods for both new and existing copied automated snapshots are updated with the new retention period. You can set the manual option to change only the retention periods of copied manual snapshots. If you set this option, only newly copied manual snapshots have the new retention period.
 */
public suspend inline fun RedshiftClient.modifySnapshotCopyRetentionPeriod(crossinline block: ModifySnapshotCopyRetentionPeriodRequest.Builder.() -> Unit): ModifySnapshotCopyRetentionPeriodResponse = modifySnapshotCopyRetentionPeriod(ModifySnapshotCopyRetentionPeriodRequest.Builder().apply(block).build())

/**
 * Modifies a snapshot schedule. Any schedule associated with a cluster is modified asynchronously.
 */
public suspend inline fun RedshiftClient.modifySnapshotSchedule(crossinline block: ModifySnapshotScheduleRequest.Builder.() -> Unit): ModifySnapshotScheduleResponse = modifySnapshotSchedule(ModifySnapshotScheduleRequest.Builder().apply(block).build())

/**
 * Modifies a usage limit in a cluster. You can't modify the feature type or period of a usage limit.
 */
public suspend inline fun RedshiftClient.modifyUsageLimit(crossinline block: ModifyUsageLimitRequest.Builder.() -> Unit): ModifyUsageLimitResponse = modifyUsageLimit(ModifyUsageLimitRequest.Builder().apply(block).build())

/**
 * Pauses a cluster.
 */
public suspend inline fun RedshiftClient.pauseCluster(crossinline block: PauseClusterRequest.Builder.() -> Unit): PauseClusterResponse = pauseCluster(PauseClusterRequest.Builder().apply(block).build())

/**
 * Allows you to purchase reserved nodes. Amazon Redshift offers a predefined set of reserved node offerings. You can purchase one or more of the offerings. You can call the DescribeReservedNodeOfferings API to obtain the available reserved node offerings. You can call this API by providing a specific reserved node offering and the number of nodes you want to reserve.
 *
 *  For more information about reserved node offerings, go to [Purchasing Reserved Nodes](https://docs.aws.amazon.com/redshift/latest/mgmt/purchase-reserved-node-instance.html) in the *Amazon Redshift Cluster Management Guide*.
 */
public suspend inline fun RedshiftClient.purchaseReservedNodeOffering(crossinline block: PurchaseReservedNodeOfferingRequest.Builder.() -> Unit): PurchaseReservedNodeOfferingResponse = purchaseReservedNodeOffering(PurchaseReservedNodeOfferingRequest.Builder().apply(block).build())

/**
 * Updates the resource policy for a specified resource.
 */
public suspend inline fun RedshiftClient.putResourcePolicy(crossinline block: PutResourcePolicyRequest.Builder.() -> Unit): PutResourcePolicyResponse = putResourcePolicy(PutResourcePolicyRequest.Builder().apply(block).build())

/**
 * Reboots a cluster. This action is taken as soon as possible. It results in a momentary outage to the cluster, during which the cluster status is set to `rebooting`. A cluster event is created when the reboot is completed. Any pending cluster modifications (see ModifyCluster) are applied at this reboot. For more information about managing clusters, go to [Amazon Redshift Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html) in the *Amazon Redshift Cluster Management Guide*.
 */
public suspend inline fun RedshiftClient.rebootCluster(crossinline block: RebootClusterRequest.Builder.() -> Unit): RebootClusterResponse = rebootCluster(RebootClusterRequest.Builder().apply(block).build())

/**
 * From a datashare consumer account, rejects the specified datashare.
 */
public suspend inline fun RedshiftClient.rejectDataShare(crossinline block: RejectDataShareRequest.Builder.() -> Unit): RejectDataShareResponse = rejectDataShare(RejectDataShareRequest.Builder().apply(block).build())

/**
 * Sets one or more parameters of the specified parameter group to their default values and sets the source values of the parameters to "engine-default". To reset the entire parameter group specify the *ResetAllParameters* parameter. For parameter changes to take effect you must reboot any associated clusters.
 */
public suspend inline fun RedshiftClient.resetClusterParameterGroup(crossinline block: ResetClusterParameterGroupRequest.Builder.() -> Unit): ResetClusterParameterGroupResponse = resetClusterParameterGroup(ResetClusterParameterGroupRequest.Builder().apply(block).build())

/**
 * Changes the size of the cluster. You can change the cluster's type, or change the number or type of nodes. The default behavior is to use the elastic resize method. With an elastic resize, your cluster is available for read and write operations more quickly than with the classic resize method.
 *
 * Elastic resize operations have the following restrictions:
 * + You can only resize clusters of the following types:
 *    + dc2.large
 *    + dc2.8xlarge
 *    + ra3.xlplus
 *    + ra3.4xlarge
 *    + ra3.16xlarge
 * + The type of nodes that you add must match the node type for the cluster.
 */
public suspend inline fun RedshiftClient.resizeCluster(crossinline block: ResizeClusterRequest.Builder.() -> Unit): ResizeClusterResponse = resizeCluster(ResizeClusterRequest.Builder().apply(block).build())

/**
 * Creates a new cluster from a snapshot. By default, Amazon Redshift creates the resulting cluster with the same configuration as the original cluster from which the snapshot was created, except that the new cluster is created with the default cluster security and parameter groups. After Amazon Redshift creates the cluster, you can use the ModifyCluster API to associate a different security group and different parameter group with the restored cluster. If you are using a DS node type, you can also choose to change to another DS node type of the same size during restore.
 *
 * If you restore a cluster into a VPC, you must provide a cluster subnet group where you want the cluster restored.
 *
 *  For more information about working with snapshots, go to [Amazon Redshift Snapshots](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html) in the *Amazon Redshift Cluster Management Guide*.
 */
public suspend inline fun RedshiftClient.restoreFromClusterSnapshot(crossinline block: RestoreFromClusterSnapshotRequest.Builder.() -> Unit): RestoreFromClusterSnapshotResponse = restoreFromClusterSnapshot(RestoreFromClusterSnapshotRequest.Builder().apply(block).build())

/**
 * Creates a new table from a table in an Amazon Redshift cluster snapshot. You must create the new table within the Amazon Redshift cluster that the snapshot was taken from.
 *
 * You cannot use `RestoreTableFromClusterSnapshot` to restore a table with the same name as an existing table in an Amazon Redshift cluster. That is, you cannot overwrite an existing table in a cluster with a restored table. If you want to replace your original table with a new, restored table, then rename or drop your original table before you call `RestoreTableFromClusterSnapshot`. When you have renamed your original table, then you can pass the original name of the table as the `NewTableName` parameter value in the call to `RestoreTableFromClusterSnapshot`. This way, you can replace the original table with the table created from the snapshot.
 *
 * You can't use this operation to restore tables with [interleaved sort keys](https://docs.aws.amazon.com/redshift/latest/dg/t_Sorting_data.html#t_Sorting_data-interleaved).
 */
public suspend inline fun RedshiftClient.restoreTableFromClusterSnapshot(crossinline block: RestoreTableFromClusterSnapshotRequest.Builder.() -> Unit): RestoreTableFromClusterSnapshotResponse = restoreTableFromClusterSnapshot(RestoreTableFromClusterSnapshotRequest.Builder().apply(block).build())

/**
 * Resumes a paused cluster.
 */
public suspend inline fun RedshiftClient.resumeCluster(crossinline block: ResumeClusterRequest.Builder.() -> Unit): ResumeClusterResponse = resumeCluster(ResumeClusterRequest.Builder().apply(block).build())

/**
 * Revokes an ingress rule in an Amazon Redshift security group for a previously authorized IP range or Amazon EC2 security group. To add an ingress rule, see AuthorizeClusterSecurityGroupIngress. For information about managing security groups, go to [Amazon Redshift Cluster Security Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html) in the *Amazon Redshift Cluster Management Guide*.
 */
public suspend inline fun RedshiftClient.revokeClusterSecurityGroupIngress(crossinline block: RevokeClusterSecurityGroupIngressRequest.Builder.() -> Unit): RevokeClusterSecurityGroupIngressResponse = revokeClusterSecurityGroupIngress(RevokeClusterSecurityGroupIngressRequest.Builder().apply(block).build())

/**
 * Revokes access to a cluster.
 */
public suspend inline fun RedshiftClient.revokeEndpointAccess(crossinline block: RevokeEndpointAccessRequest.Builder.() -> Unit): RevokeEndpointAccessResponse = revokeEndpointAccess(RevokeEndpointAccessRequest.Builder().apply(block).build())

/**
 * Removes the ability of the specified Amazon Web Services account to restore the specified snapshot. If the account is currently restoring the snapshot, the restore will run to completion.
 *
 *  For more information about working with snapshots, go to [Amazon Redshift Snapshots](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html) in the *Amazon Redshift Cluster Management Guide*.
 */
public suspend inline fun RedshiftClient.revokeSnapshotAccess(crossinline block: RevokeSnapshotAccessRequest.Builder.() -> Unit): RevokeSnapshotAccessResponse = revokeSnapshotAccess(RevokeSnapshotAccessRequest.Builder().apply(block).build())

/**
 * Rotates the encryption keys for a cluster.
 */
public suspend inline fun RedshiftClient.rotateEncryptionKey(crossinline block: RotateEncryptionKeyRequest.Builder.() -> Unit): RotateEncryptionKeyResponse = rotateEncryptionKey(RotateEncryptionKeyRequest.Builder().apply(block).build())

/**
 * Updates the status of a partner integration.
 */
public suspend inline fun RedshiftClient.updatePartnerStatus(crossinline block: UpdatePartnerStatusRequest.Builder.() -> Unit): UpdatePartnerStatusResponse = updatePartnerStatus(UpdatePartnerStatusRequest.Builder().apply(block).build())
