/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.services.redshift.serde;

import aws.sdk.kotlin.services.redshift.model.RedshiftException;
import aws.sdk.kotlin.services.redshift.model.ResizeClusterResponse;
import aws.sdk.kotlin.services.redshift.serde.AwsQueryUtilKt;
import aws.sdk.kotlin.services.redshift.serde.ClusterDocumentDeserializerKt;
import aws.sdk.kotlin.services.redshift.serde.ClusterNotFoundFaultDeserializer;
import aws.sdk.kotlin.services.redshift.serde.DependentServiceUnavailableFaultDeserializer;
import aws.sdk.kotlin.services.redshift.serde.InsufficientClusterCapacityFaultDeserializer;
import aws.sdk.kotlin.services.redshift.serde.InvalidClusterStateFaultDeserializer;
import aws.sdk.kotlin.services.redshift.serde.InvalidReservedNodeStateFaultDeserializer;
import aws.sdk.kotlin.services.redshift.serde.LimitExceededFaultDeserializer;
import aws.sdk.kotlin.services.redshift.serde.NumberOfNodesPerClusterLimitExceededFaultDeserializer;
import aws.sdk.kotlin.services.redshift.serde.NumberOfNodesQuotaExceededFaultDeserializer;
import aws.sdk.kotlin.services.redshift.serde.ReservedNodeAlreadyExistsFaultDeserializer;
import aws.sdk.kotlin.services.redshift.serde.ReservedNodeAlreadyMigratedFaultDeserializer;
import aws.sdk.kotlin.services.redshift.serde.ReservedNodeNotFoundFaultDeserializer;
import aws.sdk.kotlin.services.redshift.serde.ReservedNodeOfferingNotFoundFaultDeserializer;
import aws.sdk.kotlin.services.redshift.serde.UnauthorizedOperationDeserializer;
import aws.sdk.kotlin.services.redshift.serde.UnsupportedOperationFaultDeserializer;
import aws.sdk.kotlin.services.redshift.serde.UnsupportedOptionFaultDeserializer;
import aws.smithy.kotlin.runtime.awsprotocol.AwsErrorDetails;
import aws.smithy.kotlin.runtime.awsprotocol.ProtocolErrorsKt;
import aws.smithy.kotlin.runtime.awsprotocol.ResponseUtilsKt;
import aws.smithy.kotlin.runtime.awsprotocol.xml.RestXmlErrorDeserializerKt;
import aws.smithy.kotlin.runtime.http.HttpCall;
import aws.smithy.kotlin.runtime.http.response.HttpResponse;
import aws.smithy.kotlin.runtime.operation.ExecutionContext;
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader;
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReaderKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\f"}, d2={"throwResizeClusterError", "", "context", "Laws/smithy/kotlin/runtime/operation/ExecutionContext;", "call", "Laws/smithy/kotlin/runtime/http/HttpCall;", "payload", "", "deserializeResizeClusterOperationBody", "", "builder", "Laws/sdk/kotlin/services/redshift/model/ResizeClusterResponse$Builder;", "redshift"})
@SourceDebugExtension(value={"SMAP\nResizeClusterOperationDeserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResizeClusterOperationDeserializer.kt\naws/sdk/kotlin/services/redshift/serde/ResizeClusterOperationDeserializerKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,85:1\n1#2:86\n*E\n"})
public final class ResizeClusterOperationDeserializerKt {
    /*
     * Unable to fully structure code
     */
    private static final Void throwResizeClusterError(ExecutionContext context, HttpCall call, byte[] payload) {
        wrappedResponse = ResponseUtilsKt.withPayload((HttpResponse)call.getResponse(), (byte[])payload);
        wrappedCall = HttpCall.copy$default((HttpCall)call, null, (HttpResponse)wrappedResponse, (int)1, null);
        try {
            v0 = payload;
            if (payload == null) {
                $i$a$-checkNotNull-ResizeClusterOperationDeserializerKt$throwResizeClusterError$errorDetails$1 = false;
                $i$a$-checkNotNull-ResizeClusterOperationDeserializerKt$throwResizeClusterError$errorDetails$1 = "unable to parse error from empty response";
                throw new IllegalStateException($i$a$-checkNotNull-ResizeClusterOperationDeserializerKt$throwResizeClusterError$errorDetails$1.toString());
            }
            $i$a$-checkNotNull-ResizeClusterOperationDeserializerKt$throwResizeClusterError$errorDetails$1 = RestXmlErrorDeserializerKt.parseRestXmlErrorResponseNoSuspend((byte[])payload);
        }
        catch (Exception ex) {
            it = var8_10 = new RedshiftException("Failed to parse response as 'awsQuery' error", ex);
            $i$a$-also-ResizeClusterOperationDeserializerKt$throwResizeClusterError$errorDetails$2 = false;
            ProtocolErrorsKt.setAseErrorMetadata((Object)it, (HttpResponse)wrappedCall.getResponse(), null);
            throw (Throwable)var8_10;
        }
        errorDetails = $i$a$-checkNotNull-ResizeClusterOperationDeserializerKt$throwResizeClusterError$errorDetails$1;
        var7_9 = errorDetails.getCode();
        if (var7_9 == null) ** GOTO lbl-1000
        tmp = -1;
        switch (var7_9.hashCode()) {
            case -846557814: {
                if (var7_9.equals("ReservedNodeAlreadyExists")) {
                    tmp = 1;
                }
                break;
            }
            case -1824771590: {
                if (var7_9.equals("NumberOfNodesQuotaExceeded")) {
                    tmp = 2;
                }
                break;
            }
            case 809039952: {
                if (var7_9.equals("InvalidReservedNodeState")) {
                    tmp = 3;
                }
                break;
            }
            case -2074260943: {
                if (var7_9.equals("InsufficientClusterCapacity")) {
                    tmp = 4;
                }
                break;
            }
            case 1191428654: {
                if (var7_9.equals("InvalidClusterState")) {
                    tmp = 5;
                }
                break;
            }
            case -1222056505: {
                if (var7_9.equals("ReservedNodeAlreadyMigrated")) {
                    tmp = 6;
                }
                break;
            }
            case -2117061601: {
                if (var7_9.equals("ReservedNodeOfferingNotFound")) {
                    tmp = 7;
                }
                break;
            }
            case 1411876520: {
                if (var7_9.equals("DependentServiceUnavailableFault")) {
                    tmp = 8;
                }
                break;
            }
            case 1850777184: {
                if (var7_9.equals("NumberOfNodesPerClusterLimitExceeded")) {
                    tmp = 9;
                }
                break;
            }
            case -808628231: {
                if (var7_9.equals("ReservedNodeNotFound")) {
                    tmp = 10;
                }
                break;
            }
            case 442938066: {
                if (var7_9.equals("UnsupportedOperation")) {
                    tmp = 11;
                }
                break;
            }
            case -2077139863: {
                if (var7_9.equals("ClusterNotFound")) {
                    tmp = 12;
                }
                break;
            }
            case 705510068: {
                if (var7_9.equals("LimitExceededFault")) {
                    tmp = 13;
                }
                break;
            }
            case -50073256: {
                if (var7_9.equals("UnsupportedOptionFault")) {
                    tmp = 14;
                }
                break;
            }
            case -1181827405: {
                if (var7_9.equals("UnauthorizedOperation")) {
                    tmp = 15;
                }
                break;
            }
        }
        switch (tmp) {
            case 6: {
                v1 = new ReservedNodeAlreadyMigratedFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 5: {
                v1 = new InvalidClusterStateFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 3: {
                v1 = new InvalidReservedNodeStateFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 1: {
                v1 = new ReservedNodeAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 7: {
                v1 = new ReservedNodeOfferingNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 8: {
                v1 = new DependentServiceUnavailableFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 2: {
                v1 = new NumberOfNodesQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 10: {
                v1 = new ReservedNodeNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 4: {
                v1 = new InsufficientClusterCapacityFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 11: {
                v1 = new UnsupportedOperationFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 15: {
                v1 = new UnauthorizedOperationDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 12: {
                v1 = new ClusterNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 14: {
                v1 = new UnsupportedOptionFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 9: {
                v1 = new NumberOfNodesPerClusterLimitExceededFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            case 13: {
                v1 = new LimitExceededFaultDeserializer().deserialize(context, wrappedCall, payload);
                break;
            }
            default: lbl-1000:
            // 2 sources

            {
                v1 = new RedshiftException(errorDetails.getMessage());
            }
        }
        ex = v1;
        ProtocolErrorsKt.setAseErrorMetadata((Object)ex, (HttpResponse)wrappedResponse, (AwsErrorDetails)((AwsErrorDetails)errorDetails));
        throw ex;
    }

    private static final void deserializeResizeClusterOperationBody(ResizeClusterResponse.Builder builder, byte[] payload) {
        XmlTagReader root = XmlTagReaderKt.xmlTagReader((byte[])payload);
        XmlTagReader unwrapped = AwsQueryUtilKt.unwrapAwsQueryResponse(root, "ResizeCluster");
        while (unwrapped.nextTag() != null) {
            XmlTagReader curr;
            if (Intrinsics.areEqual((Object)curr.getTagName(), (Object)"Cluster")) {
                builder.setCluster(ClusterDocumentDeserializerKt.deserializeClusterDocument(curr));
            }
            curr.drop();
        }
    }

    public static final /* synthetic */ Void access$throwResizeClusterError(ExecutionContext context, HttpCall call, byte[] payload) {
        return ResizeClusterOperationDeserializerKt.throwResizeClusterError(context, call, payload);
    }

    public static final /* synthetic */ void access$deserializeResizeClusterOperationBody(ResizeClusterResponse.Builder builder, byte[] payload) {
        ResizeClusterOperationDeserializerKt.deserializeResizeClusterOperationBody(builder, payload);
    }
}

