// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.serde

import aws.sdk.kotlin.services.redshift.model.ScheduledAction
import aws.sdk.kotlin.services.redshift.model.ScheduledActionState
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeScheduledActionDocument(reader: XmlTagReader): ScheduledAction {
    val builder = ScheduledAction.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // ScheduledActionName com.amazonaws.redshift#ScheduledAction$ScheduledActionName
            "ScheduledActionName" -> builder.scheduledActionName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // TargetAction com.amazonaws.redshift#ScheduledAction$TargetAction
            "TargetAction" -> builder.targetAction = deserializeScheduledActionTypeDocument(curr)
            // Schedule com.amazonaws.redshift#ScheduledAction$Schedule
            "Schedule" -> builder.schedule = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // IamRole com.amazonaws.redshift#ScheduledAction$IamRole
            "IamRole" -> builder.iamRole = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // ScheduledActionDescription com.amazonaws.redshift#ScheduledAction$ScheduledActionDescription
            "ScheduledActionDescription" -> builder.scheduledActionDescription = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // State com.amazonaws.redshift#ScheduledAction$State
            "State" -> builder.state = curr.tryData()
                .parse { ScheduledActionState.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.redshift#ScheduledActionState`)" }
            // NextInvocations com.amazonaws.redshift#ScheduledAction$NextInvocations
            "NextInvocations" -> builder.nextInvocations = deserializeScheduledActionTimeListShape(curr)
            // StartTime com.amazonaws.redshift#ScheduledAction$StartTime
            "StartTime" -> builder.startTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.redshift#TStamp`)" }
            // EndTime com.amazonaws.redshift#ScheduledAction$EndTime
            "EndTime" -> builder.endTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.redshift#TStamp`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
