// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.serde

import aws.sdk.kotlin.services.redshift.model.Cluster
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.sdk.kotlin.services.redshift.model.ResizeClusterResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class ResizeClusterOperationDeserializer: HttpDeserializer.NonStreaming<ResizeClusterResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ResizeClusterResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwResizeClusterError(context, call, payload)
        }
        val builder = ResizeClusterResponse.Builder()

        if (payload != null) {
            deserializeResizeClusterOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwResizeClusterError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ReservedNodeAlreadyMigrated" -> ReservedNodeAlreadyMigratedFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidClusterState" -> InvalidClusterStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidReservedNodeState" -> InvalidReservedNodeStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ReservedNodeAlreadyExists" -> ReservedNodeAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ReservedNodeOfferingNotFound" -> ReservedNodeOfferingNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DependentServiceUnavailableFault" -> DependentServiceUnavailableFaultDeserializer().deserialize(context, wrappedCall, payload)
        "NumberOfNodesQuotaExceeded" -> NumberOfNodesQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ReservedNodeNotFound" -> ReservedNodeNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InsufficientClusterCapacity" -> InsufficientClusterCapacityFaultDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedOperation" -> UnsupportedOperationFaultDeserializer().deserialize(context, wrappedCall, payload)
        "UnauthorizedOperation" -> UnauthorizedOperationDeserializer().deserialize(context, wrappedCall, payload)
        "ClusterNotFound" -> ClusterNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedOptionFault" -> UnsupportedOptionFaultDeserializer().deserialize(context, wrappedCall, payload)
        "NumberOfNodesPerClusterLimitExceeded" -> NumberOfNodesPerClusterLimitExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "LimitExceededFault" -> LimitExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeResizeClusterOperationBody(builder: ResizeClusterResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "ResizeCluster")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // Cluster com.amazonaws.redshift#ResizeClusterResult$Cluster
            "Cluster" -> builder.cluster = deserializeClusterDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
