// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.serde

import aws.sdk.kotlin.services.redshift.model.Cluster
import aws.sdk.kotlin.services.redshift.model.ModifySnapshotCopyRetentionPeriodResponse
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class ModifySnapshotCopyRetentionPeriodOperationDeserializer: HttpDeserializer.NonStreaming<ModifySnapshotCopyRetentionPeriodResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ModifySnapshotCopyRetentionPeriodResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwModifySnapshotCopyRetentionPeriodError(context, call, payload)
        }
        val builder = ModifySnapshotCopyRetentionPeriodResponse.Builder()

        if (payload != null) {
            deserializeModifySnapshotCopyRetentionPeriodOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwModifySnapshotCopyRetentionPeriodError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidClusterState" -> InvalidClusterStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "SnapshotCopyDisabledFault" -> SnapshotCopyDisabledFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRetentionPeriodFault" -> InvalidRetentionPeriodFaultDeserializer().deserialize(context, wrappedCall, payload)
        "UnauthorizedOperation" -> UnauthorizedOperationDeserializer().deserialize(context, wrappedCall, payload)
        "ClusterNotFound" -> ClusterNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeModifySnapshotCopyRetentionPeriodOperationBody(builder: ModifySnapshotCopyRetentionPeriodResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "ModifySnapshotCopyRetentionPeriod")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // Cluster com.amazonaws.redshift#ModifySnapshotCopyRetentionPeriodResult$Cluster
            "Cluster" -> builder.cluster = deserializeClusterDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
