// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.serde

import aws.sdk.kotlin.services.redshift.model.DataShareAssociation
import aws.sdk.kotlin.services.redshift.model.DataShareStatus
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeDataShareAssociationDocument(reader: XmlTagReader): DataShareAssociation {
    val builder = DataShareAssociation.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // ConsumerIdentifier com.amazonaws.redshift#DataShareAssociation$ConsumerIdentifier
            "ConsumerIdentifier" -> builder.consumerIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // Status com.amazonaws.redshift#DataShareAssociation$Status
            "Status" -> builder.status = curr.tryData()
                .parse { DataShareStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.redshift#DataShareStatus`)" }
            // ConsumerRegion com.amazonaws.redshift#DataShareAssociation$ConsumerRegion
            "ConsumerRegion" -> builder.consumerRegion = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.redshift#String`)" }
            // CreatedDate com.amazonaws.redshift#DataShareAssociation$CreatedDate
            "CreatedDate" -> builder.createdDate = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.redshift#TStamp`)" }
            // StatusChangeDate com.amazonaws.redshift#DataShareAssociation$StatusChangeDate
            "StatusChangeDate" -> builder.statusChangeDate = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.redshift#TStamp`)" }
            // ProducerAllowedWrites com.amazonaws.redshift#DataShareAssociation$ProducerAllowedWrites
            "ProducerAllowedWrites" -> builder.producerAllowedWrites = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.redshift#BooleanOptional`)" }
            // ConsumerAcceptedWrites com.amazonaws.redshift#DataShareAssociation$ConsumerAcceptedWrites
            "ConsumerAcceptedWrites" -> builder.consumerAcceptedWrites = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.redshift#BooleanOptional`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
