// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.serde

import aws.sdk.kotlin.services.redshift.model.CreateSnapshotCopyGrantResponse
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.sdk.kotlin.services.redshift.model.SnapshotCopyGrant
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class CreateSnapshotCopyGrantOperationDeserializer: HttpDeserializer.NonStreaming<CreateSnapshotCopyGrantResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateSnapshotCopyGrantResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateSnapshotCopyGrantError(context, call, payload)
        }
        val builder = CreateSnapshotCopyGrantResponse.Builder()

        if (payload != null) {
            deserializeCreateSnapshotCopyGrantOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateSnapshotCopyGrantError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "SnapshotCopyGrantAlreadyExistsFault" -> SnapshotCopyGrantAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload)
        "TagLimitExceededFault" -> TagLimitExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DependentServiceRequestThrottlingFault" -> DependentServiceRequestThrottlingFaultDeserializer().deserialize(context, wrappedCall, payload)
        "SnapshotCopyGrantQuotaExceededFault" -> SnapshotCopyGrantQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "LimitExceededFault" -> LimitExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidTagFault" -> InvalidTagFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateSnapshotCopyGrantOperationBody(builder: CreateSnapshotCopyGrantResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "CreateSnapshotCopyGrant")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // SnapshotCopyGrant com.amazonaws.redshift#CreateSnapshotCopyGrantResult$SnapshotCopyGrant
            "SnapshotCopyGrant" -> builder.snapshotCopyGrant = deserializeSnapshotCopyGrantDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
