// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.serde

import aws.sdk.kotlin.services.redshift.model.CreateRedshiftIdcApplicationResponse
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.sdk.kotlin.services.redshift.model.RedshiftIdcApplication
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class CreateRedshiftIdcApplicationOperationDeserializer: HttpDeserializer.NonStreaming<CreateRedshiftIdcApplicationResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateRedshiftIdcApplicationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateRedshiftIdcApplicationError(context, call, payload)
        }
        val builder = CreateRedshiftIdcApplicationResponse.Builder()

        if (payload != null) {
            deserializeCreateRedshiftIdcApplicationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateRedshiftIdcApplicationError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DependentServiceAccessDenied" -> DependentServiceAccessDeniedFaultDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedOperation" -> UnsupportedOperationFaultDeserializer().deserialize(context, wrappedCall, payload)
        "RedshiftIdcApplicationAlreadyExists" -> RedshiftIdcApplicationAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DependentServiceUnavailableFault" -> DependentServiceUnavailableFaultDeserializer().deserialize(context, wrappedCall, payload)
        "RedshiftIdcApplicationQuotaExceeded" -> RedshiftIdcApplicationQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateRedshiftIdcApplicationOperationBody(builder: CreateRedshiftIdcApplicationResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "CreateRedshiftIdcApplication")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // RedshiftIdcApplication com.amazonaws.redshift#CreateRedshiftIdcApplicationResult$RedshiftIdcApplication
            "RedshiftIdcApplication" -> builder.redshiftIdcApplication = deserializeRedshiftIdcApplicationDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
