// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.serde

import aws.sdk.kotlin.services.redshift.model.BatchModifyClusterSnapshotsResponse
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.sdk.kotlin.services.redshift.model.SnapshotErrorMessage
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class BatchModifyClusterSnapshotsOperationDeserializer: HttpDeserializer.NonStreaming<BatchModifyClusterSnapshotsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): BatchModifyClusterSnapshotsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwBatchModifyClusterSnapshotsError(context, call, payload)
        }
        val builder = BatchModifyClusterSnapshotsResponse.Builder()

        if (payload != null) {
            deserializeBatchModifyClusterSnapshotsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwBatchModifyClusterSnapshotsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidRetentionPeriodFault" -> InvalidRetentionPeriodFaultDeserializer().deserialize(context, wrappedCall, payload)
        "BatchModifyClusterSnapshotsLimitExceededFault" -> BatchModifyClusterSnapshotsLimitExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchModifyClusterSnapshotsOperationBody(builder: BatchModifyClusterSnapshotsResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "BatchModifyClusterSnapshots")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // Errors com.amazonaws.redshift#BatchModifyClusterSnapshotsOutputMessage$Errors
            "Errors" -> builder.errors = deserializeBatchSnapshotOperationErrorsShape(curr)
            // Resources com.amazonaws.redshift#BatchModifyClusterSnapshotsOutputMessage$Resources
            "Resources" -> builder.resources = deserializeSnapshotIdentifierListShape(curr)
            else -> {}
        }
        curr.drop()
    }
}
