// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes a parameter in a cluster parameter group.
 */
public class Parameter private constructor(builder: Builder) {
    /**
     * The valid range of values for the parameter.
     */
    public val allowedValues: kotlin.String? = builder.allowedValues
    /**
     * Specifies how to apply the WLM configuration parameter. Some properties can be applied dynamically, while other properties require that any associated clusters be rebooted for the configuration changes to be applied. For more information about parameters and parameter groups, go to [Amazon Redshift Parameter Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html) in the *Amazon Redshift Cluster Management Guide*.
     */
    public val applyType: aws.sdk.kotlin.services.redshift.model.ParameterApplyType? = builder.applyType
    /**
     * The data type of the parameter.
     */
    public val dataType: kotlin.String? = builder.dataType
    /**
     * A description of the parameter.
     */
    public val description: kotlin.String? = builder.description
    /**
     * If `true`, the parameter can be modified. Some parameters have security or operational implications that prevent them from being changed.
     */
    public val isModifiable: kotlin.Boolean? = builder.isModifiable
    /**
     * The earliest engine version to which the parameter can apply.
     */
    public val minimumEngineVersion: kotlin.String? = builder.minimumEngineVersion
    /**
     * The name of the parameter.
     */
    public val parameterName: kotlin.String? = builder.parameterName
    /**
     * The value of the parameter. If `ParameterName` is `wlm_json_configuration`, then the maximum size of `ParameterValue` is 8000 characters.
     */
    public val parameterValue: kotlin.String? = builder.parameterValue
    /**
     * The source of the parameter value, such as "engine-default" or "user".
     */
    public val source: kotlin.String? = builder.source

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.Parameter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Parameter(")
        append("allowedValues=$allowedValues,")
        append("applyType=$applyType,")
        append("dataType=$dataType,")
        append("description=$description,")
        append("isModifiable=$isModifiable,")
        append("minimumEngineVersion=$minimumEngineVersion,")
        append("parameterName=$parameterName,")
        append("parameterValue=$parameterValue,")
        append("source=$source")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowedValues?.hashCode() ?: 0
        result = 31 * result + (applyType?.hashCode() ?: 0)
        result = 31 * result + (dataType?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (isModifiable?.hashCode() ?: 0)
        result = 31 * result + (minimumEngineVersion?.hashCode() ?: 0)
        result = 31 * result + (parameterName?.hashCode() ?: 0)
        result = 31 * result + (parameterValue?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Parameter

        if (allowedValues != other.allowedValues) return false
        if (applyType != other.applyType) return false
        if (dataType != other.dataType) return false
        if (description != other.description) return false
        if (isModifiable != other.isModifiable) return false
        if (minimumEngineVersion != other.minimumEngineVersion) return false
        if (parameterName != other.parameterName) return false
        if (parameterValue != other.parameterValue) return false
        if (source != other.source) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.Parameter = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The valid range of values for the parameter.
         */
        public var allowedValues: kotlin.String? = null
        /**
         * Specifies how to apply the WLM configuration parameter. Some properties can be applied dynamically, while other properties require that any associated clusters be rebooted for the configuration changes to be applied. For more information about parameters and parameter groups, go to [Amazon Redshift Parameter Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html) in the *Amazon Redshift Cluster Management Guide*.
         */
        public var applyType: aws.sdk.kotlin.services.redshift.model.ParameterApplyType? = null
        /**
         * The data type of the parameter.
         */
        public var dataType: kotlin.String? = null
        /**
         * A description of the parameter.
         */
        public var description: kotlin.String? = null
        /**
         * If `true`, the parameter can be modified. Some parameters have security or operational implications that prevent them from being changed.
         */
        public var isModifiable: kotlin.Boolean? = null
        /**
         * The earliest engine version to which the parameter can apply.
         */
        public var minimumEngineVersion: kotlin.String? = null
        /**
         * The name of the parameter.
         */
        public var parameterName: kotlin.String? = null
        /**
         * The value of the parameter. If `ParameterName` is `wlm_json_configuration`, then the maximum size of `ParameterValue` is 8000 characters.
         */
        public var parameterValue: kotlin.String? = null
        /**
         * The source of the parameter value, such as "engine-default" or "user".
         */
        public var source: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.Parameter) : this() {
            this.allowedValues = x.allowedValues
            this.applyType = x.applyType
            this.dataType = x.dataType
            this.description = x.description
            this.isModifiable = x.isModifiable
            this.minimumEngineVersion = x.minimumEngineVersion
            this.parameterName = x.parameterName
            this.parameterValue = x.parameterValue
            this.source = x.source
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.Parameter = Parameter(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
