// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.serde

import aws.sdk.kotlin.services.redshift.model.ClusterSecurityGroup
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.sdk.kotlin.services.redshift.model.RevokeClusterSecurityGroupIngressResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class RevokeClusterSecurityGroupIngressOperationDeserializer: HttpDeserialize<RevokeClusterSecurityGroupIngressResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): RevokeClusterSecurityGroupIngressResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwRevokeClusterSecurityGroupIngressError(context, call)
        }
        val builder = RevokeClusterSecurityGroupIngressResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeRevokeClusterSecurityGroupIngressOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwRevokeClusterSecurityGroupIngressError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidClusterSecurityGroupState" -> InvalidClusterSecurityGroupStateFaultDeserializer().deserialize(context, wrappedCall)
        "ClusterSecurityGroupNotFound" -> ClusterSecurityGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "AuthorizationNotFound" -> AuthorizationNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeRevokeClusterSecurityGroupIngressOperationBody(builder: RevokeClusterSecurityGroupIngressResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("RevokeClusterSecurityGroupIngressResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("RevokeClusterSecurityGroupIngressResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap RevokeClusterSecurityGroupIngress response")
    }
    // end unwrap response wrapper

    val CLUSTERSECURITYGROUP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("ClusterSecurityGroup"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://redshift.amazonaws.com/doc/2012-12-01/"))
        trait(XmlSerialName("RevokeClusterSecurityGroupIngressResult"))
        field(CLUSTERSECURITYGROUP_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CLUSTERSECURITYGROUP_DESCRIPTOR.index -> builder.clusterSecurityGroup = deserializeClusterSecurityGroupDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
