// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.serde

import aws.sdk.kotlin.services.redshift.model.EventSubscription
import aws.sdk.kotlin.services.redshift.model.ModifyEventSubscriptionResponse
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class ModifyEventSubscriptionOperationDeserializer: HttpDeserialize<ModifyEventSubscriptionResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): ModifyEventSubscriptionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwModifyEventSubscriptionError(context, call)
        }
        val builder = ModifyEventSubscriptionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeModifyEventSubscriptionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwModifyEventSubscriptionError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "SubscriptionSeverityNotFound" -> SubscriptionSeverityNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "SubscriptionEventIdNotFound" -> SubscriptionEventIdNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "SubscriptionCategoryNotFound" -> SubscriptionCategoryNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidSubscriptionStateFault" -> InvalidSubscriptionStateFaultDeserializer().deserialize(context, wrappedCall)
        "SNSTopicArnNotFound" -> SnsTopicArnNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "SNSNoAuthorization" -> SnsNoAuthorizationFaultDeserializer().deserialize(context, wrappedCall)
        "SourceNotFound" -> SourceNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "SubscriptionNotFound" -> SubscriptionNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "SNSInvalidTopic" -> SnsInvalidTopicFaultDeserializer().deserialize(context, wrappedCall)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeModifyEventSubscriptionOperationBody(builder: ModifyEventSubscriptionResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("ModifyEventSubscriptionResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("ModifyEventSubscriptionResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap ModifyEventSubscription response")
    }
    // end unwrap response wrapper

    val EVENTSUBSCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("EventSubscription"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://redshift.amazonaws.com/doc/2012-12-01/"))
        trait(XmlSerialName("ModifyEventSubscriptionResult"))
        field(EVENTSUBSCRIPTION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                EVENTSUBSCRIPTION_DESCRIPTOR.index -> builder.eventSubscription = deserializeEventSubscriptionDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
