// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.serde

import aws.sdk.kotlin.services.redshift.model.DeleteResourcePolicyResponse
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class DeleteResourcePolicyOperationDeserializer: HttpDeserialize<DeleteResourcePolicyResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DeleteResourcePolicyResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeleteResourcePolicyError(context, call)
        }
        val builder = DeleteResourcePolicyResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDeleteResourcePolicyError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "UnsupportedOperation" -> UnsupportedOperationFaultDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundFault" -> ResourceNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
