// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.serde

import aws.sdk.kotlin.services.redshift.model.CancelResizeResponse
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import kotlin.collections.mutableListOf


internal class CancelResizeOperationDeserializer: HttpDeserialize<CancelResizeResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CancelResizeResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCancelResizeError(context, call)
        }
        val builder = CancelResizeResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCancelResizeOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCancelResizeError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResizeNotFound" -> ResizeNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "UnsupportedOperation" -> UnsupportedOperationFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidClusterState" -> InvalidClusterStateFaultDeserializer().deserialize(context, wrappedCall)
        "ClusterNotFound" -> ClusterNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCancelResizeOperationBody(builder: CancelResizeResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("CancelResizeResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("CancelResizeResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap CancelResize response")
    }
    // end unwrap response wrapper

    val AVGRESIZERATEINMEGABYTESPERSECOND_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Double, XmlSerialName("AvgResizeRateInMegaBytesPerSecond"))
    val DATATRANSFERPROGRESSPERCENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Double, XmlSerialName("DataTransferProgressPercent"))
    val ELAPSEDTIMEINSECONDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, XmlSerialName("ElapsedTimeInSeconds"))
    val ESTIMATEDTIMETOCOMPLETIONINSECONDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, XmlSerialName("EstimatedTimeToCompletionInSeconds"))
    val IMPORTTABLESCOMPLETED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("ImportTablesCompleted"))
    val IMPORTTABLESINPROGRESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("ImportTablesInProgress"))
    val IMPORTTABLESNOTSTARTED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("ImportTablesNotStarted"))
    val MESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Message"))
    val PROGRESSINMEGABYTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, XmlSerialName("ProgressInMegaBytes"))
    val RESIZETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("ResizeType"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Status"))
    val TARGETCLUSTERTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("TargetClusterType"))
    val TARGETENCRYPTIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("TargetEncryptionType"))
    val TARGETNODETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("TargetNodeType"))
    val TARGETNUMBEROFNODES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, XmlSerialName("TargetNumberOfNodes"))
    val TOTALRESIZEDATAINMEGABYTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, XmlSerialName("TotalResizeDataInMegaBytes"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://redshift.amazonaws.com/doc/2012-12-01/"))
        trait(XmlSerialName("CancelResizeResult"))
        field(AVGRESIZERATEINMEGABYTESPERSECOND_DESCRIPTOR)
        field(DATATRANSFERPROGRESSPERCENT_DESCRIPTOR)
        field(ELAPSEDTIMEINSECONDS_DESCRIPTOR)
        field(ESTIMATEDTIMETOCOMPLETIONINSECONDS_DESCRIPTOR)
        field(IMPORTTABLESCOMPLETED_DESCRIPTOR)
        field(IMPORTTABLESINPROGRESS_DESCRIPTOR)
        field(IMPORTTABLESNOTSTARTED_DESCRIPTOR)
        field(MESSAGE_DESCRIPTOR)
        field(PROGRESSINMEGABYTES_DESCRIPTOR)
        field(RESIZETYPE_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TARGETCLUSTERTYPE_DESCRIPTOR)
        field(TARGETENCRYPTIONTYPE_DESCRIPTOR)
        field(TARGETNODETYPE_DESCRIPTOR)
        field(TARGETNUMBEROFNODES_DESCRIPTOR)
        field(TOTALRESIZEDATAINMEGABYTES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AVGRESIZERATEINMEGABYTESPERSECOND_DESCRIPTOR.index -> builder.avgResizeRateInMegaBytesPerSecond = deserializeDouble()
                DATATRANSFERPROGRESSPERCENT_DESCRIPTOR.index -> builder.dataTransferProgressPercent = deserializeDouble()
                ELAPSEDTIMEINSECONDS_DESCRIPTOR.index -> builder.elapsedTimeInSeconds = deserializeLong()
                ESTIMATEDTIMETOCOMPLETIONINSECONDS_DESCRIPTOR.index -> builder.estimatedTimeToCompletionInSeconds = deserializeLong()
                IMPORTTABLESCOMPLETED_DESCRIPTOR.index -> builder.importTablesCompleted =
                    deserializer.deserializeList(IMPORTTABLESCOMPLETED_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                IMPORTTABLESINPROGRESS_DESCRIPTOR.index -> builder.importTablesInProgress =
                    deserializer.deserializeList(IMPORTTABLESINPROGRESS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                IMPORTTABLESNOTSTARTED_DESCRIPTOR.index -> builder.importTablesNotStarted =
                    deserializer.deserializeList(IMPORTTABLESNOTSTARTED_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                MESSAGE_DESCRIPTOR.index -> builder.message = deserializeString()
                PROGRESSINMEGABYTES_DESCRIPTOR.index -> builder.progressInMegaBytes = deserializeLong()
                RESIZETYPE_DESCRIPTOR.index -> builder.resizeType = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString()
                TARGETCLUSTERTYPE_DESCRIPTOR.index -> builder.targetClusterType = deserializeString()
                TARGETENCRYPTIONTYPE_DESCRIPTOR.index -> builder.targetEncryptionType = deserializeString()
                TARGETNODETYPE_DESCRIPTOR.index -> builder.targetNodeType = deserializeString()
                TARGETNUMBEROFNODES_DESCRIPTOR.index -> builder.targetNumberOfNodes = deserializeInt()
                TOTALRESIZEDATAINMEGABYTES_DESCRIPTOR.index -> builder.totalResizeDataInMegaBytes = deserializeLong()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
