// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the status of a RestoreTableFromClusterSnapshot operation.
 */
public class TableRestoreStatus private constructor(builder: Builder) {
    /**
     * The identifier of the Amazon Redshift cluster that the table is being restored to.
     */
    public val clusterIdentifier: kotlin.String? = builder.clusterIdentifier
    /**
     * A description of the status of the table restore request. Status values include `SUCCEEDED`, `FAILED`, `CANCELED`, `PENDING`, `IN_PROGRESS`.
     */
    public val message: kotlin.String? = builder.message
    /**
     * The name of the table to create as a result of the table restore request.
     */
    public val newTableName: kotlin.String? = builder.newTableName
    /**
     * The amount of data restored to the new table so far, in megabytes (MB).
     */
    public val progressInMegaBytes: kotlin.Long? = builder.progressInMegaBytes
    /**
     * The time that the table restore request was made, in Universal Coordinated Time (UTC).
     */
    public val requestTime: aws.smithy.kotlin.runtime.time.Instant? = builder.requestTime
    /**
     * The identifier of the snapshot that the table is being restored from.
     */
    public val snapshotIdentifier: kotlin.String? = builder.snapshotIdentifier
    /**
     * The name of the source database that contains the table being restored.
     */
    public val sourceDatabaseName: kotlin.String? = builder.sourceDatabaseName
    /**
     * The name of the source schema that contains the table being restored.
     */
    public val sourceSchemaName: kotlin.String? = builder.sourceSchemaName
    /**
     * The name of the source table being restored.
     */
    public val sourceTableName: kotlin.String? = builder.sourceTableName
    /**
     * A value that describes the current state of the table restore request.
     *
     * Valid Values: `SUCCEEDED`, `FAILED`, `CANCELED`, `PENDING`, `IN_PROGRESS`
     */
    public val status: aws.sdk.kotlin.services.redshift.model.TableRestoreStatusType? = builder.status
    /**
     * The unique identifier for the table restore request.
     */
    public val tableRestoreRequestId: kotlin.String? = builder.tableRestoreRequestId
    /**
     * The name of the database to restore the table to.
     */
    public val targetDatabaseName: kotlin.String? = builder.targetDatabaseName
    /**
     * The name of the schema to restore the table to.
     */
    public val targetSchemaName: kotlin.String? = builder.targetSchemaName
    /**
     * The total amount of data to restore to the new table, in megabytes (MB).
     */
    public val totalDataInMegaBytes: kotlin.Long? = builder.totalDataInMegaBytes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.TableRestoreStatus = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TableRestoreStatus(")
        append("clusterIdentifier=$clusterIdentifier,")
        append("message=$message,")
        append("newTableName=$newTableName,")
        append("progressInMegaBytes=$progressInMegaBytes,")
        append("requestTime=$requestTime,")
        append("snapshotIdentifier=$snapshotIdentifier,")
        append("sourceDatabaseName=$sourceDatabaseName,")
        append("sourceSchemaName=$sourceSchemaName,")
        append("sourceTableName=$sourceTableName,")
        append("status=$status,")
        append("tableRestoreRequestId=$tableRestoreRequestId,")
        append("targetDatabaseName=$targetDatabaseName,")
        append("targetSchemaName=$targetSchemaName,")
        append("totalDataInMegaBytes=$totalDataInMegaBytes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterIdentifier?.hashCode() ?: 0
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (newTableName?.hashCode() ?: 0)
        result = 31 * result + (progressInMegaBytes?.hashCode() ?: 0)
        result = 31 * result + (requestTime?.hashCode() ?: 0)
        result = 31 * result + (snapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (sourceDatabaseName?.hashCode() ?: 0)
        result = 31 * result + (sourceSchemaName?.hashCode() ?: 0)
        result = 31 * result + (sourceTableName?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tableRestoreRequestId?.hashCode() ?: 0)
        result = 31 * result + (targetDatabaseName?.hashCode() ?: 0)
        result = 31 * result + (targetSchemaName?.hashCode() ?: 0)
        result = 31 * result + (totalDataInMegaBytes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TableRestoreStatus

        if (clusterIdentifier != other.clusterIdentifier) return false
        if (message != other.message) return false
        if (newTableName != other.newTableName) return false
        if (progressInMegaBytes != other.progressInMegaBytes) return false
        if (requestTime != other.requestTime) return false
        if (snapshotIdentifier != other.snapshotIdentifier) return false
        if (sourceDatabaseName != other.sourceDatabaseName) return false
        if (sourceSchemaName != other.sourceSchemaName) return false
        if (sourceTableName != other.sourceTableName) return false
        if (status != other.status) return false
        if (tableRestoreRequestId != other.tableRestoreRequestId) return false
        if (targetDatabaseName != other.targetDatabaseName) return false
        if (targetSchemaName != other.targetSchemaName) return false
        if (totalDataInMegaBytes != other.totalDataInMegaBytes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.TableRestoreStatus = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier of the Amazon Redshift cluster that the table is being restored to.
         */
        public var clusterIdentifier: kotlin.String? = null
        /**
         * A description of the status of the table restore request. Status values include `SUCCEEDED`, `FAILED`, `CANCELED`, `PENDING`, `IN_PROGRESS`.
         */
        public var message: kotlin.String? = null
        /**
         * The name of the table to create as a result of the table restore request.
         */
        public var newTableName: kotlin.String? = null
        /**
         * The amount of data restored to the new table so far, in megabytes (MB).
         */
        public var progressInMegaBytes: kotlin.Long? = null
        /**
         * The time that the table restore request was made, in Universal Coordinated Time (UTC).
         */
        public var requestTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The identifier of the snapshot that the table is being restored from.
         */
        public var snapshotIdentifier: kotlin.String? = null
        /**
         * The name of the source database that contains the table being restored.
         */
        public var sourceDatabaseName: kotlin.String? = null
        /**
         * The name of the source schema that contains the table being restored.
         */
        public var sourceSchemaName: kotlin.String? = null
        /**
         * The name of the source table being restored.
         */
        public var sourceTableName: kotlin.String? = null
        /**
         * A value that describes the current state of the table restore request.
         *
         * Valid Values: `SUCCEEDED`, `FAILED`, `CANCELED`, `PENDING`, `IN_PROGRESS`
         */
        public var status: aws.sdk.kotlin.services.redshift.model.TableRestoreStatusType? = null
        /**
         * The unique identifier for the table restore request.
         */
        public var tableRestoreRequestId: kotlin.String? = null
        /**
         * The name of the database to restore the table to.
         */
        public var targetDatabaseName: kotlin.String? = null
        /**
         * The name of the schema to restore the table to.
         */
        public var targetSchemaName: kotlin.String? = null
        /**
         * The total amount of data to restore to the new table, in megabytes (MB).
         */
        public var totalDataInMegaBytes: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.TableRestoreStatus) : this() {
            this.clusterIdentifier = x.clusterIdentifier
            this.message = x.message
            this.newTableName = x.newTableName
            this.progressInMegaBytes = x.progressInMegaBytes
            this.requestTime = x.requestTime
            this.snapshotIdentifier = x.snapshotIdentifier
            this.sourceDatabaseName = x.sourceDatabaseName
            this.sourceSchemaName = x.sourceSchemaName
            this.sourceTableName = x.sourceTableName
            this.status = x.status
            this.tableRestoreRequestId = x.tableRestoreRequestId
            this.targetDatabaseName = x.targetDatabaseName
            this.targetSchemaName = x.targetSchemaName
            this.totalDataInMegaBytes = x.totalDataInMegaBytes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.TableRestoreStatus = TableRestoreStatus(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
