// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a snapshot.
 */
public class Snapshot private constructor(builder: Builder) {
    /**
     * A list of the Amazon Web Services accounts authorized to restore the snapshot. Returns `null` if no accounts are authorized. Visible only to the snapshot owner.
     */
    public val accountsWithRestoreAccess: List<AccountWithRestoreAccess>? = builder.accountsWithRestoreAccess
    /**
     * The size of the incremental backup.
     */
    public val actualIncrementalBackupSizeInMegaBytes: kotlin.Double? = builder.actualIncrementalBackupSizeInMegaBytes
    /**
     * The Availability Zone in which the cluster was created.
     */
    public val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * The number of megabytes that have been transferred to the snapshot backup.
     */
    public val backupProgressInMegaBytes: kotlin.Double? = builder.backupProgressInMegaBytes
    /**
     * The time (UTC) when the cluster was originally created.
     */
    public val clusterCreateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.clusterCreateTime
    /**
     * The identifier of the cluster for which the snapshot was taken.
     */
    public val clusterIdentifier: kotlin.String? = builder.clusterIdentifier
    /**
     * The version ID of the Amazon Redshift engine that is running on the cluster.
     */
    public val clusterVersion: kotlin.String? = builder.clusterVersion
    /**
     * The number of megabytes per second being transferred to the snapshot backup. Returns `0` for a completed backup.
     */
    public val currentBackupRateInMegaBytesPerSecond: kotlin.Double? = builder.currentBackupRateInMegaBytesPerSecond
    /**
     * The name of the database that was created when the cluster was created.
     */
    public val dbName: kotlin.String? = builder.dbName
    /**
     * The amount of time an in-progress snapshot backup has been running, or the amount of time it took a completed backup to finish.
     */
    public val elapsedTimeInSeconds: kotlin.Long? = builder.elapsedTimeInSeconds
    /**
     * If `true`, the data in the snapshot is encrypted at rest.
     */
    public val encrypted: kotlin.Boolean? = builder.encrypted
    /**
     * A boolean that indicates whether the snapshot data is encrypted using the HSM keys of the source cluster. `true` indicates that the data is encrypted using HSM keys.
     */
    public val encryptedWithHsm: kotlin.Boolean? = builder.encryptedWithHsm
    /**
     * The cluster version of the cluster used to create the snapshot. For example, 1.0.15503.
     */
    public val engineFullVersion: kotlin.String? = builder.engineFullVersion
    /**
     * An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see [Enhanced VPC Routing](https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html) in the Amazon Redshift Cluster Management Guide.
     *
     * If this option is `true`, enhanced VPC routing is enabled.
     *
     * Default: false
     */
    public val enhancedVpcRouting: kotlin.Boolean? = builder.enhancedVpcRouting
    /**
     * The estimate of the time remaining before the snapshot backup will complete. Returns `0` for a completed backup.
     */
    public val estimatedSecondsToCompletion: kotlin.Long? = builder.estimatedSecondsToCompletion
    /**
     * The Key Management Service (KMS) key ID of the encryption key that was used to encrypt data in the cluster from which the snapshot was taken.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The name of the maintenance track for the snapshot.
     */
    public val maintenanceTrackName: kotlin.String? = builder.maintenanceTrackName
    /**
     * The number of days until a manual snapshot will pass its retention period.
     */
    public val manualSnapshotRemainingDays: kotlin.Int? = builder.manualSnapshotRemainingDays
    /**
     * The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is retained indefinitely.
     *
     * The value must be either -1 or an integer between 1 and 3,653.
     */
    public val manualSnapshotRetentionPeriod: kotlin.Int? = builder.manualSnapshotRetentionPeriod
    /**
     * The Amazon Resource Name (ARN) for the cluster's admin user credentials secret.
     */
    public val masterPasswordSecretArn: kotlin.String? = builder.masterPasswordSecretArn
    /**
     * The ID of the Key Management Service (KMS) key used to encrypt and store the cluster's admin credentials secret.
     */
    public val masterPasswordSecretKmsKeyId: kotlin.String? = builder.masterPasswordSecretKmsKeyId
    /**
     * The admin user name for the cluster.
     */
    public val masterUsername: kotlin.String? = builder.masterUsername
    /**
     * The node type of the nodes in the cluster.
     */
    public val nodeType: kotlin.String? = builder.nodeType
    /**
     * The number of nodes in the cluster.
     */
    public val numberOfNodes: kotlin.Int? = builder.numberOfNodes
    /**
     * For manual snapshots, the Amazon Web Services account used to create or copy the snapshot. For automatic snapshots, the owner of the cluster. The owner can perform all snapshot actions, such as sharing a manual snapshot.
     */
    public val ownerAccount: kotlin.String? = builder.ownerAccount
    /**
     * The port that the cluster is listening on.
     */
    public val port: kotlin.Int? = builder.port
    /**
     * The list of node types that this cluster snapshot is able to restore into.
     */
    public val restorableNodeTypes: List<String>? = builder.restorableNodeTypes
    /**
     * The time (in UTC format) when Amazon Redshift began the snapshot. A snapshot contains a copy of the cluster data as of this exact time.
     */
    public val snapshotCreateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.snapshotCreateTime
    /**
     * The snapshot identifier that is provided in the request.
     */
    public val snapshotIdentifier: kotlin.String? = builder.snapshotIdentifier
    /**
     * A timestamp representing the start of the retention period for the snapshot.
     */
    public val snapshotRetentionStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.snapshotRetentionStartTime
    /**
     * The snapshot type. Snapshots created using CreateClusterSnapshot and CopyClusterSnapshot are of type "manual".
     */
    public val snapshotType: kotlin.String? = builder.snapshotType
    /**
     * The source region from which the snapshot was copied.
     */
    public val sourceRegion: kotlin.String? = builder.sourceRegion
    /**
     * The snapshot status. The value of the status depends on the API operation used:
     * + CreateClusterSnapshot and CopyClusterSnapshot returns status as "creating".
     * + DescribeClusterSnapshots returns status as "creating", "available", "final snapshot", or "failed".
     * + DeleteClusterSnapshot returns status as "deleted".
     */
    public val status: kotlin.String? = builder.status
    /**
     * The list of tags for the cluster snapshot.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The size of the complete set of backup data that would be used to restore the cluster.
     */
    public val totalBackupSizeInMegaBytes: kotlin.Double? = builder.totalBackupSizeInMegaBytes
    /**
     * The VPC identifier of the cluster if the snapshot is from a cluster in a VPC. Otherwise, this field is not in the output.
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.Snapshot = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Snapshot(")
        append("accountsWithRestoreAccess=$accountsWithRestoreAccess,")
        append("actualIncrementalBackupSizeInMegaBytes=$actualIncrementalBackupSizeInMegaBytes,")
        append("availabilityZone=$availabilityZone,")
        append("backupProgressInMegaBytes=$backupProgressInMegaBytes,")
        append("clusterCreateTime=$clusterCreateTime,")
        append("clusterIdentifier=$clusterIdentifier,")
        append("clusterVersion=$clusterVersion,")
        append("currentBackupRateInMegaBytesPerSecond=$currentBackupRateInMegaBytesPerSecond,")
        append("dbName=$dbName,")
        append("elapsedTimeInSeconds=$elapsedTimeInSeconds,")
        append("encrypted=$encrypted,")
        append("encryptedWithHsm=$encryptedWithHsm,")
        append("engineFullVersion=$engineFullVersion,")
        append("enhancedVpcRouting=$enhancedVpcRouting,")
        append("estimatedSecondsToCompletion=$estimatedSecondsToCompletion,")
        append("kmsKeyId=$kmsKeyId,")
        append("maintenanceTrackName=$maintenanceTrackName,")
        append("manualSnapshotRemainingDays=$manualSnapshotRemainingDays,")
        append("manualSnapshotRetentionPeriod=$manualSnapshotRetentionPeriod,")
        append("masterPasswordSecretArn=$masterPasswordSecretArn,")
        append("masterPasswordSecretKmsKeyId=$masterPasswordSecretKmsKeyId,")
        append("masterUsername=$masterUsername,")
        append("nodeType=$nodeType,")
        append("numberOfNodes=$numberOfNodes,")
        append("ownerAccount=$ownerAccount,")
        append("port=$port,")
        append("restorableNodeTypes=$restorableNodeTypes,")
        append("snapshotCreateTime=$snapshotCreateTime,")
        append("snapshotIdentifier=$snapshotIdentifier,")
        append("snapshotRetentionStartTime=$snapshotRetentionStartTime,")
        append("snapshotType=$snapshotType,")
        append("sourceRegion=$sourceRegion,")
        append("status=$status,")
        append("tags=$tags,")
        append("totalBackupSizeInMegaBytes=$totalBackupSizeInMegaBytes,")
        append("vpcId=$vpcId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountsWithRestoreAccess?.hashCode() ?: 0
        result = 31 * result + (actualIncrementalBackupSizeInMegaBytes?.hashCode() ?: 0)
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (backupProgressInMegaBytes?.hashCode() ?: 0)
        result = 31 * result + (clusterCreateTime?.hashCode() ?: 0)
        result = 31 * result + (clusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (clusterVersion?.hashCode() ?: 0)
        result = 31 * result + (currentBackupRateInMegaBytesPerSecond?.hashCode() ?: 0)
        result = 31 * result + (dbName?.hashCode() ?: 0)
        result = 31 * result + (elapsedTimeInSeconds?.hashCode() ?: 0)
        result = 31 * result + (encrypted?.hashCode() ?: 0)
        result = 31 * result + (encryptedWithHsm?.hashCode() ?: 0)
        result = 31 * result + (engineFullVersion?.hashCode() ?: 0)
        result = 31 * result + (enhancedVpcRouting?.hashCode() ?: 0)
        result = 31 * result + (estimatedSecondsToCompletion?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (maintenanceTrackName?.hashCode() ?: 0)
        result = 31 * result + (manualSnapshotRemainingDays ?: 0)
        result = 31 * result + (manualSnapshotRetentionPeriod ?: 0)
        result = 31 * result + (masterPasswordSecretArn?.hashCode() ?: 0)
        result = 31 * result + (masterPasswordSecretKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (masterUsername?.hashCode() ?: 0)
        result = 31 * result + (nodeType?.hashCode() ?: 0)
        result = 31 * result + (numberOfNodes ?: 0)
        result = 31 * result + (ownerAccount?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (restorableNodeTypes?.hashCode() ?: 0)
        result = 31 * result + (snapshotCreateTime?.hashCode() ?: 0)
        result = 31 * result + (snapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (snapshotRetentionStartTime?.hashCode() ?: 0)
        result = 31 * result + (snapshotType?.hashCode() ?: 0)
        result = 31 * result + (sourceRegion?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (totalBackupSizeInMegaBytes?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Snapshot

        if (accountsWithRestoreAccess != other.accountsWithRestoreAccess) return false
        if (actualIncrementalBackupSizeInMegaBytes != other.actualIncrementalBackupSizeInMegaBytes) return false
        if (availabilityZone != other.availabilityZone) return false
        if (backupProgressInMegaBytes != other.backupProgressInMegaBytes) return false
        if (clusterCreateTime != other.clusterCreateTime) return false
        if (clusterIdentifier != other.clusterIdentifier) return false
        if (clusterVersion != other.clusterVersion) return false
        if (currentBackupRateInMegaBytesPerSecond != other.currentBackupRateInMegaBytesPerSecond) return false
        if (dbName != other.dbName) return false
        if (elapsedTimeInSeconds != other.elapsedTimeInSeconds) return false
        if (encrypted != other.encrypted) return false
        if (encryptedWithHsm != other.encryptedWithHsm) return false
        if (engineFullVersion != other.engineFullVersion) return false
        if (enhancedVpcRouting != other.enhancedVpcRouting) return false
        if (estimatedSecondsToCompletion != other.estimatedSecondsToCompletion) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (maintenanceTrackName != other.maintenanceTrackName) return false
        if (manualSnapshotRemainingDays != other.manualSnapshotRemainingDays) return false
        if (manualSnapshotRetentionPeriod != other.manualSnapshotRetentionPeriod) return false
        if (masterPasswordSecretArn != other.masterPasswordSecretArn) return false
        if (masterPasswordSecretKmsKeyId != other.masterPasswordSecretKmsKeyId) return false
        if (masterUsername != other.masterUsername) return false
        if (nodeType != other.nodeType) return false
        if (numberOfNodes != other.numberOfNodes) return false
        if (ownerAccount != other.ownerAccount) return false
        if (port != other.port) return false
        if (restorableNodeTypes != other.restorableNodeTypes) return false
        if (snapshotCreateTime != other.snapshotCreateTime) return false
        if (snapshotIdentifier != other.snapshotIdentifier) return false
        if (snapshotRetentionStartTime != other.snapshotRetentionStartTime) return false
        if (snapshotType != other.snapshotType) return false
        if (sourceRegion != other.sourceRegion) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (totalBackupSizeInMegaBytes != other.totalBackupSizeInMegaBytes) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.Snapshot = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of the Amazon Web Services accounts authorized to restore the snapshot. Returns `null` if no accounts are authorized. Visible only to the snapshot owner.
         */
        public var accountsWithRestoreAccess: List<AccountWithRestoreAccess>? = null
        /**
         * The size of the incremental backup.
         */
        public var actualIncrementalBackupSizeInMegaBytes: kotlin.Double? = null
        /**
         * The Availability Zone in which the cluster was created.
         */
        public var availabilityZone: kotlin.String? = null
        /**
         * The number of megabytes that have been transferred to the snapshot backup.
         */
        public var backupProgressInMegaBytes: kotlin.Double? = null
        /**
         * The time (UTC) when the cluster was originally created.
         */
        public var clusterCreateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The identifier of the cluster for which the snapshot was taken.
         */
        public var clusterIdentifier: kotlin.String? = null
        /**
         * The version ID of the Amazon Redshift engine that is running on the cluster.
         */
        public var clusterVersion: kotlin.String? = null
        /**
         * The number of megabytes per second being transferred to the snapshot backup. Returns `0` for a completed backup.
         */
        public var currentBackupRateInMegaBytesPerSecond: kotlin.Double? = null
        /**
         * The name of the database that was created when the cluster was created.
         */
        public var dbName: kotlin.String? = null
        /**
         * The amount of time an in-progress snapshot backup has been running, or the amount of time it took a completed backup to finish.
         */
        public var elapsedTimeInSeconds: kotlin.Long? = null
        /**
         * If `true`, the data in the snapshot is encrypted at rest.
         */
        public var encrypted: kotlin.Boolean? = null
        /**
         * A boolean that indicates whether the snapshot data is encrypted using the HSM keys of the source cluster. `true` indicates that the data is encrypted using HSM keys.
         */
        public var encryptedWithHsm: kotlin.Boolean? = null
        /**
         * The cluster version of the cluster used to create the snapshot. For example, 1.0.15503.
         */
        public var engineFullVersion: kotlin.String? = null
        /**
         * An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see [Enhanced VPC Routing](https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html) in the Amazon Redshift Cluster Management Guide.
         *
         * If this option is `true`, enhanced VPC routing is enabled.
         *
         * Default: false
         */
        public var enhancedVpcRouting: kotlin.Boolean? = null
        /**
         * The estimate of the time remaining before the snapshot backup will complete. Returns `0` for a completed backup.
         */
        public var estimatedSecondsToCompletion: kotlin.Long? = null
        /**
         * The Key Management Service (KMS) key ID of the encryption key that was used to encrypt data in the cluster from which the snapshot was taken.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The name of the maintenance track for the snapshot.
         */
        public var maintenanceTrackName: kotlin.String? = null
        /**
         * The number of days until a manual snapshot will pass its retention period.
         */
        public var manualSnapshotRemainingDays: kotlin.Int? = null
        /**
         * The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is retained indefinitely.
         *
         * The value must be either -1 or an integer between 1 and 3,653.
         */
        public var manualSnapshotRetentionPeriod: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) for the cluster's admin user credentials secret.
         */
        public var masterPasswordSecretArn: kotlin.String? = null
        /**
         * The ID of the Key Management Service (KMS) key used to encrypt and store the cluster's admin credentials secret.
         */
        public var masterPasswordSecretKmsKeyId: kotlin.String? = null
        /**
         * The admin user name for the cluster.
         */
        public var masterUsername: kotlin.String? = null
        /**
         * The node type of the nodes in the cluster.
         */
        public var nodeType: kotlin.String? = null
        /**
         * The number of nodes in the cluster.
         */
        public var numberOfNodes: kotlin.Int? = null
        /**
         * For manual snapshots, the Amazon Web Services account used to create or copy the snapshot. For automatic snapshots, the owner of the cluster. The owner can perform all snapshot actions, such as sharing a manual snapshot.
         */
        public var ownerAccount: kotlin.String? = null
        /**
         * The port that the cluster is listening on.
         */
        public var port: kotlin.Int? = null
        /**
         * The list of node types that this cluster snapshot is able to restore into.
         */
        public var restorableNodeTypes: List<String>? = null
        /**
         * The time (in UTC format) when Amazon Redshift began the snapshot. A snapshot contains a copy of the cluster data as of this exact time.
         */
        public var snapshotCreateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The snapshot identifier that is provided in the request.
         */
        public var snapshotIdentifier: kotlin.String? = null
        /**
         * A timestamp representing the start of the retention period for the snapshot.
         */
        public var snapshotRetentionStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The snapshot type. Snapshots created using CreateClusterSnapshot and CopyClusterSnapshot are of type "manual".
         */
        public var snapshotType: kotlin.String? = null
        /**
         * The source region from which the snapshot was copied.
         */
        public var sourceRegion: kotlin.String? = null
        /**
         * The snapshot status. The value of the status depends on the API operation used:
         * + CreateClusterSnapshot and CopyClusterSnapshot returns status as "creating".
         * + DescribeClusterSnapshots returns status as "creating", "available", "final snapshot", or "failed".
         * + DeleteClusterSnapshot returns status as "deleted".
         */
        public var status: kotlin.String? = null
        /**
         * The list of tags for the cluster snapshot.
         */
        public var tags: List<Tag>? = null
        /**
         * The size of the complete set of backup data that would be used to restore the cluster.
         */
        public var totalBackupSizeInMegaBytes: kotlin.Double? = null
        /**
         * The VPC identifier of the cluster if the snapshot is from a cluster in a VPC. Otherwise, this field is not in the output.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.Snapshot) : this() {
            this.accountsWithRestoreAccess = x.accountsWithRestoreAccess
            this.actualIncrementalBackupSizeInMegaBytes = x.actualIncrementalBackupSizeInMegaBytes
            this.availabilityZone = x.availabilityZone
            this.backupProgressInMegaBytes = x.backupProgressInMegaBytes
            this.clusterCreateTime = x.clusterCreateTime
            this.clusterIdentifier = x.clusterIdentifier
            this.clusterVersion = x.clusterVersion
            this.currentBackupRateInMegaBytesPerSecond = x.currentBackupRateInMegaBytesPerSecond
            this.dbName = x.dbName
            this.elapsedTimeInSeconds = x.elapsedTimeInSeconds
            this.encrypted = x.encrypted
            this.encryptedWithHsm = x.encryptedWithHsm
            this.engineFullVersion = x.engineFullVersion
            this.enhancedVpcRouting = x.enhancedVpcRouting
            this.estimatedSecondsToCompletion = x.estimatedSecondsToCompletion
            this.kmsKeyId = x.kmsKeyId
            this.maintenanceTrackName = x.maintenanceTrackName
            this.manualSnapshotRemainingDays = x.manualSnapshotRemainingDays
            this.manualSnapshotRetentionPeriod = x.manualSnapshotRetentionPeriod
            this.masterPasswordSecretArn = x.masterPasswordSecretArn
            this.masterPasswordSecretKmsKeyId = x.masterPasswordSecretKmsKeyId
            this.masterUsername = x.masterUsername
            this.nodeType = x.nodeType
            this.numberOfNodes = x.numberOfNodes
            this.ownerAccount = x.ownerAccount
            this.port = x.port
            this.restorableNodeTypes = x.restorableNodeTypes
            this.snapshotCreateTime = x.snapshotCreateTime
            this.snapshotIdentifier = x.snapshotIdentifier
            this.snapshotRetentionStartTime = x.snapshotRetentionStartTime
            this.snapshotType = x.snapshotType
            this.sourceRegion = x.sourceRegion
            this.status = x.status
            this.tags = x.tags
            this.totalBackupSizeInMegaBytes = x.totalBackupSizeInMegaBytes
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.Snapshot = Snapshot(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
