// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 * Describes cluster attributes that are in a pending state. A change to one or more the attributes was requested and is in progress or will be applied.
 */
public class PendingModifiedValues private constructor(builder: Builder) {
    /**
     * The pending or in-progress change of the automated snapshot retention period.
     */
    public val automatedSnapshotRetentionPeriod: kotlin.Int? = builder.automatedSnapshotRetentionPeriod
    /**
     * The pending or in-progress change of the new identifier for the cluster.
     */
    public val clusterIdentifier: kotlin.String? = builder.clusterIdentifier
    /**
     * The pending or in-progress change of the cluster type.
     */
    public val clusterType: kotlin.String? = builder.clusterType
    /**
     * The pending or in-progress change of the service version.
     */
    public val clusterVersion: kotlin.String? = builder.clusterVersion
    /**
     * The encryption type for a cluster. Possible values are: KMS and None.
     */
    public val encryptionType: kotlin.String? = builder.encryptionType
    /**
     * An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see [Enhanced VPC Routing](https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html) in the Amazon Redshift Cluster Management Guide.
     *
     * If this option is `true`, enhanced VPC routing is enabled.
     *
     * Default: false
     */
    public val enhancedVpcRouting: kotlin.Boolean? = builder.enhancedVpcRouting
    /**
     * The name of the maintenance track that the cluster will change to during the next maintenance window.
     */
    public val maintenanceTrackName: kotlin.String? = builder.maintenanceTrackName
    /**
     * The pending or in-progress change of the admin user password for the cluster.
     */
    public val masterUserPassword: kotlin.String? = builder.masterUserPassword
    /**
     * The pending or in-progress change of the cluster's node type.
     */
    public val nodeType: kotlin.String? = builder.nodeType
    /**
     * The pending or in-progress change of the number of nodes in the cluster.
     */
    public val numberOfNodes: kotlin.Int? = builder.numberOfNodes
    /**
     * The pending or in-progress change of the ability to connect to the cluster from the public network.
     */
    public val publiclyAccessible: kotlin.Boolean? = builder.publiclyAccessible

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.PendingModifiedValues = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PendingModifiedValues(")
        append("automatedSnapshotRetentionPeriod=$automatedSnapshotRetentionPeriod,")
        append("clusterIdentifier=$clusterIdentifier,")
        append("clusterType=$clusterType,")
        append("clusterVersion=$clusterVersion,")
        append("encryptionType=$encryptionType,")
        append("enhancedVpcRouting=$enhancedVpcRouting,")
        append("maintenanceTrackName=$maintenanceTrackName,")
        append("masterUserPassword=*** Sensitive Data Redacted ***,")
        append("nodeType=$nodeType,")
        append("numberOfNodes=$numberOfNodes,")
        append("publiclyAccessible=$publiclyAccessible")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = automatedSnapshotRetentionPeriod ?: 0
        result = 31 * result + (clusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (clusterType?.hashCode() ?: 0)
        result = 31 * result + (clusterVersion?.hashCode() ?: 0)
        result = 31 * result + (encryptionType?.hashCode() ?: 0)
        result = 31 * result + (enhancedVpcRouting?.hashCode() ?: 0)
        result = 31 * result + (maintenanceTrackName?.hashCode() ?: 0)
        result = 31 * result + (masterUserPassword?.hashCode() ?: 0)
        result = 31 * result + (nodeType?.hashCode() ?: 0)
        result = 31 * result + (numberOfNodes ?: 0)
        result = 31 * result + (publiclyAccessible?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PendingModifiedValues

        if (automatedSnapshotRetentionPeriod != other.automatedSnapshotRetentionPeriod) return false
        if (clusterIdentifier != other.clusterIdentifier) return false
        if (clusterType != other.clusterType) return false
        if (clusterVersion != other.clusterVersion) return false
        if (encryptionType != other.encryptionType) return false
        if (enhancedVpcRouting != other.enhancedVpcRouting) return false
        if (maintenanceTrackName != other.maintenanceTrackName) return false
        if (masterUserPassword != other.masterUserPassword) return false
        if (nodeType != other.nodeType) return false
        if (numberOfNodes != other.numberOfNodes) return false
        if (publiclyAccessible != other.publiclyAccessible) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.PendingModifiedValues = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The pending or in-progress change of the automated snapshot retention period.
         */
        public var automatedSnapshotRetentionPeriod: kotlin.Int? = null
        /**
         * The pending or in-progress change of the new identifier for the cluster.
         */
        public var clusterIdentifier: kotlin.String? = null
        /**
         * The pending or in-progress change of the cluster type.
         */
        public var clusterType: kotlin.String? = null
        /**
         * The pending or in-progress change of the service version.
         */
        public var clusterVersion: kotlin.String? = null
        /**
         * The encryption type for a cluster. Possible values are: KMS and None.
         */
        public var encryptionType: kotlin.String? = null
        /**
         * An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see [Enhanced VPC Routing](https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html) in the Amazon Redshift Cluster Management Guide.
         *
         * If this option is `true`, enhanced VPC routing is enabled.
         *
         * Default: false
         */
        public var enhancedVpcRouting: kotlin.Boolean? = null
        /**
         * The name of the maintenance track that the cluster will change to during the next maintenance window.
         */
        public var maintenanceTrackName: kotlin.String? = null
        /**
         * The pending or in-progress change of the admin user password for the cluster.
         */
        public var masterUserPassword: kotlin.String? = null
        /**
         * The pending or in-progress change of the cluster's node type.
         */
        public var nodeType: kotlin.String? = null
        /**
         * The pending or in-progress change of the number of nodes in the cluster.
         */
        public var numberOfNodes: kotlin.Int? = null
        /**
         * The pending or in-progress change of the ability to connect to the cluster from the public network.
         */
        public var publiclyAccessible: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.PendingModifiedValues) : this() {
            this.automatedSnapshotRetentionPeriod = x.automatedSnapshotRetentionPeriod
            this.clusterIdentifier = x.clusterIdentifier
            this.clusterType = x.clusterType
            this.clusterVersion = x.clusterVersion
            this.encryptionType = x.encryptionType
            this.enhancedVpcRouting = x.enhancedVpcRouting
            this.maintenanceTrackName = x.maintenanceTrackName
            this.masterUserPassword = x.masterUserPassword
            this.nodeType = x.nodeType
            this.numberOfNodes = x.numberOfNodes
            this.publiclyAccessible = x.publiclyAccessible
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.PendingModifiedValues = PendingModifiedValues(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
