// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Temporary credentials with authorization to log on to an Amazon Redshift database.
 */
public class GetClusterCredentialsResponse private constructor(builder: Builder) {
    /**
     * A temporary password that authorizes the user name returned by `DbUser` to log on to the database `DbName`.
     */
    public val dbPassword: kotlin.String? = builder.dbPassword
    /**
     * A database user name that is authorized to log on to the database `DbName` using the password `DbPassword`. If the specified DbUser exists in the database, the new user name has the same database permissions as the the user named in DbUser. By default, the user is added to PUBLIC. If the `DbGroups` parameter is specifed, `DbUser` is added to the listed groups for any sessions created using these credentials.
     */
    public val dbUser: kotlin.String? = builder.dbUser
    /**
     * The date and time the password in `DbPassword` expires.
     */
    public val expiration: aws.smithy.kotlin.runtime.time.Instant? = builder.expiration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.GetClusterCredentialsResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetClusterCredentialsResponse(")
        append("dbPassword=*** Sensitive Data Redacted ***,")
        append("dbUser=$dbUser,")
        append("expiration=$expiration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbPassword?.hashCode() ?: 0
        result = 31 * result + (dbUser?.hashCode() ?: 0)
        result = 31 * result + (expiration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetClusterCredentialsResponse

        if (dbPassword != other.dbPassword) return false
        if (dbUser != other.dbUser) return false
        if (expiration != other.expiration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.GetClusterCredentialsResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A temporary password that authorizes the user name returned by `DbUser` to log on to the database `DbName`.
         */
        public var dbPassword: kotlin.String? = null
        /**
         * A database user name that is authorized to log on to the database `DbName` using the password `DbPassword`. If the specified DbUser exists in the database, the new user name has the same database permissions as the the user named in DbUser. By default, the user is added to PUBLIC. If the `DbGroups` parameter is specifed, `DbUser` is added to the listed groups for any sessions created using these credentials.
         */
        public var dbUser: kotlin.String? = null
        /**
         * The date and time the password in `DbPassword` expires.
         */
        public var expiration: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.GetClusterCredentialsResponse) : this() {
            this.dbPassword = x.dbPassword
            this.dbUser = x.dbUser
            this.expiration = x.expiration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.GetClusterCredentialsResponse = GetClusterCredentialsResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
