// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



public class CreateEndpointAccessRequest private constructor(builder: Builder) {
    /**
     * The cluster identifier of the cluster to access.
     */
    public val clusterIdentifier: kotlin.String? = builder.clusterIdentifier
    /**
     * The Redshift-managed VPC endpoint name.
     *
     * An endpoint name must contain 1-30 characters. Valid characters are A-Z, a-z, 0-9, and hyphen(-). The first character must be a letter. The name can't contain two consecutive hyphens or end with a hyphen.
     */
    public val endpointName: kotlin.String? = builder.endpointName
    /**
     * The Amazon Web Services account ID of the owner of the cluster. This is only required if the cluster is in another Amazon Web Services account.
     */
    public val resourceOwner: kotlin.String? = builder.resourceOwner
    /**
     * The subnet group from which Amazon Redshift chooses the subnet to deploy the endpoint.
     */
    public val subnetGroupName: kotlin.String? = builder.subnetGroupName
    /**
     * The security group that defines the ports, protocols, and sources for inbound traffic that you are authorizing into your endpoint.
     */
    public val vpcSecurityGroupIds: List<String>? = builder.vpcSecurityGroupIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.CreateEndpointAccessRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateEndpointAccessRequest(")
        append("clusterIdentifier=$clusterIdentifier,")
        append("endpointName=$endpointName,")
        append("resourceOwner=$resourceOwner,")
        append("subnetGroupName=$subnetGroupName,")
        append("vpcSecurityGroupIds=$vpcSecurityGroupIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterIdentifier?.hashCode() ?: 0
        result = 31 * result + (endpointName?.hashCode() ?: 0)
        result = 31 * result + (resourceOwner?.hashCode() ?: 0)
        result = 31 * result + (subnetGroupName?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroupIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateEndpointAccessRequest

        if (clusterIdentifier != other.clusterIdentifier) return false
        if (endpointName != other.endpointName) return false
        if (resourceOwner != other.resourceOwner) return false
        if (subnetGroupName != other.subnetGroupName) return false
        if (vpcSecurityGroupIds != other.vpcSecurityGroupIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.CreateEndpointAccessRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The cluster identifier of the cluster to access.
         */
        public var clusterIdentifier: kotlin.String? = null
        /**
         * The Redshift-managed VPC endpoint name.
         *
         * An endpoint name must contain 1-30 characters. Valid characters are A-Z, a-z, 0-9, and hyphen(-). The first character must be a letter. The name can't contain two consecutive hyphens or end with a hyphen.
         */
        public var endpointName: kotlin.String? = null
        /**
         * The Amazon Web Services account ID of the owner of the cluster. This is only required if the cluster is in another Amazon Web Services account.
         */
        public var resourceOwner: kotlin.String? = null
        /**
         * The subnet group from which Amazon Redshift chooses the subnet to deploy the endpoint.
         */
        public var subnetGroupName: kotlin.String? = null
        /**
         * The security group that defines the ports, protocols, and sources for inbound traffic that you are authorizing into your endpoint.
         */
        public var vpcSecurityGroupIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.CreateEndpointAccessRequest) : this() {
            this.clusterIdentifier = x.clusterIdentifier
            this.endpointName = x.endpointName
            this.resourceOwner = x.resourceOwner
            this.subnetGroupName = x.subnetGroupName
            this.vpcSecurityGroupIds = x.vpcSecurityGroupIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.CreateEndpointAccessRequest = CreateEndpointAccessRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
