// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 *
 */
public class CreateClusterSnapshotRequest private constructor(builder: Builder) {
    /**
     * The cluster identifier for which you want a snapshot.
     */
    public val clusterIdentifier: kotlin.String? = builder.clusterIdentifier
    /**
     * The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is retained indefinitely.
     *
     * The value must be either -1 or an integer between 1 and 3,653.
     *
     * The default value is -1.
     */
    public val manualSnapshotRetentionPeriod: kotlin.Int? = builder.manualSnapshotRetentionPeriod
    /**
     * A unique identifier for the snapshot that you are requesting. This identifier must be unique for all snapshots within the Amazon Web Services account.
     *
     * Constraints:
     * + Cannot be null, empty, or blank
     * + Must contain from 1 to 255 alphanumeric characters or hyphens
     * + First character must be a letter
     * + Cannot end with a hyphen or contain two consecutive hyphens
     *
     * Example: `my-snapshot-id`
     */
    public val snapshotIdentifier: kotlin.String? = builder.snapshotIdentifier
    /**
     * A list of tag instances.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.CreateClusterSnapshotRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateClusterSnapshotRequest(")
        append("clusterIdentifier=$clusterIdentifier,")
        append("manualSnapshotRetentionPeriod=$manualSnapshotRetentionPeriod,")
        append("snapshotIdentifier=$snapshotIdentifier,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterIdentifier?.hashCode() ?: 0
        result = 31 * result + (manualSnapshotRetentionPeriod ?: 0)
        result = 31 * result + (snapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateClusterSnapshotRequest

        if (clusterIdentifier != other.clusterIdentifier) return false
        if (manualSnapshotRetentionPeriod != other.manualSnapshotRetentionPeriod) return false
        if (snapshotIdentifier != other.snapshotIdentifier) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.CreateClusterSnapshotRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The cluster identifier for which you want a snapshot.
         */
        public var clusterIdentifier: kotlin.String? = null
        /**
         * The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is retained indefinitely.
         *
         * The value must be either -1 or an integer between 1 and 3,653.
         *
         * The default value is -1.
         */
        public var manualSnapshotRetentionPeriod: kotlin.Int? = null
        /**
         * A unique identifier for the snapshot that you are requesting. This identifier must be unique for all snapshots within the Amazon Web Services account.
         *
         * Constraints:
         * + Cannot be null, empty, or blank
         * + Must contain from 1 to 255 alphanumeric characters or hyphens
         * + First character must be a letter
         * + Cannot end with a hyphen or contain two consecutive hyphens
         *
         * Example: `my-snapshot-id`
         */
        public var snapshotIdentifier: kotlin.String? = null
        /**
         * A list of tag instances.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.CreateClusterSnapshotRequest) : this() {
            this.clusterIdentifier = x.clusterIdentifier
            this.manualSnapshotRetentionPeriod = x.manualSnapshotRetentionPeriod
            this.snapshotIdentifier = x.snapshotIdentifier
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.CreateClusterSnapshotRequest = CreateClusterSnapshotRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
