// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.serde

import aws.sdk.kotlin.services.redshift.model.ModifyCustomDomainAssociationResponse
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class ModifyCustomDomainAssociationOperationDeserializer: HttpDeserialize<ModifyCustomDomainAssociationResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): ModifyCustomDomainAssociationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwModifyCustomDomainAssociationError(context, call)
        }
        val builder = ModifyCustomDomainAssociationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeModifyCustomDomainAssociationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwModifyCustomDomainAssociationError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "UnsupportedOperation" -> UnsupportedOperationFaultDeserializer().deserialize(context, wrappedCall)
        "CustomDomainAssociationNotFoundFault" -> CustomDomainAssociationNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "ClusterNotFound" -> ClusterNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "CustomCnameAssociationFault" -> CustomCnameAssociationFaultDeserializer().deserialize(context, wrappedCall)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeModifyCustomDomainAssociationOperationBody(builder: ModifyCustomDomainAssociationResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("ModifyCustomDomainAssociationResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("ModifyCustomDomainAssociationResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap ModifyCustomDomainAssociation response")
    }
    // end unwrap response wrapper

    val CLUSTERIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("ClusterIdentifier"))
    val CUSTOMDOMAINCERTEXPIRYTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("CustomDomainCertExpiryTime"))
    val CUSTOMDOMAINCERTIFICATEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("CustomDomainCertificateArn"))
    val CUSTOMDOMAINNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("CustomDomainName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://redshift.amazonaws.com/doc/2012-12-01/"))
        trait(XmlSerialName("ModifyCustomDomainAssociationResult"))
        field(CLUSTERIDENTIFIER_DESCRIPTOR)
        field(CUSTOMDOMAINCERTEXPIRYTIME_DESCRIPTOR)
        field(CUSTOMDOMAINCERTIFICATEARN_DESCRIPTOR)
        field(CUSTOMDOMAINNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CLUSTERIDENTIFIER_DESCRIPTOR.index -> builder.clusterIdentifier = deserializeString()
                CUSTOMDOMAINCERTEXPIRYTIME_DESCRIPTOR.index -> builder.customDomainCertExpiryTime = deserializeString()
                CUSTOMDOMAINCERTIFICATEARN_DESCRIPTOR.index -> builder.customDomainCertificateArn = deserializeString()
                CUSTOMDOMAINNAME_DESCRIPTOR.index -> builder.customDomainName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
