// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.serde

import aws.sdk.kotlin.services.redshift.model.Cluster
import aws.sdk.kotlin.services.redshift.model.CreateClusterResponse
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class CreateClusterOperationDeserializer: HttpDeserialize<CreateClusterResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateClusterResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateClusterError(context, call)
        }
        val builder = CreateClusterResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateClusterOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateClusterError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ClusterQuotaExceeded" -> ClusterQuotaExceededFaultDeserializer().deserialize(context, wrappedCall)
        "HsmConfigurationNotFoundFault" -> HsmConfigurationNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "NumberOfNodesQuotaExceeded" -> NumberOfNodesQuotaExceededFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidSubnet" -> InvalidSubnetDeserializer().deserialize(context, wrappedCall)
        "UnauthorizedOperation" -> UnauthorizedOperationDeserializer().deserialize(context, wrappedCall)
        "LimitExceededFault" -> LimitExceededFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidTagFault" -> InvalidTagFaultDeserializer().deserialize(context, wrappedCall)
        "HsmClientCertificateNotFoundFault" -> HsmClientCertificateNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidClusterSubnetGroupStateFault" -> InvalidClusterSubnetGroupStateFaultDeserializer().deserialize(context, wrappedCall)
        "TagLimitExceededFault" -> TagLimitExceededFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidVPCNetworkStateFault" -> InvalidVpcNetworkStateFaultDeserializer().deserialize(context, wrappedCall)
        "ClusterSecurityGroupNotFound" -> ClusterSecurityGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "DependentServiceRequestThrottlingFault" -> DependentServiceRequestThrottlingFaultDeserializer().deserialize(context, wrappedCall)
        "ClusterAlreadyExists" -> ClusterAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall)
        "ClusterParameterGroupNotFound" -> ClusterParameterGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "ClusterSubnetGroupNotFoundFault" -> ClusterSubnetGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "Ipv6CidrBlockNotFoundFault" -> Ipv6CidrBlockNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "RedshiftIdcApplicationNotExists" -> RedshiftIdcApplicationNotExistsFaultDeserializer().deserialize(context, wrappedCall)
        "InsufficientClusterCapacity" -> InsufficientClusterCapacityFaultDeserializer().deserialize(context, wrappedCall)
        "UnsupportedOperation" -> UnsupportedOperationFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidClusterTrack" -> InvalidClusterTrackFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidElasticIpFault" -> InvalidElasticIpFaultDeserializer().deserialize(context, wrappedCall)
        "SnapshotScheduleNotFound" -> SnapshotScheduleNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidRetentionPeriodFault" -> InvalidRetentionPeriodFaultDeserializer().deserialize(context, wrappedCall)
        "NumberOfNodesPerClusterLimitExceeded" -> NumberOfNodesPerClusterLimitExceededFaultDeserializer().deserialize(context, wrappedCall)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateClusterOperationBody(builder: CreateClusterResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("CreateClusterResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("CreateClusterResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap CreateCluster response")
    }
    // end unwrap response wrapper

    val CLUSTER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("Cluster"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://redshift.amazonaws.com/doc/2012-12-01/"))
        trait(XmlSerialName("CreateClusterResult"))
        field(CLUSTER_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CLUSTER_DESCRIPTOR.index -> builder.cluster = deserializeClusterDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
