// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.serde

import aws.sdk.kotlin.services.redshift.model.AuthorizationStatus
import aws.sdk.kotlin.services.redshift.model.AuthorizeEndpointAccessResponse
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlCollectionName
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class AuthorizeEndpointAccessOperationDeserializer: HttpDeserialize<AuthorizeEndpointAccessResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): AuthorizeEndpointAccessResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwAuthorizeEndpointAccessError(context, call)
        }
        val builder = AuthorizeEndpointAccessResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeAuthorizeEndpointAccessOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwAuthorizeEndpointAccessError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "UnsupportedOperation" -> UnsupportedOperationFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidClusterState" -> InvalidClusterStateFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidAuthorizationState" -> InvalidAuthorizationStateFaultDeserializer().deserialize(context, wrappedCall)
        "EndpointAuthorizationsPerClusterLimitExceeded" -> EndpointAuthorizationsPerClusterLimitExceededFaultDeserializer().deserialize(context, wrappedCall)
        "ClusterNotFound" -> ClusterNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "EndpointAuthorizationAlreadyExists" -> EndpointAuthorizationAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeAuthorizeEndpointAccessOperationBody(builder: AuthorizeEndpointAccessResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("AuthorizeEndpointAccessResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("AuthorizeEndpointAccessResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap AuthorizeEndpointAccess response")
    }
    // end unwrap response wrapper

    val ALLOWEDALLVPCS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, XmlSerialName("AllowedAllVPCs"))
    val ALLOWEDVPCS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("AllowedVPCs"), XmlCollectionName("VpcIdentifier"))
    val AUTHORIZETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, XmlSerialName("AuthorizeTime"))
    val CLUSTERIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("ClusterIdentifier"))
    val CLUSTERSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("ClusterStatus"))
    val ENDPOINTCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, XmlSerialName("EndpointCount"))
    val GRANTEE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Grantee"))
    val GRANTOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Grantor"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, XmlSerialName("Status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://redshift.amazonaws.com/doc/2012-12-01/"))
        trait(XmlSerialName("AuthorizeEndpointAccessResult"))
        field(ALLOWEDALLVPCS_DESCRIPTOR)
        field(ALLOWEDVPCS_DESCRIPTOR)
        field(AUTHORIZETIME_DESCRIPTOR)
        field(CLUSTERIDENTIFIER_DESCRIPTOR)
        field(CLUSTERSTATUS_DESCRIPTOR)
        field(ENDPOINTCOUNT_DESCRIPTOR)
        field(GRANTEE_DESCRIPTOR)
        field(GRANTOR_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ALLOWEDALLVPCS_DESCRIPTOR.index -> builder.allowedAllVpcs = deserializeBoolean()
                ALLOWEDVPCS_DESCRIPTOR.index -> builder.allowedVpcs =
                    deserializer.deserializeList(ALLOWEDVPCS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                AUTHORIZETIME_DESCRIPTOR.index -> builder.authorizeTime = deserializeString().let { Instant.fromIso8601(it) }
                CLUSTERIDENTIFIER_DESCRIPTOR.index -> builder.clusterIdentifier = deserializeString()
                CLUSTERSTATUS_DESCRIPTOR.index -> builder.clusterStatus = deserializeString()
                ENDPOINTCOUNT_DESCRIPTOR.index -> builder.endpointCount = deserializeInt()
                GRANTEE_DESCRIPTOR.index -> builder.grantee = deserializeString()
                GRANTOR_DESCRIPTOR.index -> builder.grantor = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { AuthorizationStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
