// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an endpoint authorization for authorizing Redshift-managed VPC endpoint access to a cluster across Amazon Web Services accounts.
 */
public class RevokeEndpointAccessResponse private constructor(builder: Builder) {
    /**
     * Indicates whether all VPCs in the grantee account are allowed access to the cluster.
     */
    public val allowedAllVpcs: kotlin.Boolean? = builder.allowedAllVpcs
    /**
     * The VPCs allowed access to the cluster.
     */
    public val allowedVpcs: List<String>? = builder.allowedVpcs
    /**
     * The time (UTC) when the authorization was created.
     */
    public val authorizeTime: aws.smithy.kotlin.runtime.time.Instant? = builder.authorizeTime
    /**
     * The cluster identifier.
     */
    public val clusterIdentifier: kotlin.String? = builder.clusterIdentifier
    /**
     * The status of the cluster.
     */
    public val clusterStatus: kotlin.String? = builder.clusterStatus
    /**
     * The number of Redshift-managed VPC endpoints created for the authorization.
     */
    public val endpointCount: kotlin.Int? = builder.endpointCount
    /**
     * The Amazon Web Services account ID of the grantee of the cluster.
     */
    public val grantee: kotlin.String? = builder.grantee
    /**
     * The Amazon Web Services account ID of the cluster owner.
     */
    public val grantor: kotlin.String? = builder.grantor
    /**
     * The status of the authorization action.
     */
    public val status: aws.sdk.kotlin.services.redshift.model.AuthorizationStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.RevokeEndpointAccessResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RevokeEndpointAccessResponse(")
        append("allowedAllVpcs=$allowedAllVpcs,")
        append("allowedVpcs=$allowedVpcs,")
        append("authorizeTime=$authorizeTime,")
        append("clusterIdentifier=$clusterIdentifier,")
        append("clusterStatus=$clusterStatus,")
        append("endpointCount=$endpointCount,")
        append("grantee=$grantee,")
        append("grantor=$grantor,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowedAllVpcs?.hashCode() ?: 0
        result = 31 * result + (allowedVpcs?.hashCode() ?: 0)
        result = 31 * result + (authorizeTime?.hashCode() ?: 0)
        result = 31 * result + (clusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (clusterStatus?.hashCode() ?: 0)
        result = 31 * result + (endpointCount ?: 0)
        result = 31 * result + (grantee?.hashCode() ?: 0)
        result = 31 * result + (grantor?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RevokeEndpointAccessResponse

        if (allowedAllVpcs != other.allowedAllVpcs) return false
        if (allowedVpcs != other.allowedVpcs) return false
        if (authorizeTime != other.authorizeTime) return false
        if (clusterIdentifier != other.clusterIdentifier) return false
        if (clusterStatus != other.clusterStatus) return false
        if (endpointCount != other.endpointCount) return false
        if (grantee != other.grantee) return false
        if (grantor != other.grantor) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.RevokeEndpointAccessResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates whether all VPCs in the grantee account are allowed access to the cluster.
         */
        public var allowedAllVpcs: kotlin.Boolean? = null
        /**
         * The VPCs allowed access to the cluster.
         */
        public var allowedVpcs: List<String>? = null
        /**
         * The time (UTC) when the authorization was created.
         */
        public var authorizeTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The cluster identifier.
         */
        public var clusterIdentifier: kotlin.String? = null
        /**
         * The status of the cluster.
         */
        public var clusterStatus: kotlin.String? = null
        /**
         * The number of Redshift-managed VPC endpoints created for the authorization.
         */
        public var endpointCount: kotlin.Int? = null
        /**
         * The Amazon Web Services account ID of the grantee of the cluster.
         */
        public var grantee: kotlin.String? = null
        /**
         * The Amazon Web Services account ID of the cluster owner.
         */
        public var grantor: kotlin.String? = null
        /**
         * The status of the authorization action.
         */
        public var status: aws.sdk.kotlin.services.redshift.model.AuthorizationStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.RevokeEndpointAccessResponse) : this() {
            this.allowedAllVpcs = x.allowedAllVpcs
            this.allowedVpcs = x.allowedVpcs
            this.authorizeTime = x.authorizeTime
            this.clusterIdentifier = x.clusterIdentifier
            this.clusterStatus = x.clusterStatus
            this.endpointCount = x.endpointCount
            this.grantee = x.grantee
            this.grantor = x.grantor
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.RevokeEndpointAccessResponse = RevokeEndpointAccessResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
