// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



/**
 *
 */
public class ModifySnapshotCopyRetentionPeriodRequest private constructor(builder: Builder) {
    /**
     * The unique identifier of the cluster for which you want to change the retention period for either automated or manual snapshots that are copied to a destination Amazon Web Services Region.
     *
     * Constraints: Must be the valid name of an existing cluster that has cross-region snapshot copy enabled.
     */
    public val clusterIdentifier: kotlin.String? = builder.clusterIdentifier
    /**
     * Indicates whether to apply the snapshot retention period to newly copied manual snapshots instead of automated snapshots.
     */
    public val manual: kotlin.Boolean? = builder.manual
    /**
     * The number of days to retain automated snapshots in the destination Amazon Web Services Region after they are copied from the source Amazon Web Services Region.
     *
     * By default, this only changes the retention period of copied automated snapshots.
     *
     * If you decrease the retention period for automated snapshots that are copied to a destination Amazon Web Services Region, Amazon Redshift deletes any existing automated snapshots that were copied to the destination Amazon Web Services Region and that fall outside of the new retention period.
     *
     * Constraints: Must be at least 1 and no more than 35 for automated snapshots.
     *
     * If you specify the `manual` option, only newly copied manual snapshots will have the new retention period.
     *
     * If you specify the value of -1 newly copied manual snapshots are retained indefinitely.
     *
     * Constraints: The number of days must be either -1 or an integer between 1 and 3,653 for manual snapshots.
     */
    public val retentionPeriod: kotlin.Int? = builder.retentionPeriod

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.ModifySnapshotCopyRetentionPeriodRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModifySnapshotCopyRetentionPeriodRequest(")
        append("clusterIdentifier=$clusterIdentifier,")
        append("manual=$manual,")
        append("retentionPeriod=$retentionPeriod")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterIdentifier?.hashCode() ?: 0
        result = 31 * result + (manual?.hashCode() ?: 0)
        result = 31 * result + (retentionPeriod ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModifySnapshotCopyRetentionPeriodRequest

        if (clusterIdentifier != other.clusterIdentifier) return false
        if (manual != other.manual) return false
        if (retentionPeriod != other.retentionPeriod) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.ModifySnapshotCopyRetentionPeriodRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique identifier of the cluster for which you want to change the retention period for either automated or manual snapshots that are copied to a destination Amazon Web Services Region.
         *
         * Constraints: Must be the valid name of an existing cluster that has cross-region snapshot copy enabled.
         */
        public var clusterIdentifier: kotlin.String? = null
        /**
         * Indicates whether to apply the snapshot retention period to newly copied manual snapshots instead of automated snapshots.
         */
        public var manual: kotlin.Boolean? = null
        /**
         * The number of days to retain automated snapshots in the destination Amazon Web Services Region after they are copied from the source Amazon Web Services Region.
         *
         * By default, this only changes the retention period of copied automated snapshots.
         *
         * If you decrease the retention period for automated snapshots that are copied to a destination Amazon Web Services Region, Amazon Redshift deletes any existing automated snapshots that were copied to the destination Amazon Web Services Region and that fall outside of the new retention period.
         *
         * Constraints: Must be at least 1 and no more than 35 for automated snapshots.
         *
         * If you specify the `manual` option, only newly copied manual snapshots will have the new retention period.
         *
         * If you specify the value of -1 newly copied manual snapshots are retained indefinitely.
         *
         * Constraints: The number of days must be either -1 or an integer between 1 and 3,653 for manual snapshots.
         */
        public var retentionPeriod: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.ModifySnapshotCopyRetentionPeriodRequest) : this() {
            this.clusterIdentifier = x.clusterIdentifier
            this.manual = x.manual
            this.retentionPeriod = x.retentionPeriod
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.ModifySnapshotCopyRetentionPeriodRequest = ModifySnapshotCopyRetentionPeriodRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
