// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a Redshift-managed VPC endpoint.
 */
public class ModifyEndpointAccessResponse private constructor(builder: Builder) {
    /**
     * The DNS address of the endpoint.
     */
    public val address: kotlin.String? = builder.address
    /**
     * The cluster identifier of the cluster associated with the endpoint.
     */
    public val clusterIdentifier: kotlin.String? = builder.clusterIdentifier
    /**
     * The time (UTC) that the endpoint was created.
     */
    public val endpointCreateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endpointCreateTime
    /**
     * The name of the endpoint.
     */
    public val endpointName: kotlin.String? = builder.endpointName
    /**
     * The status of the endpoint.
     */
    public val endpointStatus: kotlin.String? = builder.endpointStatus
    /**
     * The port number on which the cluster accepts incoming connections.
     */
    public val port: kotlin.Int? = builder.port
    /**
     * The Amazon Web Services account ID of the owner of the cluster.
     */
    public val resourceOwner: kotlin.String? = builder.resourceOwner
    /**
     * The subnet group name where Amazon Redshift chooses to deploy the endpoint.
     */
    public val subnetGroupName: kotlin.String? = builder.subnetGroupName
    /**
     * The connection endpoint for connecting to an Amazon Redshift cluster through the proxy.
     */
    public val vpcEndpoint: aws.sdk.kotlin.services.redshift.model.VpcEndpoint? = builder.vpcEndpoint
    /**
     * The security groups associated with the endpoint.
     */
    public val vpcSecurityGroups: List<VpcSecurityGroupMembership>? = builder.vpcSecurityGroups

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.ModifyEndpointAccessResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyEndpointAccessResponse(")
        append("address=$address,")
        append("clusterIdentifier=$clusterIdentifier,")
        append("endpointCreateTime=$endpointCreateTime,")
        append("endpointName=$endpointName,")
        append("endpointStatus=$endpointStatus,")
        append("port=$port,")
        append("resourceOwner=$resourceOwner,")
        append("subnetGroupName=$subnetGroupName,")
        append("vpcEndpoint=$vpcEndpoint,")
        append("vpcSecurityGroups=$vpcSecurityGroups")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = address?.hashCode() ?: 0
        result = 31 * result + (clusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (endpointCreateTime?.hashCode() ?: 0)
        result = 31 * result + (endpointName?.hashCode() ?: 0)
        result = 31 * result + (endpointStatus?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (resourceOwner?.hashCode() ?: 0)
        result = 31 * result + (subnetGroupName?.hashCode() ?: 0)
        result = 31 * result + (vpcEndpoint?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroups?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModifyEndpointAccessResponse

        if (address != other.address) return false
        if (clusterIdentifier != other.clusterIdentifier) return false
        if (endpointCreateTime != other.endpointCreateTime) return false
        if (endpointName != other.endpointName) return false
        if (endpointStatus != other.endpointStatus) return false
        if (port != other.port) return false
        if (resourceOwner != other.resourceOwner) return false
        if (subnetGroupName != other.subnetGroupName) return false
        if (vpcEndpoint != other.vpcEndpoint) return false
        if (vpcSecurityGroups != other.vpcSecurityGroups) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.ModifyEndpointAccessResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The DNS address of the endpoint.
         */
        public var address: kotlin.String? = null
        /**
         * The cluster identifier of the cluster associated with the endpoint.
         */
        public var clusterIdentifier: kotlin.String? = null
        /**
         * The time (UTC) that the endpoint was created.
         */
        public var endpointCreateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the endpoint.
         */
        public var endpointName: kotlin.String? = null
        /**
         * The status of the endpoint.
         */
        public var endpointStatus: kotlin.String? = null
        /**
         * The port number on which the cluster accepts incoming connections.
         */
        public var port: kotlin.Int? = null
        /**
         * The Amazon Web Services account ID of the owner of the cluster.
         */
        public var resourceOwner: kotlin.String? = null
        /**
         * The subnet group name where Amazon Redshift chooses to deploy the endpoint.
         */
        public var subnetGroupName: kotlin.String? = null
        /**
         * The connection endpoint for connecting to an Amazon Redshift cluster through the proxy.
         */
        public var vpcEndpoint: aws.sdk.kotlin.services.redshift.model.VpcEndpoint? = null
        /**
         * The security groups associated with the endpoint.
         */
        public var vpcSecurityGroups: List<VpcSecurityGroupMembership>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.ModifyEndpointAccessResponse) : this() {
            this.address = x.address
            this.clusterIdentifier = x.clusterIdentifier
            this.endpointCreateTime = x.endpointCreateTime
            this.endpointName = x.endpointName
            this.endpointStatus = x.endpointStatus
            this.port = x.port
            this.resourceOwner = x.resourceOwner
            this.subnetGroupName = x.subnetGroupName
            this.vpcEndpoint = x.vpcEndpoint
            this.vpcSecurityGroups = x.vpcSecurityGroups
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.ModifyEndpointAccessResponse = ModifyEndpointAccessResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.redshift.model.VpcEndpoint] inside the given [block]
         */
        public fun vpcEndpoint(block: aws.sdk.kotlin.services.redshift.model.VpcEndpoint.Builder.() -> kotlin.Unit) {
            this.vpcEndpoint = aws.sdk.kotlin.services.redshift.model.VpcEndpoint.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
