// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.model



public class DescribeUsageLimitsRequest private constructor(builder: Builder) {
    /**
     * The identifier of the cluster for which you want to describe usage limits.
     */
    public val clusterIdentifier: kotlin.String? = builder.clusterIdentifier
    /**
     * The feature type for which you want to describe usage limits.
     */
    public val featureType: aws.sdk.kotlin.services.redshift.model.UsageLimitFeatureType? = builder.featureType
    /**
     * An optional parameter that specifies the starting point to return a set of response records. When the results of a DescribeUsageLimits request exceed the value specified in `MaxRecords`, Amazon Web Services returns a value in the `Marker` field of the response. You can retrieve the next set of response records by providing the returned marker value in the `Marker` parameter and retrying the request.
     */
    public val marker: kotlin.String? = builder.marker
    /**
     * The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified `MaxRecords` value, a value is returned in a `marker` field of the response. You can retrieve the next set of records by retrying the command with the returned marker value.
     *
     * Default: `100`
     *
     * Constraints: minimum 20, maximum 100.
     */
    public val maxRecords: kotlin.Int? = builder.maxRecords
    /**
     * A tag key or keys for which you want to return all matching usage limit objects that are associated with the specified key or keys. For example, suppose that you have parameter groups that are tagged with keys called `owner` and `environment`. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the usage limit objects have either or both of these tag keys associated with them.
     */
    public val tagKeys: List<String>? = builder.tagKeys
    /**
     * A tag value or values for which you want to return all matching usage limit objects that are associated with the specified tag value or values. For example, suppose that you have parameter groups that are tagged with values called `admin` and `test`. If you specify both of these tag values in the request, Amazon Redshift returns a response with the usage limit objects that have either or both of these tag values associated with them.
     */
    public val tagValues: List<String>? = builder.tagValues
    /**
     * The identifier of the usage limit to describe.
     */
    public val usageLimitId: kotlin.String? = builder.usageLimitId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.redshift.model.DescribeUsageLimitsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeUsageLimitsRequest(")
        append("clusterIdentifier=$clusterIdentifier,")
        append("featureType=$featureType,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords,")
        append("tagKeys=$tagKeys,")
        append("tagValues=$tagValues,")
        append("usageLimitId=$usageLimitId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterIdentifier?.hashCode() ?: 0
        result = 31 * result + (featureType?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        result = 31 * result + (tagKeys?.hashCode() ?: 0)
        result = 31 * result + (tagValues?.hashCode() ?: 0)
        result = 31 * result + (usageLimitId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeUsageLimitsRequest

        if (clusterIdentifier != other.clusterIdentifier) return false
        if (featureType != other.featureType) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false
        if (tagKeys != other.tagKeys) return false
        if (tagValues != other.tagValues) return false
        if (usageLimitId != other.usageLimitId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.redshift.model.DescribeUsageLimitsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier of the cluster for which you want to describe usage limits.
         */
        public var clusterIdentifier: kotlin.String? = null
        /**
         * The feature type for which you want to describe usage limits.
         */
        public var featureType: aws.sdk.kotlin.services.redshift.model.UsageLimitFeatureType? = null
        /**
         * An optional parameter that specifies the starting point to return a set of response records. When the results of a DescribeUsageLimits request exceed the value specified in `MaxRecords`, Amazon Web Services returns a value in the `Marker` field of the response. You can retrieve the next set of response records by providing the returned marker value in the `Marker` parameter and retrying the request.
         */
        public var marker: kotlin.String? = null
        /**
         * The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified `MaxRecords` value, a value is returned in a `marker` field of the response. You can retrieve the next set of records by retrying the command with the returned marker value.
         *
         * Default: `100`
         *
         * Constraints: minimum 20, maximum 100.
         */
        public var maxRecords: kotlin.Int? = null
        /**
         * A tag key or keys for which you want to return all matching usage limit objects that are associated with the specified key or keys. For example, suppose that you have parameter groups that are tagged with keys called `owner` and `environment`. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the usage limit objects have either or both of these tag keys associated with them.
         */
        public var tagKeys: List<String>? = null
        /**
         * A tag value or values for which you want to return all matching usage limit objects that are associated with the specified tag value or values. For example, suppose that you have parameter groups that are tagged with values called `admin` and `test`. If you specify both of these tag values in the request, Amazon Redshift returns a response with the usage limit objects that have either or both of these tag values associated with them.
         */
        public var tagValues: List<String>? = null
        /**
         * The identifier of the usage limit to describe.
         */
        public var usageLimitId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.redshift.model.DescribeUsageLimitsRequest) : this() {
            this.clusterIdentifier = x.clusterIdentifier
            this.featureType = x.featureType
            this.marker = x.marker
            this.maxRecords = x.maxRecords
            this.tagKeys = x.tagKeys
            this.tagValues = x.tagValues
            this.usageLimitId = x.usageLimitId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.redshift.model.DescribeUsageLimitsRequest = DescribeUsageLimitsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
