// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.transform

import aws.sdk.kotlin.services.redshift.model.Cluster
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.sdk.kotlin.services.redshift.model.RestoreFromClusterSnapshotResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class RestoreFromClusterSnapshotOperationDeserializer: HttpDeserialize<RestoreFromClusterSnapshotResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): RestoreFromClusterSnapshotResponse {
        if (!response.status.isSuccess()) {
            throwRestoreFromClusterSnapshotError(context, response)
        }
        val builder = RestoreFromClusterSnapshotResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeRestoreFromClusterSnapshotOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwRestoreFromClusterSnapshotError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessToSnapshotDenied" -> AccessToSnapshotDeniedFaultDeserializer().deserialize(context, wrappedResponse)
        "ClusterAlreadyExists" -> ClusterAlreadyExistsFaultDeserializer().deserialize(context, wrappedResponse)
        "ClusterParameterGroupNotFound" -> ClusterParameterGroupNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "ClusterQuotaExceeded" -> ClusterQuotaExceededFaultDeserializer().deserialize(context, wrappedResponse)
        "ClusterSecurityGroupNotFound" -> ClusterSecurityGroupNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "ClusterSnapshotNotFound" -> ClusterSnapshotNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "ClusterSubnetGroupNotFoundFault" -> ClusterSubnetGroupNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "DependentServiceRequestThrottlingFault" -> DependentServiceRequestThrottlingFaultDeserializer().deserialize(context, wrappedResponse)
        "DependentServiceUnavailableFault" -> DependentServiceUnavailableFaultDeserializer().deserialize(context, wrappedResponse)
        "HsmClientCertificateNotFoundFault" -> HsmClientCertificateNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "HsmConfigurationNotFoundFault" -> HsmConfigurationNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "InsufficientClusterCapacity" -> InsufficientClusterCapacityFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidClusterSnapshotState" -> InvalidClusterSnapshotStateFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidClusterSubnetGroupStateFault" -> InvalidClusterSubnetGroupStateFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidClusterTrack" -> InvalidClusterTrackFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidElasticIpFault" -> InvalidElasticIpFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidReservedNodeState" -> InvalidReservedNodeStateFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidRestore" -> InvalidRestoreFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidSubnet" -> InvalidSubnetDeserializer().deserialize(context, wrappedResponse)
        "InvalidTagFault" -> InvalidTagFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidVPCNetworkStateFault" -> InvalidVpcNetworkStateFaultDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededFault" -> LimitExceededFaultDeserializer().deserialize(context, wrappedResponse)
        "NumberOfNodesPerClusterLimitExceeded" -> NumberOfNodesPerClusterLimitExceededFaultDeserializer().deserialize(context, wrappedResponse)
        "NumberOfNodesQuotaExceeded" -> NumberOfNodesQuotaExceededFaultDeserializer().deserialize(context, wrappedResponse)
        "ReservedNodeAlreadyExists" -> ReservedNodeAlreadyExistsFaultDeserializer().deserialize(context, wrappedResponse)
        "ReservedNodeAlreadyMigrated" -> ReservedNodeAlreadyMigratedFaultDeserializer().deserialize(context, wrappedResponse)
        "ReservedNodeNotFound" -> ReservedNodeNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "ReservedNodeOfferingNotFound" -> ReservedNodeOfferingNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "SnapshotScheduleNotFound" -> SnapshotScheduleNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "TagLimitExceededFault" -> TagLimitExceededFaultDeserializer().deserialize(context, wrappedResponse)
        "UnauthorizedOperation" -> UnauthorizedOperationDeserializer().deserialize(context, wrappedResponse)
        "UnsupportedOperation" -> UnsupportedOperationFaultDeserializer().deserialize(context, wrappedResponse)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeRestoreFromClusterSnapshotOperationBody(builder: RestoreFromClusterSnapshotResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("RestoreFromClusterSnapshotResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("RestoreFromClusterSnapshotResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap RestoreFromClusterSnapshot response")
    }
    // end unwrap response wrapper

    val CLUSTER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("Cluster"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://redshift.amazonaws.com/doc/2012-12-01/"))
        trait(XmlSerialName("RestoreFromClusterSnapshotResult"))
        field(CLUSTER_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CLUSTER_DESCRIPTOR.index -> builder.cluster = deserializeClusterDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
