// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.redshift.transform

import aws.sdk.kotlin.services.redshift.model.PurchaseReservedNodeOfferingResponse
import aws.sdk.kotlin.services.redshift.model.RedshiftException
import aws.sdk.kotlin.services.redshift.model.ReservedNode
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class PurchaseReservedNodeOfferingOperationDeserializer: HttpDeserialize<PurchaseReservedNodeOfferingResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): PurchaseReservedNodeOfferingResponse {
        if (!response.status.isSuccess()) {
            throwPurchaseReservedNodeOfferingError(context, response)
        }
        val builder = PurchaseReservedNodeOfferingResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializePurchaseReservedNodeOfferingOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwPurchaseReservedNodeOfferingError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RedshiftException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ReservedNodeAlreadyExists" -> ReservedNodeAlreadyExistsFaultDeserializer().deserialize(context, wrappedResponse)
        "ReservedNodeOfferingNotFound" -> ReservedNodeOfferingNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "ReservedNodeQuotaExceeded" -> ReservedNodeQuotaExceededFaultDeserializer().deserialize(context, wrappedResponse)
        "UnsupportedOperation" -> UnsupportedOperationFaultDeserializer().deserialize(context, wrappedResponse)
        else -> RedshiftException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePurchaseReservedNodeOfferingOperationBody(builder: PurchaseReservedNodeOfferingResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("PurchaseReservedNodeOfferingResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("PurchaseReservedNodeOfferingResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap PurchaseReservedNodeOffering response")
    }
    // end unwrap response wrapper

    val RESERVEDNODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("ReservedNode"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://redshift.amazonaws.com/doc/2012-12-01/"))
        trait(XmlSerialName("PurchaseReservedNodeOfferingResult"))
        field(RESERVEDNODE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                RESERVEDNODE_DESCRIPTOR.index -> builder.reservedNode = deserializeReservedNodeDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
